#ifndef QTERMWINDOW_H
#define QTERMWINDOW_H

#include <qmainwindow.h>

#include "qtermtextline.h"
#include <qlist.h>
class QTermScreen;
class QTermTelnet;
class QTermScreenMgr;
class QTermDecode;
class QTermTextLine;
class colorDialog;
class msgDialog;

class QString;
class QMessageBox;
class QToolBar;
class QObject;
class QEvent;
class QMultiLineEdit;
class QFontDialog;

class QTermWindow: public QMainWindow
{
    Q_OBJECT
public:
    QTermWindow( QWidget* parent, const char* name, int wflags );
    ~QTermWindow();

//    void initWorkingDir();
    void initSettings();
    void initTextLineList();
    void resetTelnetParam();
    void doAutoLogin();
    void changeCursor();
protected:
    void keyPressEvent(QKeyEvent *e);
    bool event(QEvent *);
    void mouseEnter();
    void mouseLeave();
    void mousePress();
    void mouseRelease();
//    virtual void focusInEvent(QFocusEvent *);
    void mouseMove();
    virtual void closeEvent(QCloseEvent *);
     // Added by hwang
    void mouseDblClick();
    // 

    void connectionClosed();
    void errorConnection();
    void connected();
public slots:
    void copy();
    void paste();
    void copyArticle();
    void selectRect();
    void font();
    void color();
    void disconnect();
    void reconnect();
    void refresh();
    void antiIdle();
    void autoReply();
    void viewMessage();
    void enableMouse();
    void beep();
   
    void readTelnet(int);
    void TelnetState(int);
    
    void idleProcess();
    void judgeState(int);
    int  waitForNewPage(int timeout);
    void setParam(const QStringList&);
    void blinkTab();
    void pageNotComplete();
signals:
    void message(const QString&, int );

public:
    QString filename;
    QMessageBox *  qbox;
    QMultiLineEdit * medit;
    QToolBar *mdiconnectTools;
    QTermScreen* screen;
    QPoint mousePoint;
    static char direction[][5];
    int  blinkTimerID;
    bool bBlink;
    QTimer *idleTimer,*timeoutTimer,*blinkTimer;
    int  caretX,caretY;
    int  mouseX,mouseY;
    int  beginX,beginY,endX,endY;
    bool bBellReceive;
    short defaultAttr;
    int  nBlinkTime;
    int  nIdleTime;
    bool bIdle;
    char cIdleChar;
    bool bStartReply;
    bool bAutoReply;
    bool bBeep;
    bool bMouse;
    QCString cstrAutoReply;
    QTermTextLine* currentLine;
    QList<QTermTextLine> lineList;
    QTermTelnet *pTelnet;
    QTermScreenMgr *bbs;
    QTermDecode *decode;
    colorDialog *colordlg;
    msgDialog * msgdlg;
    QToolButton * mditoolDisconnect;
    QToolButton * mdieditCopyArticle;

public:
    QString strSubDir;
    bool bMsgComing;
    QString strHostName;
    QString strPort;
    QString strPreLogin;
    QString strUserName;
    QString strPassword;
    QString strCurrentPos;
    QString strMessage;
    int  nSelectLine;
    int  nPageState;
    char cMenu;
    int  nMenuStart,nMenuLength;
    int  bPageComplete;
    bool bIsLogin; 
    QStringList addrParam;
    QFontDialog* fontdlg;

        // Added by hwang
    QCursor prevArrow, nextArrow, exitArrow,homeArrow,endArrow,pageupArrow,pagedownArrow;
    int urlY, urlBeginX, urlEndX;
    const char *url;
    int protocol;
    // End of addition
   
    int arrowState;
};

#endif


