/*******************************************************************************
FILENAME:      qtermwindow.cpp
REVISION:      2001.8.12 first created.
         
AUTHOR:        kingson fiasco
*******************************************************************************/
/*******************************************************************************
                                    NOTE
 This file may be used, distributed and modified without limitation.
 *******************************************************************************/
#include "qtermwindow.h"
#include "qterm.h"
#include "qtermwndmgr.h"
#include <qapplication.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qmainwindow.h>
#include <qmultilineedit.h>
#include <stdio.h>
#include <qevent.h>
#include "global.h"
#include "qtermscreen.h"
#include "qtermdecode.h"
#include "qtermtelnet.h"
#include "qtermscreenmgr.h"
#include "qtermtextline.h"
#include "sysconfig.h"
#include "colordialog.h"
#include "msgdialog.h"
#include "copyarticle.h"

#include <qclipboard.h>
#include <qsound.h>
#include <qstring.h>
#include <qpainter.h>
#include <qpoint.h>
#include <qtimer.h>
#include <errno.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
//#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <qmessagebox.h>
#include <qpixmap.h>
#include <qbitmap.h>
#include <qregion.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qcursor.h>
#include <qtooltip.h>
#include <qapplication.h>
#include <qfontdialog.h>
#include <qfont.h>
#include <qstatusbar.h>


extern QString pathLib;

/********************************************************************/

// Added by hwang
// 
#include <ctype.h>
#include <qinputdialog.h>

inline bool isInvalidUrlChar(char ch)
{
	static char illChars[] = ",;'\"()[]<>^";	
	return ch>'z' || ch<'#' || strchr(illChars, ch) !=NULL;
}

// if not a valid url string, return 0;
// else return static buffer that contains the url string
//
enum {
	URL_HTTP = 1,
	URL_FTP = 2,
	URL_MAILTO = 3,
	URL_TELNET = 4,
};

/* mouseInUrlLink:
 * 	determine whether cursor pointing a url string
 * args:
 * 	strLine - unicode string that maybe contain a valid url substring, should turn into ascii string first!
 * 	at - cursor position
 * 	proto - returned protocol, may be URL_HTTP, URL_FTP, URL_MAILTO, or URL_TELNET
 * 	beginX - returned url substring start position in strLine's ascii form
 * 	endX - returned url substring end position in strLine's ascii form
 * return:
 * 	NULL - no url string found
 * 	otherwise - point to ascii url string	
 */
const char* mouseInUrlLink(const QString& strLine, int at, int* proto, int *beginX, int *endX)
{
	static const char http[] = "http://";
	static const char ftp[] = "ftp://";
	static const char mailto[] = "mailto:";
	static const char telnet[] = "telnet://";

	static char url[80];
	char	line[100];
	char	lcline[100];	// lower case
	uint 	i, j;
	const char *begin, *end, *host, *dot, *ata, *pchar;
	char *pchar2;
	
	// ASSERT: 0<at<80
	
	// convert Unicode to Ascii
	for (i=0, j=0; i<strLine.length(); i++)
	{
		if(strLine.constref(i).row() == '\0')
		{
			lcline[j++] = tolower(line[j] = strLine.constref(i).cell());
		}
		else
		{
			lcline[j++] = line[j] = strLine.constref(i).cell();
			lcline[j++] = line[j] = strLine.constref(i).row();
		}
	}
	lcline[j] = line[j] = '\0';

	if ((uint)at > j) 
		return NULL;
	
	for (pchar=lcline+at; pchar>=lcline && !isInvalidUrlChar(*pchar); pchar--);
	pchar++;
	for (pchar2=lcline+at; pchar2<=lcline+80 && !isInvalidUrlChar(*pchar2); pchar2++);
	*pchar2 = '\0';
	end = pchar2;
	
	if ((begin = strstr(pchar, http)) != NULL)
	{
		if (begin-lcline > at)
			return NULL;
		host = url + 7;
		*proto = URL_HTTP;
		goto FOUND_BEGIN;
	}
	if ((begin = strstr(pchar, ftp)) != NULL)
	{
		if (begin-lcline > at)
			return NULL;
		host = url + 6;
		*proto = URL_FTP;
		goto FOUND_BEGIN;
	}
	if ((begin = strstr(pchar, mailto)) != NULL)
	{		
		if (begin-lcline > at)
			return NULL;
		if ((ata = strchr(begin+9, '@')) == NULL)
			return NULL;
		host = ata + 1;
		*proto = URL_MAILTO;
		goto FOUND_BEGIN;
	}
	if ((begin = strstr(pchar, telnet)) != NULL)
	{
		if (begin-lcline > at)
			return NULL;
		host = url + 9;
		*proto = URL_TELNET;
		goto FOUND_BEGIN;
	}
	begin = pchar;
	if ((ata = strchr(begin+1, '@')) != NULL)
	{
		host = url+(ata-begin)+1;
		*proto = URL_MAILTO;
	}
	else
	{
		host = url;
		*proto = URL_HTTP;
	}
	
FOUND_BEGIN:
	if (end - begin < 7) // too short
		return NULL;

	*beginX = begin-lcline;
	*endX = end-lcline-1;

	strncpy(url, begin-lcline+line, end-begin);
	url[end-begin] = '\0';
	end += url-begin;
	begin = url;

	//printf("url = %s\n", url);
	
	for (pchar=host, dot=host-1, i=0; pchar<end && *pchar!='/'; pchar++)
	{
		if (*pchar == '.')
		{
			if (pchar <= dot + 1) // xxx..x is illegal
				return NULL;
			dot = pchar;
			i++;
		}
		else 
		{
			if (!isalnum(*pchar) && *pchar!='-' && *pchar!='_')
				return NULL;
		}
	}
	
	if (*(pchar-1) == '.')
		return NULL;
	if (i<2 && *proto == URL_HTTP && strncmp(url, http, 7))
		return NULL;
	if ((*proto == URL_MAILTO || *proto == URL_TELNET) && pchar != end)
		return NULL;

	return url;
}


/******************************************************/

QTermWindow::QTermWindow( QWidget* parent, const char* name, int wflags )
    : QMainWindow( parent, name, wflags ),
	// Added by hwang
	prevArrow(QBitmap(pathLib+"cursor/mask.xpm"), QBitmap(pathLib+"cursor/prev.xpm")),
	nextArrow(QBitmap(pathLib+"cursor/mask.xpm"), QBitmap(pathLib+"cursor/next.xpm")),
	exitArrow(QBitmap(pathLib+"cursor/mask.xpm"), QBitmap(pathLib+"cursor/exit.xpm")),
	homeArrow(QBitmap(pathLib+"cursor/mask.xpm"), QBitmap(pathLib+"cursor/home.xpm")),
	endArrow(QBitmap(pathLib+"cursor/mask.xpm"), QBitmap(pathLib+"cursor/end.xpm")),
	pageupArrow(QBitmap(pathLib+"cursor/mask.xpm"), QBitmap(pathLib+"cursor/pageup.xpm")),
	pagedownArrow(QBitmap(pathLib+"cursor/mask.xpm"), QBitmap(pathLib+"cursor/pagedown.xpm")),
	urlY(-1),
	url(NULL)
	// End of addition
{



    QPixmap mdiopenIcon, mdisaveIcon;

    mdiconnectTools = new QToolBar( this, "connect operations" );
    addToolBar( mdiconnectTools, tr( "Connect Operations" ), Top, TRUE );

    // Edit
//    QToolButton * mdieditCopy	=
	    new QToolButton( QPixmap(pathLib+"pic/copy.bmp"), "Copy", QString::null,
			   this, SLOT(copy()), mdiconnectTools, "Copy" );
//    QToolButton * mdieditPaste	=
	    new QToolButton( QPixmap(pathLib+"pic/paste.bmp"), "Paste", QString::null,
			   this, SLOT(paste()), mdiconnectTools, "Paste" );
//    	mdieditCopyArticle	=
	    new QToolButton( QPixmap(pathLib+"pic/down.bmp"), "Copy Article", QString::null,
			   this, SLOT(copyArticle()), mdiconnectTools, "Copy Article" );

     QToolButton * mdieditSelectRect	=
	     new QToolButton( QPixmap(pathLib+"pic/retangle.bmp"), "Rectangle Select Area", QString::null,
			   this, SLOT(selectRect()), mdiconnectTools, "Rectangle Select Area" );
		mdieditSelectRect->setEnabled(FALSE);
		     
     //View
//     QToolButton * mdiviewFont	=
	     new QToolButton( QPixmap(pathLib+"pic/font.bmp"), "Font", QString::null,
			   this, SLOT(font()),  mdiconnectTools, "Font" );
//     QToolButton * mdiviewColor	=
	     new QToolButton( QPixmap(pathLib+"pic/color.bmp"), "Color", QString::null,
			   this, SLOT(color()), mdiconnectTools, "Color" );
     //Tool
     		mditoolDisconnect	=
	     new QToolButton( QPixmap(pathLib+"pic/disconnect.bmp"), "Disconnect", QString::null,
			   this, SLOT(disconnect()), mdiconnectTools, "Disconnect" );
		mditoolDisconnect->setEnabled(FALSE);
//     QToolButton * mditoolReconnect	= 
	     new QToolButton( QPixmap(pathLib+"pic/reconnect.bmp"), "Reconnect", QString::null,
			   this, SLOT(reconnect()), mdiconnectTools, "Reconnect" );
//     QToolButton * mditoolRefresh	= 
	     new QToolButton( QPixmap(pathLib+"pic/refresh.bmp"), "Refresh Screen", QString::null,
			   this, SLOT(refresh()), mdiconnectTools, "Refresh Screen" );
    //Special
      QToolButton * mdispecAntiIdle	= 
	     new QToolButton( QPixmap(pathLib+"pic/anti.bmp"), "Anti-Idle", QString::null,
			   this, SLOT(antiIdle()), mdiconnectTools, "Anti-Idle" );
      mdispecAntiIdle->setToggleButton(TRUE);
      mdispecAntiIdle->setOn(TRUE);
      
     QToolButton * mdispecAutoReply	= 
	     new QToolButton( QPixmap(pathLib+"pic/reply.bmp"), "Auto Reply", QString::null,
			   this, SLOT(autoReply()), mdiconnectTools, "Auto Reply" );
	mdispecAutoReply->setToggleButton(TRUE);

	
//     QToolButton * mdispecViewMessage	= 
	     new QToolButton( QPixmap(pathLib+"pic/message.bmp"), "View Message", QString::null,
			   this, SLOT(viewMessage()), mdiconnectTools, "View Message" );
       QToolButton * mdispecEnableMouse	=
	     new QToolButton( QPixmap(pathLib+"pic/mouse.bmp"), "Enable Mouse Support", QString::null,
			   this, SLOT(enableMouse()), mdiconnectTools, "Enable Mouse Support" );
        mdispecEnableMouse->setToggleButton(TRUE);
        mdispecEnableMouse->setOn(TRUE);
       
	QToolButton * mdispecBeep=
	   	new QToolButton( QPixmap(pathLib+"pic/beep.bmp"), "Beep When Message Coming", QString::null,
			   this, SLOT(beep()), mdiconnectTools, "Beep When Message Coming" );
	mdispecBeep->setToggleButton(TRUE);
        mdispecBeep->setOn(TRUE);
        
	installEventFilter(this);

//        initWorkingDir();

	initTextLineList();
	initSettings();

	blinkTimerID = startTimer( nBlinkTime );

	decode = new QTermDecode( &lineList );

	bbs = new QTermScreenMgr( &lineList );

	pTelnet = new QTermTelnet;
	
	connect( pTelnet, SIGNAL( readyRead( int ) ), this, SLOT( readTelnet( int ) ) );
	connect( pTelnet, SIGNAL( TelnetState(int) ), this, SLOT( TelnetState(int) ) );

	nPageState = -1;
	nSelectLine = -1;
	cMenu = 0;

	bIsLogin = false;
	bIdle = true;
	bAutoReply = false;
        bMouse = true;
        bBeep = true;
       
	arrowState=0;
                
	idleTimer = new QTimer;
	connect( idleTimer, SIGNAL( timeout() ), this, SLOT( idleProcess() ) );
	idleTimer->changeInterval( nIdleTime );	// think

	timeoutTimer = new QTimer;
	connect( timeoutTimer, SIGNAL( timeout() ), this, SLOT( pageNotComplete() ) );

	blinkTimer=new QTimer;
	connect( blinkTimer,SIGNAL(timeout()),this,SLOT(blinkTab()));

	resetTelnetParam();

	statusBar()->setSizeGripEnabled(false);
	statusBar()->message( tr( "Not Connected" ) );

}

QTermWindow::~QTermWindow()
{
	delete screen;

	delete timeoutTimer;

	delete idleTimer;

	delete blinkTimer;

	if(pTelnet!=NULL)
		delete pTelnet;

	delete decode;

}




void QTermWindow::copy( )
{
	QClipboard *clipboard = QApplication::clipboard();
	if(screen->bSelected)
		clipboard->setText(screen->strSelectText);
//	printf("copy\n");
}

void QTermWindow::paste( )
{
	QClipboard *clipboard = QApplication::clipboard();
	QString strText=clipboard->text().local8Bit();
	pTelnet->write(strText,strText.length());
//	printf("paste\n");
}

void QTermWindow::copyArticle( )
{
	QTermTextLine *line;
	QString strArticle;

	QString strCurrent0,strCurrent1;
	QString strTemp;
	
	
	int pos0=-1,pos1=-1;
	

	line=lineList.at(0);
	strArticle+=line->getText();
	strArticle+='\n';

	while(waitForNewPage(4000))
	{
 		strCurrent0=lineList.at(0)->getText();
	        strCurrent1=lineList.at(1)->getText();
	
		strTemp=strCurrent0+'\n'+strCurrent1;
		
		pos0=strArticle.findRev(strTemp);      
		
		if(pos0!=-1)
		{
			pos1=strArticle.find(strCurrent1,pos0);
			if(pos1!=-1)
				strArticle.truncate(pos1);
		}
		
		for(int i=1;i<LINENUM-1;i++)
		{
			line=lineList.at(i);
			strArticle+=line->getText();
			strArticle+='\n';
		}
		
                if( (lineList.at(LINENUM-1)->getText().local8Bit().find("[Ķ]")!=-1)
		  ||(lineList.at(LINENUM-1)->getText().local8Bit().find("[Ķ]")!=-1)
		  ||(lineList.at(LINENUM-1)->getText().local8Bit().find("R[]")!=-1) 
		  ||(lineList.at(LINENUM-1)->getText().local8Bit().find("κμ")!=-1) )
	              break;		
		pTelnet->write( direction[6], 3 );
		
	}

	CopyArticle ca;
	ca.articleMle->setText(strArticle);
	ca.exec();



//	QClipboard *clipboard = QApplication::clipboard();
//		clipboard->setText(strArticle);

//	printf("copy article\n");
}

void QTermWindow::selectRect( )
{
	printf("rectangle select area\n");
}


void QTermWindow::font( )
{	
	bool ok;
	
	QResizeEvent* re =new QResizeEvent(screen->size(),screen->size());
	
	QFont font=fontdlg->getFont(&ok,*screen->m_font);
	if(ok==true)
	{
                screen->m_font->setFamily(font.family());
                screen->painter->setFont(*(screen->m_font) );
                QApplication::postEvent(screen,re);
//		screen->refreshWin();
	}
//	printf("font\n");
}


void QTermWindow::color( )
{       
	int r,g,b;
	colordlg=new colorDialog(this);
	colordlg->fgColor=addrParam[FGCOLOR];
	sscanf( colordlg->fgColor,"%d %d %d",&r,&g,&b);
	colordlg->colorFg=QColor(r,g,b);	
	colordlg->bgColor=addrParam[BGCOLOR];
	sscanf( colordlg->bgColor,"%d %d %d",&r,&g,&b);	
	colordlg->colorBg=QColor(r,g,b);
	colordlg->repaint();

	if(colordlg->exec()==1)
	{
              screen->m_color[7]=colordlg->colorFg;
              screen->m_color[0]=colordlg->colorBg;             
              screen->refreshWin();

	}
	delete colordlg;	
	
//	printf("color\n");
}
void QTermWindow::disconnect( )
{
	
	pTelnet->close();

	mditoolDisconnect->setEnabled(FALSE);

	bIsLogin = false;

	statusBar()->message( tr("connection closed") );

	connectionClosed();
	
//	printf("disconnect\n");
}

void QTermWindow::reconnect( )
{
	if(!bIsLogin)	
	{	strHostName=addrParam[ADDR];

		setCaption(QString::fromLocal8Bit(addrParam[NAME]));
		
		if ( !addrParam[ADDR].isEmpty() )
		{
			if ( addrParam[PORT].isEmpty() )
				addrParam[PORT] = "23";

			pTelnet->connectHost( addrParam[ADDR], addrParam[PORT].toInt() );

           
		}
	}
	else
	{
			((QTerm* )( qApp->mainWidget()))->addrParam=addrParam;
	   		((QTerm* )( qApp->mainWidget()))->newWindow();
	
	}
//printf("reconnect\n");
}

void QTermWindow::refresh( )
{
	
	char ch = 'l';
	ch &= 0x1f;
//	pTelnet->write( &ch, 1 );
	
	screen->refreshWin();
	printf("refresh screen\n");
}

void QTermWindow::antiIdle( )
{
	bIdle=!bIdle;
//	printf("anti-idle\n");
}

void QTermWindow::autoReply( )
{
	bAutoReply=!bAutoReply;
//	printf("auto reply\n");
}

void QTermWindow::viewMessage( )
{
	msgdlg = new msgDialog(this);

	msgdlg->strMessage=strMessage;

	msgdlg->exec();

	delete msgdlg;
	
//	printf("view message\n");
}

void QTermWindow::enableMouse( )
{

	bMouse=!bMouse;
	screen->bMouseSupp=!screen->bMouseSupp;
	
//	printf("enable mouse support\n");
}

void QTermWindow::beep()
{
	bBeep=!bBeep;
//	printf("enable bepp when message coming\n");
}

///kingson
char QTermWindow::direction[][5] =
{
	"\x1b[1~",
	"\x1b[4~",
	"\x1b[5~",
	"\x1b[6~",

	"\x1b[A",
	"\x1b[B",
	"\x1b[C",
	"\x1b[D"
};

/*void QTermWindow::initWorkingDir()
{
	char * home;
	char wd[BUFSIZE];

	if ( ( home = getenv("HOME")) == NULL ) {
		fprintf(stderr, "Can't get environment variable 'HOME'\n");
		exit(-1);
	}

	memset( wd, 0, BUFSIZE );
	strncpy( wd, home, BUFSIZE - 1 );
	strncat( wd, "/.qterm", 7 );

	struct stat st;
	if ( stat( wd, &st ) < 0 ) {
		if (errno == ENOENT) { 	  // no directory
			if (mkdir(wd,0700) < 0) {
       			fprintf(stderr,"Can't create config directory (%s)!", wd );
       			exit(-1);
			}
		}else {
			fprintf(stderr,"Can't open config directory (%s)!", wd );
			exit(-1);
		}
	}else if( !S_ISDIR(st.st_mode)) {
		fprintf(stderr,"%s is not a directory!", wd );
		exit(-1);
	}

	chdir( wd );

	return;
}*/

void QTermWindow::initSettings()
{


	{
		nBlinkTime = 500;
	}


// idleTime
	{
		nIdleTime = 3000 * 60;
	}


	cIdleChar = 'l';	
	bStartReply = false;
	bMsgComing = false;
	strMessage = "";
}

void QTermWindow::resetTelnetParam()
{

	addrParam.clear();
	
	bPageComplete = 0;
}



void QTermWindow::initTextLineList()
{
	lineList.setAutoDelete( true );

	if ( !lineList.isEmpty() )
		lineList.clear();

	while ( lineList.count() < LINENUM )
		lineList.append( new QTermTextLine(0) );
}

void QTermWindow::keyPressEvent( QKeyEvent *e )
{

	if ( !bIsLogin && e->key() == Key_Return )
        {
        	reconnect();
		return;
        }

	//stop it if blinking
	if(blinkTimer->isActive())
	{
		blinkTimer->stop();
		 ((QTerm* )( qApp->mainWidget()))->wndmgr->blinkTheTab(this,TRUE);

	}

	
	// just for debug
	if ( e->key() == Key_F7 )
	{
		screen->refreshWin();
		return;
	}

	// restart idleTimer after press any key
	// if not press key for nIdleTime ms, it begins anti idle
	if ( bIdle )
		idleTimer->changeInterval( nIdleTime );
	else
		idleTimer->stop();

	bStartReply = false;

	if ( e->state() & ControlButton )	// CTRL+CHAR
	{
		if ( e->key() >= Key_A && e->key() <= Key_Z )
		{
			char ch = e->key() & 0x1f;
			pTelnet->write( &ch, 1 );
			return;
		}
	}

	// left, right, up, down, pageup, pagedown, home, end

	switch ( e->key() )
	{
	case Key_Left:
		pTelnet->write( direction[7], 3 );
		return;
	case Key_Right:
		pTelnet->write( direction[6], 3 );
		return;
	case Key_Up:
		pTelnet->write( direction[4], 3 );
		return;
	case Key_Down:
		pTelnet->write( direction[5], 3 );
		return;

	case Key_Home:
		pTelnet->write( direction[0], 4 );
		return;
	case Key_End:
		pTelnet->write( direction[1], 4 );
		return;
	case Key_PageUp:
		pTelnet->write( direction[2], 4 );
		return;
	case Key_PageDown:
		pTelnet->write( direction[3], 4 );
		return;

	default:
		break;
	}

	// send normal input characters
	QCString cstr;
	if ( e->text().length() )
	{
		cstr = e->text().local8Bit();
		pTelnet->write( cstr, cstr.length() );
		return;
	}
}

void QTermWindow::pageNotComplete() 
{       
	        bPageComplete = -2;     // page not complete but time out
}



bool QTermWindow::event( QEvent *e )
{

        	
            if ( e->type() == QEvent::KeyPress || e->type() == QEvent::KeyRelease )
	    {

		   if ( ((QKeyEvent*) e)->key() == Key_Tab || ((QKeyEvent*) e)->key() == Key_Backtab )
		  {
			        keyPressEvent( (QKeyEvent* )e );
			        return false;
		   }
            }

          else
                if(e->type()==QEvent::FocusIn)
	          {
//		   printf(caption()+"  FocusIn\n");
		   ((QTerm* )( qApp->mainWidget()))->wndmgr->activateTheTab(this);
	          }
//	          else if(e->type()==QEvent::Close)
//	          {
//		    printf(caption()+"  Close\n");
//		   ((QTerm* )( qApp->mainWidget()))->wndmgr->removeWindow(this);
//	          }
          
       

    return QWidget::event( e );
}

/*void QTermWindow::focusInEvent(QFocusEvent *)
{
//	 printf(caption()+"  FocusIn\n");
	 ((QTerm* )( qApp->mainWidget()))->wndmgr->activateTheTab(this);
}*/


void QTermWindow::idleProcess()
{
	if ( !bIsLogin )
		return;

	if ( bIdle==true )
	{
		char ch=addrParam[ANTIIDLESTRING].ref(1);
		ch&=0x1f;
	        pTelnet->write( &ch, 1 );
//		printf("anti idle processing");
	}
	if ( bAutoReply )
		bStartReply = true;
}

void QTermWindow::judgeState( int mouseState )
{
	if ( !bIsLogin )
	{
		return;
	}
	mouseX = screen->getMouseX();
	mouseY = screen->getMouseY();
	bbs->setMousePos( mouseX, mouseY );


	switch ( mouseState )
	{
	case 0:
		mouseEnter();
		break;
	case 1:
		mouseMove();
		break;
	case 2:
		mousePress();
		break;
	case 3:
		mouseRelease();
		break;
	case 4:
		mouseLeave();
	default:
		break;
	}
}

void QTermWindow::mouseEnter()
{
    	// Added by hwang;
	urlY = -1;
	// End of addition	
}


void QTermWindow::mouseMove()
{

	nPageState = bbs->getPageState();
	nSelectLine = bbs->getSelectLine();
	nMenuLength = bbs->getMenuPos( &nMenuStart );

	screen->setPageState( nPageState, nSelectLine, nMenuStart, nMenuLength );

	int state = arrowState;

    // Added by hwang
	if (urlY == mouseY && urlBeginX <= mouseX && mouseX <= urlEndX)
		setCursor(pointingHandCursor);
	else 
	{
		url = mouseInUrlLink(lineList.at(mouseY)->getText(), mouseX, &protocol, &urlBeginX, &urlEndX);
		if (url != NULL)
		{
			urlY = mouseY;
			setCursor(pointingHandCursor);
		}
		else
		{
			urlY = -1;
	/*
	 *	______________________________
	 *	|   |        2                |
	 *	|   |-------------------------|
	 *	|   |			|     |
	 *	|   |			|  4  |
	 *	| 1 |		0	|     |
	 *	|   |			|-----|
	 *	|   |			|  5  |
	 *	|   |			|     |
	 *	|   |-------------------------|
	 *	|   |	    3  		      |
	 *	------------------------------|
	 *
	 *
	 */
			
			if( mouseX<12 )
			{
				setCursor( exitArrow );
				arrowState=1;
			}
			else if( mouseY<3 )
			{
				setCursor( homeArrow );
				arrowState=2;
			}
			else if( mouseY>LINENUM-2 )
			{
				setCursor( endArrow );
				arrowState=3;
			}
			else if( mouseX>LINECHARNUM-12 && mouseY<=LINENUM/2 )
			{
				setCursor( prevArrow );
				arrowState=4;
			}
			else if( mouseX>LINECHARNUM-12 && mouseY>LINENUM/2 )
			{
				setCursor( nextArrow );
				arrowState=5;
			}
			else 
			{
				setCursor(arrowCursor);
				arrowState=0;
			}
		}
	}
	// End of addition
	if( arrowState==0 || arrowState!=state )
		screen->blinkWin();
}

/*    remove 
void QTermWindow::changeCursor()
{

	QBitmap bitmap, m_bitmap;
	QCursor m_cursor = QCursor( arrowCursor );

	// when move mouse near border, change cursor shape
	// all bitmap that cursor needed is at cursor/
	if ( mouseY < 2 )
	{
		bitmap = QBitmap( "cursor/upArrow.bmp" );
		m_bitmap = QBitmap( "cursor/m_upArrow.bmp" );
	}
	if ( mouseY > LINENUM - 2 )
	{
		bitmap = QBitmap( "cursor/downArrow.bmp" );
		m_bitmap = QBitmap( "cursor/m_downArrow.bmp" );
	}
	if ( mouseX < 5 )
 	{
 		bitmap = QBitmap( "cursor/leftArrow.bmp" );
 		m_bitmap = QBitmap( "cursor/m_leftArrow.bmp" );
	}

	if ( !bitmap.isNull() )
	{
		if ( m_bitmap.isNull() )
			m_bitmap = bitmap;

		m_cursor = QCursor( bitmap, m_bitmap );
	}

	setCursor( m_cursor );

}
*/

void QTermWindow::mousePress()
{
	beginX = mouseX;
	beginY = mouseY;

	//stop it if blinking
	if(blinkTimer->isActive())
	{
		blinkTimer->stop();
		((QTerm* )( qApp->mainWidget()))->wndmgr->blinkTheTab(this,TRUE);
	}

}

void QTermWindow::mouseRelease()
{
	// like key press, restart idleTimer
	if ( bIdle )
		idleTimer->changeInterval( nIdleTime );
	else
		idleTimer->stop();
	bStartReply = false;

	if ( beginX != mouseX || beginY != mouseY )
	{
		endX = mouseX;
		endY = mouseY;

		return;
	}

    
	// Added by hwang
	if (urlY == mouseY &&  urlBeginX <= mouseX && mouseX <= urlEndX)
	{
		bool ok;
		QString caption, hint;
		
		
		switch (protocol)
		{
		case URL_HTTP:
			caption = "HTTP link";
			break;
		case URL_FTP:
			caption = "FTP link";
			break;
		case URL_MAILTO:
			caption = "Mail to";
			break;
		case URL_TELNET:
			caption = "telnet";
		}
		
		hint = "Copy to clipboard";
		QString strUrl = QInputDialog::getText(caption, hint, QString(url), &ok);
		if (ok)
		{
			QApplication::clipboard()->setText(strUrl);
		}
		return;
	}
	// End of addition


	// back to last page
	if ( arrowState==1 )
	{
		pTelnet->write( direction[7], 4 );
		return;
	}
	//home 
	if( arrowState==2 )
	{
		pTelnet->write( direction[0], 4 );
		return;
	}
	if( arrowState==3 )
	{
		pTelnet->write( direction[1], 4 );
		return;
	}
	// page up
	if ( arrowState==4 )
	{
		pTelnet->write( direction[2], 4 );
		return;
	}

	// page down
	if ( arrowState==5 )
	{
		pTelnet->write( direction[3], 4 );
		return;
	}

	char ch = CHAR_CR;
	int n;


	switch ( nPageState )
	{
	case -1:		// can not select
		break;

	case 0:			// menu, select without caret
		if ( nSelectLine/*getSelectLine()*/ == -1 )
			break;

		cMenu = bbs->getMenuChar();
		pTelnet->write( &cMenu, 1 );
		pTelnet->write( &ch, 1 );
		return;

	case 1:			// list, select base caret
		if ( nSelectLine/*getSelectLine()*/ == -1 )
			break;

		// find how many lines need to scroll
		n = nSelectLine - caretY;

		// scroll lines
		if ( n > 0 )
			while ( n )
			{
				pTelnet->write( direction[5], 4 );
				n--;
			}
		if ( n < 0 )
		{
			n = -n;
			while ( n )
			{
				pTelnet->write( direction[4], 4 );
				n--;
			}
		}

		// don't forget to send a CHAR_CR at last to enter in
		pTelnet->write( &ch, 1 );
		return;

	default:
		break;
	}


}
void QTermWindow::mouseLeave()
{
	setCursor( arrowCursor );
}

int QTermWindow::waitForNewPage( int timeout )
{
	timeoutTimer->changeInterval( timeout );

	while ( !bPageComplete )
		qApp->processEvents( timeout );

	int res = bPageComplete;
	bPageComplete = 0;
	timeoutTimer->stop();

	return res;

}


// slot connected to telnet
// operate data from telnet
void QTermWindow::readTelnet( int size )
{
	char *str = new char[ size + 1 ];
	pTelnet->read( str, size );
	str[size] = '\0';
	decode->ansiDecode( str, size );
	bBellReceive = decode->bellReceive();

	if ( bBellReceive && bBeep )
	{
		if(addrParam[WAVEFILE].isEmpty())
			qApp->beep();
		else
			QSound::play(addrParam[WAVEFILE]);
	}

//blink tab	
	if(bBellReceive && addrParam[BLINKTAB]=="TRUE")
 		blinkTimer->start(500); 
       	
  
	caretX = decode->currentCaretX();
	caretY = decode->currentCaretY();

	if ( decode->pageState() )
		bPageComplete = 1;

	screen->setCurrentCaret( caretX, caretY );
	screen->refreshWin();

	if ( bBellReceive && caretY == 1 )
	{
		strMessage += lineList.at(0)->getText() + "\n";

		if ( bStartReply )
		{
			bMsgComing = true;

			QCString cstr = "r ";
			cstr += cstrAutoReply;
			cstr += '\n';
			pTelnet->write( cstr, cstr.length() );
		}
	}

	bBellReceive = false;

	delete []str;
}

void QTermWindow::connectionClosed(void)
{
	bIsLogin=false;

	for( int i=0;i< LINENUM;i++)
		lineList.at(i)->reset();
	lineList.at(9)->replaceText("                        QTerm  0.1.4 -- Quick Terminal",0x000a);
        lineList.at(11)->replaceText("                        BBS client based on Qt library",0x000a);	
	lineList.at(22)->replaceText("                                              Press enter to reconnect!",0x000f);
	screen->refreshWin();
	mditoolDisconnect->setEnabled(FALSE);

}
void QTermWindow::errorConnection(void)
{
	

}
void QTermWindow::connected(void)
{
	mditoolDisconnect->setEnabled(TRUE);
	bIsLogin = true;
 	doAutoLogin();
 	
}


void QTermWindow::setParam( const QStringList& addr)
{
	addrParam.clear();
	
	addrParam=addr;

	//set bbs code

	for( int n=0; n< LINENUM; n++ )
		lineList.at(n)->setBBSCode( addrParam[BBSCODE].toInt() );
	
	decode->setBBSCode( addrParam[BBSCODE].toInt() );
	
	cstrAutoReply=addrParam[AUTOREPLY].ascii();
	
	strHostName=addrParam[ADDR];


	if ( !addrParam[ADDR].isEmpty() )
	{
		if ( addrParam[PORT].isEmpty() )
			addrParam[PORT] = "23";

		pTelnet->setProxy( addrParam[PROXYENABLE].toInt(),
				addrParam[PROXYUSER].isEmpty()?false:true,
				addrParam[PROXYADDR],addrParam[PROXYPORT].toInt(),
				addrParam[PROXYUSER],addrParam[PROXYPASSWORD] );
				
		pTelnet->connectHost( addrParam[ADDR], addrParam[PORT].toInt() );

           
	}

	screen = new QTermScreen( this ,0,0,addrParam[FGCOLOR],addrParam[BGCOLOR],
			QString::fromLocal8Bit(addrParam[FONT]));
	screen->setTextLineList( &lineList );
	
	if(addrParam[ALWAYSHIGHLIGHT]=="TRUE")
	{
		screen->bAllHighLighted=true;
	}
	else
	{
		screen->bAllHighLighted=false;
	}
	
	setFocusProxy(screen);
	setCentralWidget(screen);

	connect( screen, SIGNAL( mouseAction( int ) ), this, SLOT( judgeState( int ) ) );



}
void QTermWindow::doAutoLogin(void)
{
	
	if(addrParam[AUTOLOGIN]=="0")
	{
		return;
		
	}
	else
	{
	  if( !addrParam[PRELOGIN].isEmpty() ) {
		QCString temp = addrParam[PRELOGIN].local8Bit();
		pTelnet->write( (const char *)(temp), temp.length() );
		char ch=CHAR_CR;
		pTelnet->write( &ch, 1 );
               
//	        printf("prelogin\n");	
        	}
	  if( !addrParam[USER].isEmpty() ) {
		QCString temp = addrParam[USER].local8Bit();
		pTelnet->write( (const char *)(temp), temp.length() );
		char ch=CHAR_CR;
		pTelnet->write( &ch, 1 );
//		printf("usrname: %s\n",addrParam[USER].ascii());
	        }
	   if( !addrParam[PASSWORD].isEmpty() ) {
		QCString temp = addrParam[PASSWORD].local8Bit();
		pTelnet->write( (const char *)(temp), temp.length() );
		char ch=CHAR_CR;
		pTelnet->write( &ch, 1 );
//		printf("passwd");
	       }

	}
	
}

///
void QTermWindow::closeEvent(QCloseEvent *cls)
{
	
    if((bIsLogin==true)&&(addrParam[EXITWARNING]=="TRUE"))
    {
     QMessageBox mb( "QTerm",
                    "Connected,Do you still want to exit?",
                    QMessageBox::Warning,
                    QMessageBox::Yes | QMessageBox::Default,
                    QMessageBox::No  | QMessageBox::Escape ,
                    0,this,0,true);
        if ( mb.exec() == QMessageBox::Yes )
        {
            ((QTerm* )( qApp->mainWidget()))->wndmgr->removeWindow(this);
	    cls->accept();
        }
    }
    else
    {
	((QTerm* )( qApp->mainWidget()))->wndmgr->removeWindow(this);
	cls->accept();
    }
}

      

void QTermWindow::blinkTab()
{
//	printf("blinking	");
	static bool bVisible=TRUE;
	 ((QTerm* )( qApp->mainWidget()))->wndmgr->blinkTheTab(this,bVisible);
	bVisible=!bVisible;
}

// telnet state slot
void QTermWindow::TelnetState(int state)
{
	switch( state )
	{
	case TSRESOLVING:
		statusBar()->message( tr("resolving host name") );
		break;
	case TSHOSTFOUND:
		statusBar()->message( tr("host found") );
		statusBar()->message( tr("connecting...") );
		break;
	case TSHOSTNOTFOUND:
		statusBar()->message( tr("host not found") );
		errorConnection();
		break;
	case TSCONNECTING:
		statusBar()->message( tr("connecting...") );
		break;
	case TSHOSTCONNECTED:
		statusBar()->message( tr("connected") );
		connected();
		break;
	case TSPROXYCONNECTED:
		statusBar()->message( tr("connected to proxy" ) );
		break;
	case TSPROXYAUTH:
		statusBar()->message( tr("proxy authentation") );
		break;
	case TSPROXYFAIL:
		statusBar()->message( tr("proxy failed") );
		break;
	case TSREFUSED:
		statusBar()->message( tr("connection refused") );
		break;
	case TSREADERROR:
		statusBar()->message( tr("error when reading from server") );
		break;
	case TSCLOSED:
		statusBar()->message( tr("connection closed") );
		connectionClosed();
		break;
	case TSCLOSEFINISH:
		statusBar()->message( tr("connection close finished") );
		connectionClosed();
		break;
	case TSCONNECTVIAPROXY:
		statusBar()->message( tr("connect to host via proxy") );
		break;
	case TSEGETHOSTBYNAME:
		statusBar()->message( tr("error in gethostbyname") );
		break;
	case TSEINIWINSOCK:
		statusBar()->message( tr("error in startup winsock") );
		break;
	case TSERROR:
		statusBar()->message( tr("error in connection") );
		break;
	case TSPROXYERROR:
		statusBar()->message( tr("error in proxy") );
		break;
	default:
		break;
	}

}
