#ifndef _QTERMTEXTLINE_H_
#define _QTERMTEXTLINE_H_

#include <qstring.h>
#include "global.h"
class QTermTextLine
{
public:	
	//short currentAttr;
	char currentCP;		// CP means colorpair
	char currentEA;		// EA means extra attribs	
	bool bBlink;		// whether char with blink attribute in the line
	
	int changeStart, changeEnd;	// пܱıλ

private:
	int length;			// Note: this counts by char type
	QCString text;			// ʾı
	
					// Ӧַ
	QCString colorpair;		
	QCString extraAttr;	
	
	// QCString more like char* 
	// and easy to calc char's position
	// you can use it just as char*
	
	// note: QCString can not contain 0
	
	// QCStringַһһӦ

	int nBBSCode;
public:
	QTermTextLine( int nCode );
	~QTermTextLine();

	void setBBSCode( int nCode );
// function: reset
// reset line
	void reset();
	
// !!!!! Note: all positions and length all count by char type ( 1 bype )	!!!!!!!!!!	

// function: getText
// return str in text for show
// if index == -1, get the whole line
// if len == -1, get the rest from index	
	QString getText( int index = -1, int len = -1 );	
	// for Qt use Unicode interface
	// return QString to show
	
	QCString getColorpair()		{ return colorpair; }
	QCString getExtraAttr()		{ return extraAttr; }
	QCString getTextChar()		{ return text; }
	int getLength()				{ return length; }

// function: insertText
// insert cstr at position index of line, 
// if attrib == -1, use current attr,
// if index == -1, append line
	void insertText( const QCString& cstr, short attr = -1, int index = -1 );
	
// function: deleteText
// delete cstr from position index of line, 
// it will delete len chars,  
// if index == -1, delete the whole line
	void deleteText( int index = -1, int len = -1 );
	
// function: replaceText	
// replace the cstring with cstr, which start at index and have len chars,
// if attr == -1, use the current attr,
// if index == -1, reset line and insert cstr.
// if len == -1, replace cstr's length chars.
	void replaceText( const QCString& cstr, short attr = -1, int index = -1, int len = -1 );

// function changeSet	
// endx is the last changed index + 1
	void changeSet( int startx, int endx );
	
	void changeDrawn()	{ changeStart = changeEnd = 0; }

///kingson
	void setAttr(int index = 0, int len = LINECHARNUM , short attr = 0x4000);
	void resetAttr(int index = 0, int len = LINECHARNUM , short attr = 0x4000);
///

};

#endif
