/*******************************************************************************
FILENAME:      qtermtextline.cpp
REVISION:      2001.8.12 first created.
         
AUTHOR:        kingson fiasco
*******************************************************************************/
/*******************************************************************************
                                    NOTE
 This file may be used, distributed and modified without limitation.
 *******************************************************************************/
#include "global.h"
#include "qtermtextline.h"

// ***********	class QTermTextLine

QTermTextLine::QTermTextLine( int nCode )
{

	nBBSCode=nCode;
	reset();
}

QTermTextLine::~QTermTextLine()
{
}

void QTermTextLine::setBBSCode( int nCode )
{
	nBBSCode=nCode;
}
// endx is the last index+1
inline void QTermTextLine::changeSet( int startx, int endx )
{
	if ( startx < changeStart )
		changeStart = MAX( startx, 0 );

	if ( endx > changeEnd )
		changeEnd = MIN( endx, LINECHARNUM );
}

// insert cstr at position index of line, 
// if attrib == -1, use current attr,
// if index == -1, append line
void QTermTextLine::insertText( const QCString& cstr, short attrib, int index )
{
	// set attribute
	if ( attrib != -1 )	
	{
		currentCP = GET_COLORPAIR( attrib );
		currentEA = GET_EXTRAATTR( attrib );
	}
	
	// set blink sign
	if ( BLINK(currentEA) )
		bBlink = true;	

	int len = cstr.length();
	QCString s;

	int start; 
	if ( index == -1 )	// insert
	{
		text += cstr;

		s.fill( currentCP, len );
		colorpair += s;
		s.fill( currentEA, len );	
		extraAttr += s;

		start = length;
		length += len;
	}
	else			// append
	{
//		if ( index >= length )
//		{
//			QCString blank;
//			blank.fill( ' ', index - length );
//			text.insert( length - 1, blank );
//		}
 
		text.insert( index, cstr );
		length = text.length();

		s.fill( currentCP, len );
		colorpair.insert( index, s );
		s.fill( currentEA, len );	
		extraAttr.insert( index, s );

		start = index;
	}

	changeSet( start, length );
}

// replace the cstring with cstr, which start at index and have len chars,
// if attr == -1, use the current attr,
// if index == -1, reset line and insert cstr.
// if len == -1, replace cstr's length chars.
void QTermTextLine::replaceText( const QCString& cstr, short attrib, int index, int len )
{
	// set attribute
	if ( attrib != -1 )
	{
		currentCP = GET_COLORPAIR( attrib );
		currentEA = GET_EXTRAATTR( attrib );
	}

	// set blink sign
	if ( BLINK(currentEA) )
		bBlink = true;

	int l = cstr.length();
	QCString s;
	
	if ( index == -1 )	// replace whole line
	{
		changeSet( 0, MAX( length, l ) );	// get the real changed end index

		text = cstr;

		s.fill( currentCP, l );
		colorpair = s;
		s.fill( currentEA, l );
		extraAttr = s;

		length = l;
			
		return;
	}

	if ( len == -1 )	// replace all char of cstr
		len = l;

	text.replace( index, len, cstr );

	if ( len == l )
		changeSet( index, index + len );
	else
		changeSet( index, MAX( length, (int)text.length() ) );

	length = text.length();

	s.fill( currentCP, l );
	colorpair.replace( index, len, s );
	s.fill( currentEA, l );
	extraAttr.replace( index, len, s );

}

// delete cstr from position index of line, 
// it will delete len chars,  
// if index == -1, delete the whole line
void QTermTextLine::deleteText( int index, int len )
{
	if ( index == -1 )	// delete the line
	{	
		int l = length;
		reset();
		
		changeSet( 0, l );
		
		return;
	}

	if ( len == -1 )
		len = length;
	
	changeSet( index, length );		// get the real changed end index

	text.remove( index, len );
	colorpair.remove( index, len );
	extraAttr.remove( index, len );
	length = text.length();

	//if ( !length )
	//	reset();
}
	
// return str in text for show
// if index == -1, get the whole line
// if len == -1, get the rest from index
QString QTermTextLine::getText( int index, int len )
{
	QCString cstr;


	if ( index == -1 )
		cstr = text ;
	else if ( len == -1 || ( len + index > length ) )	// maybe no need
		cstr = text.right( index );
	else 
	{
		if (index <=length)
			cstr = text.mid( index, len );
	}

	if(nBBSCode==1)
		return B2U( cstr );	// big5 to unicode
	else
		return G2U( cstr );	// gbk  to unicode
}

// reset line
inline void QTermTextLine::reset()
{
	length = 0;
	
	text = "";
	colorpair = "";
	extraAttr = "";

//	currentAttr = NO_ATTRIBS;
	currentCP = NO_COLOR;
	currentEA = NO_ATTR;
	
	bBlink = false;
		
	changeDrawn();
}
///kingson
void QTermTextLine::setAttr(int index, int len , short attr )
{
	char cp = GET_COLORPAIR( attr );
	char ea = GET_EXTRAATTR( attr );

	for(int i=0;i<len;i++)
	{
		if( i+index >length )
			return;
		colorpair[i+index]|=cp;
		extraAttr[i+index]|=ea;
	}

}

void QTermTextLine::resetAttr(int index, int len , short attr )
{
	char cp = GET_COLORPAIR( attr );
	char ea = GET_EXTRAATTR( attr );

	for(int i=0;i<len;i++)
	{
		if( i+index >length )
			return;
		colorpair[i+index]&=~cp;
		extraAttr[i+index]&=~ea;
	}

}
///
