#include "qppdconfigpage.h"
#include "qppdwidget.h"

#include <qlayout.h>

QPPDConfigPage::QPPDConfigPage(QWidget *parent, const char *name)
: QWidget(parent,name), QConfigPage()
{
	ppdwidget_ = new QPPDWidget(this);
	initialized_ = false;

	QVBoxLayout	*mainLayout_ = new QVBoxLayout(this, 0, 0);
	mainLayout_->addWidget(ppdwidget_);
}

QPPDConfigPage::~QPPDConfigPage()
{
}

void QPPDConfigPage::initOptions(int, cups_option_t*, global_ppd_file_t *ppd, ipp_t*)
{
	if (!initialized_)
	{
		ppdwidget_->initialize(ppd);
		initialized_ = true;
	}
	else
		ppdwidget_->updateChoices(ppd);
}

void QPPDConfigPage::getCupsOptions(int& num_options, cups_option_t **options, bool incldef, ipp_t*)
{
	ppdwidget_->getCupsOptions(num_options,options,incldef);
}

bool QPPDConfigPage::hasConflict() const
{
	return ppdwidget_->hasConflict();
}
