/***************************************************************************
                          qhpgl2config.cpp  -  description
                             -------------------
    begin                : Tue Jul 25 2000
    copyright            : (C) 2000 by Michael Goffioul
    email                : gofioul@emic.ucl.ac.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "qhpgl2config.h"

#include <qlabel.h>
#include <qcheckbox.h>
#include <qspinbox.h>

#include <stdlib.h>

QHPGL2Config::QHPGL2Config(QWidget *parent, const char *name)
: QHPGL2ConfigBase(parent,name), QConfigPage()
{
	initDialog();
}

QHPGL2Config::~QHPGL2Config()
{
}

void QHPGL2Config::initDialog()
{
	penwidth_->setRange(0,10000);
	penwidth_->setSteps(25,25);
	penwidth_->setValue(1000);

	unitlabel_->setText("[m]");
}

void QHPGL2Config::initOptions(int num_options, cups_option_t *options, global_ppd_file_t*, ipp_t*)
{
	const char	*str;
	if ((str=cupsGetOption("blackplot",num_options,options)) != NULL)
		black_->setChecked((strcmp(str,"off") != 0));
	if ((str=cupsGetOption("fitplot",num_options,options)) != NULL)
		fit_->setChecked((strcmp(str,"off") != 0));
	if ((str=cupsGetOption("penwidth",num_options,options)) != NULL)
		penwidth_->setValue(atoi(str));
}

void QHPGL2Config::getCupsOptions(int& num_options, cups_option_t **options, bool incldef, ipp_t*)
{
	if (incldef || black_->isChecked())
		num_options = cupsAddOption("blackplot",(black_->isChecked() ? "on" : "off"),num_options,options);
	if (incldef || fit_->isChecked())
		num_options = cupsAddOption("fitplot",(fit_->isChecked() ? "on" : "off"),num_options,options);
	if (incldef || penwidth_->value() != 1000)
		num_options = cupsAddOption("penwidth",penwidth_->text(),num_options,options);
}
