/***************************************************************************
                          qgeneralconfig.cpp  -  description
                             -------------------
    begin                : Tue Jul 4 2000
    copyright            : (C) 2000 by Michael Goffioul
    email                : gofioul@emic.ucl.ac.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "qgeneralconfig.h"

#include <qpixmap.h>
#include <qbuttongroup.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qradiobutton.h>
#include <stdlib.h>
#include <ctype.h>

// some pixmaps
#include "portrait.xpm"
#include "landscape.xpm"
#include "revland.xpm"
#include "revport.xpm"
#include "dupl_none.xpm"
#include "dupl_long.xpm"
#include "dupl_short.xpm"
#include "nup1.xpm"
#include "nup2.xpm"
#include "nup4.xpm"
#include "pagesize.xpm"
#include "printer.xpm"

//****************************************
// default values in case of NULL ppd file
#define	DEFAULT_SIZE	10
static const char*	default_size[] = {
	"Letter", "US Letter",
	"Legal", "US Legal",
	"A4", "ISO A4",
	"COM10", "US #10 Envelope",
	"DL", "ISO DL Envelope"
};
#define	DEFAULT_SOURCE	8
static const char*	default_source[] = {
	"Upper", "Upper tray",
	"Lower", "Lower tray",
	"MultiPurpose", "Multi-purpose tray",
	"LargeCapacity", "Large capacity tray"
};
#define	DEFAULT_TYPE	4
static const char*	default_type[] = {
	"Normal", "Normal",
	"Transparency", "Transparency"
};

//*********************************************************************************

static int findOption(const char *strs[],int n, const char *txt)
{
	for (int i=0;i<n;i+=2)
		if (strcmp(txt,strs[i]) == 0) return (i/2);
	return (-1);
}

void setComboItem(QComboBox *cb, const QString& txt)
{
	for (int i=0;i<cb->count();i++)
		if (cb->text(i) == txt)
		{
			cb->setCurrentItem(i);
			break;
		}
}

//*********************************************************************************

QGeneralConfig::QGeneralConfig(QWidget *parent, const char *name)
: QGeneralConfigBase(parent, name), QConfigPage()
{
	initDialog();
}

QGeneralConfig::~QGeneralConfig()
{
}

void QGeneralConfig::initDialog()
{
	orientbox_->setButton(ORIENT_PORTRAIT);
	buttonClicked(ORIENT_PORTRAIT);

	duplexbox_->setButton(DUPLEX_NORMAL);
	buttonClicked(DUPLEX_NORMAL);

	nupbox_->setButton(NUP_1);
	buttonClicked(NUP_1);
}

void QGeneralConfig::buttonClicked(int ID)
{
	switch(ID)
	{
		case ORIENT_PORTRAIT:
			orientpix_->setPixmap(QPixmap(portrait));
			break;
		case ORIENT_LANDSCAPE:
			orientpix_->setPixmap(QPixmap(landscape));
			break;
		case ORIENT_REVERSE:
			orientpix_->setPixmap(QPixmap(revland));
			break;
		case ORIENT_REVPORTRAIT:
			orientpix_->setPixmap(QPixmap(revport));
			break;
		case DUPLEX_NORMAL:
			duplexpix_->setPixmap(QPixmap(dupl_none));
			break;
		case DUPLEX_BOOK:
			duplexpix_->setPixmap(QPixmap(dupl_long));
			break;
		case DUPLEX_TABLET:
			duplexpix_->setPixmap(QPixmap(dupl_short));
			break;
		case NUP_1:
			nuppix_->setPixmap(QPixmap(nup1));
			break;
		case NUP_2:
			nuppix_->setPixmap(QPixmap(nup2));
			break;
		case NUP_4:
			nuppix_->setPixmap(QPixmap(nup4));
			break;
	}
}

void QGeneralConfig::initOptions(int num_options, cups_option_t *options, global_ppd_file_t *ppd, ipp_t *req)
{
	// init ppd_ variable
	ppd_ = ppd;

	const char	*str(0);
	QPixmap	pix;
	
	if (!ppd_ || !ppd_->ppd) {
		// "PageSize"
		pix = QPixmap(pagesize);
		if (size_->count() == 0)
			for (int i=1;i<DEFAULT_SIZE;i+=2) size_->insertItem(pix,QString(default_size[i]));
		// "MediaType"
		if (type_->count() == 0)
			for (int i=1;i<DEFAULT_TYPE;i+=2) type_->insertItem(pix,QString(default_type[i]));
		// "InputSlot"
		pix = QPixmap(printer);
		if (source_->count() == 0)
			for (int i=1;i<DEFAULT_SOURCE;i+=2) source_->insertItem(pix,QString(default_source[i]));
		// set initial value
		if ((str=cupsGetOption("media",num_options,options)) != NULL) {
			char	*s = new char[strlen(str)+2], *c;
			strcpy(s,str);
			strcat(s,",");
			c = strtok(s,",");
			while (c) {
				int	ind;
				if ((ind=findOption(default_size,DEFAULT_SIZE,c)) >= 0) size_->setCurrentItem(ind);
				else if ((ind=findOption(default_type,DEFAULT_TYPE,c)) >= 0) type_->setCurrentItem(ind);
				else if ((ind=findOption(default_source,DEFAULT_SOURCE,c)) >= 0) source_->setCurrentItem(ind);
				c = strtok(NULL,",");
			}
			delete [] s;
		}

		// Duplex
		if ((str=cupsGetOption("sides",num_options,options)) != NULL) {
			int	ID;
			if (strcmp(str,"two-sided-long-edge") == 0) ID = DUPLEX_BOOK;
			else if (strcmp(str,"two-sided-short-edge") == 0) ID = DUPLEX_TABLET;
			else ID = DUPLEX_NORMAL;
			duplexbox_->setButton(ID);
			buttonClicked(ID);
		}
	}
	else {
		// init "PageSize"
		pix = QPixmap(pagesize);
		initCombo(size_,ppd->ppd,"PageSize",pix);
		// init "MediaType"
		pix = QPixmap(pagesize);
		initCombo(type_,ppd->ppd,"MediaType",pix);
		// init "InputSlot"
		pix = QPixmap(printer);
		initCombo(source_,ppd->ppd,"InputSlot",pix);

		// init "Duplex"
		ppd_option_t	*opt;
		if ((opt=ppdFindOption(ppd->ppd,"Duplex")) == NULL) {
			duplexpix_->setPixmap(QPixmap());
			normal_->setEnabled(false);
			book_->setEnabled(false);
			tablet_->setEnabled(false);
		}
		else {
			ppd_choice_t	*ch = ppdFindMarkedChoice(ppd->ppd,"Duplex");
			int	ID;
			if (strcmp(ch->choice,"DuplexNoTumble") == 0) ID = DUPLEX_BOOK;
			else if (strcmp(ch->choice,"DuplexTumble") == 0) ID = DUPLEX_TABLET;
			else ID = DUPLEX_NORMAL;
			duplexbox_->setButton(ID);
			buttonClicked(ID);
		}
	}

	// Banner options
	ipp_attribute_t	*attr = ippFindAttribute(req,"job-sheets-supported",IPP_TAG_NAME);
	startbanner_->setEnabled(attr != NULL);
	stopbanner_->setEnabled(attr != NULL);
	if (attr != NULL)
	{
		startbanner_->clear();
		stopbanner_->clear();
		for (int i=0;i<attr->num_values;i++)
		{
			startbanner_->insertItem(QString(attr->values[i].string.text));
			stopbanner_->insertItem(QString(attr->values[i].string.text));
		}
	}
	if (startbanner_->isEnabled())
	{
		if ((str=cupsGetOption("job-sheets",num_options,options)) != NULL) {
			QString	banner(str);
			int	p = banner.find(',');
			if (p == -1)
			{
				setComboItem(startbanner_,banner);
				setComboItem(stopbanner_,QString("none"));
			}
			else
			{
				setComboItem(startbanner_,banner.left(p));
				setComboItem(stopbanner_,banner.right(banner.length()-p-1));
			}
		}
		else if ((attr=ippFindAttribute(req,"job-sheets-default",IPP_TAG_NAME)) != NULL) {
			if (attr->num_values > 0) setComboItem(startbanner_,QString(attr->values[0].string.text));
			if (attr->num_values > 1) setComboItem(stopbanner_,QString(attr->values[1].string.text));
		}
		else {
			setComboItem(startbanner_,QString("none"));
			setComboItem(stopbanner_,QString("none"));
		}
	}

	// init "Orientation"
	if ((str=cupsGetOption("orientation-requested",num_options,options)) != NULL) {
		int	ID = atoi(str)-2;
		orientbox_->setButton(ID);
		buttonClicked(ID);
	}

	// init "Number-Up"
	if ((str=cupsGetOption("number-up",num_options,options)) != NULL) {
		int	ID(atoi(str)+NUP_1-1);
		if (ID > NUP_2) ID=NUP_4;
		nupbox_->setButton(ID);
		buttonClicked(ID);
	}
}

void QGeneralConfig::initCombo(QComboBox *cb, ppd_file_t *ppd, const char *keyword, const QPixmap& pix)
{
	ppd_option_t*	option = ppdFindOption(ppd,keyword);
	cb->clear();
	if (option)
	{
		int	selected_choice(-1);
		for (int i=0;i<option->num_choices;i++)
		{
			ppd_choice_t*	choice = option->choices+i;
			cb->insertItem(pix,QString(choice->text));
			if (choice->marked) selected_choice = i;
		}
		cb->setCurrentItem(selected_choice);
	}
	else
		cb->setEnabled(false);
}

void QGeneralConfig::getCupsOptions(int& num_options, cups_option_t **options, bool incldef, ipp_t *req)
{
	ppd_option_t	*opt(0);
	ppd_choice_t	*ch(0);

	if (ppd_ && ppd_->ppd) {
		// PaperSize
		if ((opt = ppdFindOption(ppd_->ppd,"PageSize")) != NULL && size_->currentItem() >= 0) {
			ch = opt->choices+size_->currentItem();
			if (incldef || strcmp(ch->choice,opt->defchoice) != 0) num_options = cupsAddOption("PageSize",ch->choice,num_options,options);
		}

		// MediaType
		if ((opt = ppdFindOption(ppd_->ppd,"MediaType")) != NULL && type_->currentItem() >= 0) {
			ch = opt->choices+type_->currentItem();
			if (incldef || strcmp(ch->choice,opt->defchoice) != 0) num_options = cupsAddOption("MediaType",ch->choice,num_options,options);
		}

		// InputSlot
		if ((opt = ppdFindOption(ppd_->ppd,"InputSlot")) != NULL && source_->currentItem() >= 0) {
			ch = opt->choices+source_->currentItem();
			if (incldef || strcmp(ch->choice,opt->defchoice) != 0) num_options = cupsAddOption("InputSlot",ch->choice,num_options,options);
		}

		// Duplex
		if (normal_->isEnabled()) {
			if (normal_->isChecked()) num_options = cupsAddOption("Duplex","None",num_options,options);
			else if (book_->isChecked()) num_options = cupsAddOption("Duplex","DuplexNoTumble",num_options,options);
			else num_options = cupsAddOption("Duplex","DuplexTumble",num_options,options);
		}
	}
	else {
		// PageSize, MediaType and InputSlot
		QString	value;
		value.sprintf("%s,%s,%s",default_size[size_->currentItem()*2],default_type[type_->currentItem()*2],default_source[source_->currentItem()*2]);
		num_options = cupsAddOption("media",value.data(),num_options,options);
		// Duplex
		if (normal_->isEnabled()) {
			if (normal_->isChecked()) num_options = cupsAddOption("sides","one-sided",num_options,options);
			else if (book_->isChecked()) num_options = cupsAddOption("sides","two-sided-long-edge",num_options,options);
			else num_options = cupsAddOption("sides","two-sided-short-edge",num_options,options);
		}
	}

	// Orientation
	QString	value;
	if (portrait_->isChecked()) value = "3";
	else if (landscape_->isChecked()) value = "4";
	else if (reverse_->isChecked()) value = "5";
	else value = "6";
	if (incldef || value[0] != '3') num_options = cupsAddOption("orientation-requested",value.data(),num_options,options);

	// Nup
	if (!nup1_->isChecked() || incldef)
	{
		if (nup1_->isChecked()) value = "1";
		else if (nup2_->isChecked()) value = "2";
		else value = "4";
		num_options = cupsAddOption("number-up",value.data(),num_options,options);
	}

	// Banners
	ipp_attribute_t	*attr = ippFindAttribute(req,"job-sheets-default",IPP_TAG_NAME);
	if ((attr && attr->num_values == 2 && (QString(attr->values[0].string.text) != startbanner_->currentText() || QString(attr->values[1].string.text) != stopbanner_->currentText()))
	    || (!attr && (startbanner_->currentText() != QString("none") || stopbanner_->currentText() != QString("none"))) || incldef)
	{
		value = startbanner_->currentText();
		value.append(",");
		value.append(stopbanner_->currentText());
		num_options = cupsAddOption("job-sheets",value.data(),num_options,options);
	}
}
