#ifndef RXWIDGET_H
#define RXWIDGET_H

#include <QWidget>
#include <QFrame>
#include "rxfunctions.h"
#include "ui_rxwidget.h"


class imageViewer;
class spectrumWidget;
class vuMeter;


namespace Ui {
  class rxWidget;
  }

class rxWidget : public QWidget
{
  Q_OBJECT
  
public:
  explicit rxWidget(QWidget *parent = 0);
  ~rxWidget();
  void init();
  void start(bool st);
  void readSettings();
  void writeSettings();
  void setFilterIndex(int index);
  int getFilterIndex();
  void setSettingsTab();
  rxFunctions *functionsPtr() {return rxFunctionsPtr;}
  imageViewer *getImageViewerPtr(){ return imageViewerPtr;}
  spectrumWidget *fftDisplayPtr();
  vuMeter *vMeterPtr();
  vuMeter *sMeterPtr();
  void setSSTVStatusText(QString txt);
  void setDRMStatusText(QString txt);
//  drmPSDFrame *psdWdg() {return ui->drmPSDWidget;}
  drmConstellationFrame *mscWdg() {return ui->drmMSCWidget;}
  drmConstellationFrame *facWdg() {return ui->drmFACWidget;}
//  drmPSDFrame *psdWdg() {return ui->drmPSDWidget;}
  drmStatusFrame *statusWdg() {return ui->drmStatusWidget;}

private slots:
  void slotStart();
  void slotStop();
  void slotGetParams();
  void slotTransmissionMode(int rxtxMode);

private:
  Ui::rxWidget *ui;
  void getParams();
  void setParams();
  rxFunctions *rxFunctionsPtr;
  imageViewer *imageViewerPtr;
};

extern rxWidget *rxWidgetPtr;
#endif // RXWIDGET_H
