#ifndef SSTVTX_H
#define SSTVTX_H
#include <qwidget.h>
#include <qtimer.h>
#include "rxtxcommon.h"
#include "txwindow.h"
#include "cw.h"

enum eRetVal {OK,RELEASESLOT};

class sstvTX : public txWindow, rxtxCommon
{ 
  Q_OBJECT

public:
  sstvTX(QWidget *p=0 ,const char *n=0, WFlags f=0);
  ~sstvTX();
  void sendCWstr(const char *s);
public slots:
  void slotStart();
  void slotStop();
  void slotStopRequest();
  void slotSend1750();
  void slotDump();
  void slotCWsend();
  void slotTestFrequency();
  void slotPlayback();
  void slotNextBuf();
	void slotSSTVFAX(int i);
	void slotToneEncode();
	void slotSSTVEncode();
	void slotFAXEncode();
	
signals:
	void signalTXEnd();
 
protected:
  void closeEvent(QCloseEvent *e);
	void sendSingleTone();
	
private:
	
  int pixelbuf[700];
  double endOfLine;
  uint runningSamples;
  uint savedRunningSamples;
  uint sampleIndex;
  double videoLineTime;
  uint blockSize;
  bool isRunning;
  short int angleValue;
//  bool dumpActive;
  QFile frawout;
//  QFile ftrace;
  int serial;
 // QTimer *timer;
  morse *cwTX;
 // short int *audioBuffer;
 // double endTimeRed,endTimeGreen,endTimeBlue;
  int cwTone;
  float cwDuration;
  uint *p0;
  uint *p1;

  enum eRetVal sendTone (uint freq,double time);
	enum eRetVal sendToneEndTime(uint freq,double time);
 // enum eRetVal sendToneAbs (uint freq,double endTime);
  enum eRetVal sendCWTone (uint freq,double time);
  enum eRetVal put(short int val);
  enum eRetVal encode();
  void initTransmit(bool);
  void gotoState(eTxRxState state);
  void extractPixels(uint lineColor);
 	bool setupImage();
  void waitAndStop();
  enum eRetVal sendPixels(double lineTime);
  void closeAll();
  int sendFrequency;
  float sendDuration;
  void activatePTT(bool);
  short int getNextSample(uint freq);
};

extern sstvTX *tx;
#endif




