#include "spectrumdisplay.h"
#include <qpointarray.h> 
#include <qpainter.h>
#include <math.h>
#include "qsstvglobal.h"

unsigned short int FFTBuffer[FFTLEN];

void spectrumDisplay::paintEvent(QPaintEvent *p)
{
  draw();
  QFrame::paintEvent(p);
}

void spectrumDisplay::draw()
{ 
  uint i;
  int t;
  QPainter p(this);
  QPointArray FFTArray(FFTLEN);
  int h=contentsRect().height();
  int w=contentsRect().width();
  int bw=lineWidth();
  for (i=0;i<FFTLEN;i++)
    {
      t=bw+h-((int)(20*log10(FFTBuffer[i])));
      t=(t<bw ? bw : t);
      FFTArray.setPoint(i,bw+(int)(i*w/FFTLEN),t);
    }
  p.eraseRect(contentsRect());     
  p.setPen(red);
  t=bw+((1200-FFTLOW)*w/FFTSPAN);
  p.drawLine(t,bw,t,h+bw);  
  p.setPen(blue);
  t=bw+((1500-FFTLOW)*w/FFTSPAN);
  p.drawLine(t,bw,t,h+bw);
  t=bw+((2300-FFTLOW)*w/FFTSPAN);
  p.drawLine(t,bw,t,h+bw);
  p.setPen(white);
  for (i=0;i<7;i++)
    {
      t=bw+(((1600+i*100)-FFTLOW)*w/FFTSPAN);   
      p.drawLine(t,bw,t,h+bw);
    }
  p.setPen(green);
  p.drawPolyline(FFTArray);
 }   









