#ifndef QSSTVGLOBAL_H
#define QSSTVGLOBAL_H
#include "qglobal.h"
#include "configfile.h"
#include <qcolor.h>
#include <qwhatsthis.h>

#define MAXPIXELS 640
#define XORCOLOR QColor(0xaa,0xaa,0xaa)
#define ERASECOLOR QColor(0,0,88)
#define NUMBEROFIMAGEFORMATS 5
#define SSTV 0
#define FAX 1

extern float foffsetRX;
extern float foffsetTX;
extern unsigned int isamplingrate;
extern float fRXsamplingrate;
extern float fTXsamplingrate;
extern int ibannerNumber;
extern configurationFile configFile;
extern bool buseVIS;
extern bool bautoSave;
extern bool bDX;
extern bool buseBanner;
extern bool btimestamp;
extern bool bautoErase;
extern bool bftp;
extern bool bCW;
extern bool bVOX;
extern bool bUTC;
extern int iCWHz;
extern int iCWWPM;
extern int irepImInterval;
extern int idefaultFilter;
extern int idefaultPostFilter;
extern int iftpPort;
extern int syncDetectSensitivity;
extern int modeSSTVFAXRX;
extern int modeSSTVFAXTX;
extern int faxType;
extern int faxlpm1;
extern int faxioc1;
extern int faxColors1;
extern int faxLines1;
extern bool faxInvp1;
extern int faxlpm2;
extern int faxioc2;
extern int faxColors2;
extern int faxLines2;
extern bool faxInvp2;
extern int faxlpm3;
extern int faxioc3;
extern int faxColors3;
extern int faxLines3;
extern bool faxInvp3;
extern int faxlpm4;
extern int faxioc4;
extern int faxColors4;
extern int faxLines4;
extern bool faxInvp4;
extern int borderColor;
extern QColor bColor;
extern bool posKeepAR;
extern bool pLeft;
extern bool pCenter;
extern bool pRight;

extern bool pTop;
extern bool pMiddle;
extern bool pBottom;

extern bool pScaled;
extern int zoomScale;
extern int zoomWidth;
extern int zoomHeight;

extern bool brepeater;
extern bool brepGetPicture;

extern const char *imageFormatStr[NUMBEROFIMAGEFORMATS];


void addWT(QWidget *qwptr, const char *s);
void fileLoadError (const char *title,const char *fn);
void Initialize();
#ifdef  DEBUGQSSTV
void qsstvDebug(const char *fmt, ...);
#else
void qsstvDebug(...);
#endif
#endif











