/***************************************************************************
                          dirdialog.cpp  -  description
                             -------------------
    begin                : Sat Apr 28 2001
    copyright            : (C) 2001 by
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "qsstvglobal.h"
#include "imageframe.h"
#include <qapp.h>
#include <qfiledlg.h>
#include <qmessagebox.h>
#include <qbuttongroup.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qcolordialog.h>
#include <qlayout.h>
#include "zoomwindow.h"
#include <qframe.h>
#include <qpainter.h>
#include "posform.h"



imagePosition::imagePosition(QWidget *parent, const char *name) : posForm(parent, name, TRUE)
{
 	leftRadioButton->setChecked(pLeft);
  centerRadioButton->setChecked(pCenter);
  rightRadioButton->setChecked(pRight);

  topRadioButton->setChecked(pTop);
  middleRadioButton->setChecked(pMiddle);
  bottomRadioButton->setChecked(pBottom);

  scaledCheckBox->setChecked(pScaled);
	borderButton->setPalette(QPalette(bColor));
	keepARCheckBox->setChecked(posKeepAR);
}


imagePosition::~imagePosition()
{
  
}

void imagePosition::slotSelectColor()
{
	bColor=QColorDialog::getColor(bColor);
	borderColor=bColor.red()*65536+bColor.green()*256+bColor.blue();
	
	borderButton->setPalette(QPalette(bColor));
}

void imagePosition::slotAccept()
{
	pLeft=leftRadioButton->isChecked();
	pCenter=centerRadioButton->isChecked();
	pRight=rightRadioButton->isChecked();
	pTop=topRadioButton->isChecked();
	pMiddle=middleRadioButton->isChecked();
	pBottom=bottomRadioButton->isChecked();
	pScaled=scaledCheckBox->isChecked();
	posKeepAR=keepARCheckBox->isChecked();
	accept();
}


eimageAlignH imagePosition::getHorizontalPosition()
{
  if (pLeft)
    {
      return(LEFT);
    }
  else if(pCenter)
    {
      return (CENTER);
    }
  return (RIGHT);
  
}

eimageAlignV imagePosition::getVerticalPosition()
{
 if (pTop)
    {
      return(TOP);
    }
  else if(pMiddle)
    {
      return (MIDDLE);
    }
  return (BOTTOM);
}

bool imagePosition::scaled()
{
 return pScaled;
}


bool imagePosition::keepAspectRatio()
{
	return posKeepAR;
}

imageFrame::imageFrame(QWidget* parent,const char* name):pixmapView(parent,name)
{
  setFrameStyle(QFrame::NoFrame);
  setBackgroundMode(NoBackground);
  editorOpen=FALSE;
  image=NULL;
  buPixmap=NULL;
  alignH=CENTER;
  alignV=MIDDLE;
  fnsave[0]=0;
}


imageFrame::~imageFrame()
{
  delete image;
}

void imageFrame::createImage(int width,int height,int NumberOfColorBits,int viewX, int viewY)
{
  if(image!=NULL)
    {
      delete image;
    }
	image=new QImage(width,height,NumberOfColorBits);
	setFixedSize(viewX,viewY); //first give this canvas a new size
	setNewSize(width,height);
	imageFill(ERASECOLOR);
}


void imageFrame::backup()
{
  buPixmap= new QPixmap(pixmap);
}

void imageFrame::restore()
{
  if(buPixmap)
    {
      pixmap=*buPixmap;
      viewport()->repaint(FALSE);
    }
}

void imageFrame::deleteBackup()
{
  delete buPixmap;
  buPixmap=NULL;
}

void imageFrame::showLine(int width,int line)
{
	pixmapView::showLine(image,width,line);
}


void imageFrame::showLine(int width,int line,int nbrlines)
{
	pixmapView::showLine(image,width,line,nbrlines);
}




uint *imageFrame::getLineAddress(int line)
{
	if(line<image->height())
		{
			return((uint *)image->scanLine(line));
		}
	else return NULL;
}

void imageFrame::rotate(uint len,uint nbrlines)
{
	uint i;
	uint disp=(image->width()-len)*sizeof(uint);
	len*=sizeof(uint);
	if (nbrlines<(uint)image->height())
		{
			for (i=0;i<nbrlines;i++)
				{
					uchar *src=image->scanLine(i);

					memmove((char *)src,(char *)(&src[len]),disp);
					memmove((char *)(&src[disp]),image->scanLine(i+1),len);
				}	
			
		}
	showLine(image->width(),0,nbrlines);
}


void imageFrame::save(QFileInfo fn)
{

  if (image==NULL)
    {
      return;
    }
  QString f=fn.extension().upper();
  pixmap.save(fn.filePath(),f);
}


void imageFrame::setupPosition()
{
  imagePosition ip(this,0);
  if(ip.exec())
    {
    alignH=ip.getHorizontalPosition();
    alignV=ip.getVerticalPosition();
    keepAspectRatio=ip.keepAspectRatio();
    scaled=ip.scaled();
    }
}

bool imageFrame::load(QFileInfo fn,bool showError)
{
  return load((const char *)fn.filePath(),alignH,alignV,showError);
}

bool imageFrame::load( const char * s,bool showError)
{
  return load(s,alignH,alignV,showError);
}

bool imageFrame::load(QFileInfo fn,eimageAlignH ialignH,eimageAlignV ialignV,bool showError,int x,int y)
{
  return load((const char *)fn.filePath(),ialignH,ialignV,showError,x,y);
}


bool imageFrame::load( const char * s,eimageAlignH ialignH,eimageAlignV ialignV,bool showError,int x,int y)
{
  strcpy(fnsave,s);
  bool pix= pmLoad.load(s);
  if ( !pix )
    {
      if(showError)
				{
	 				fileLoadError("Load error",s);
				}
      return FALSE;
    }
  scale(width(),height(),ialignH,ialignV,x,y);
  viewport()->repaint(FALSE);
 // repaint(FALSE);
  return TRUE;
}


bool imageFrame::reload()
{
  if(fnsave[0]!=0)
    {
      bool pix= pmLoad.load(fnsave);
      if ( !pix )
				{
	  			// do not give an error, reload if you can
	  			//fileLoadError("Reload error",fnsave);
	  			return FALSE;
				}
     	scale(width(),height(),alignH,alignV,0,0);
     	viewport()->repaint(FALSE);
    }
  return TRUE;
}



bool imageFrame::addImage(int x,int y, QString s,int w,int h)
{
  if(pmLoad.load(s))          // load the image from file s
    {
      if (h==-1)
				{
	 				h=pmLoad.height();
				}
   		if (w==-1)
				{
	 				w=pmLoad.width();
				}
      scale(w,h,alignH,alignV,x,y);
      viewport()->repaint(FALSE);
      return TRUE;
    }
  fileLoadError("AddImage Error",s);
  return FALSE;  
}


void imageFrame::addString(int x,int y, QString s,const QColor &icolor,const QFont &ifont)
{
  int Offset=8;
  QPainter paint; 
  QRect r;
  QFontMetrics fm(ifont);
  paint.begin(&pixmap);
  {   
    paint.setFont(ifont); 
    r=fm.boundingRect(s);
    r.setWidth(r.width()+Offset);
    r.setHeight(r.height()+Offset);
    r.moveBottomLeft(QPoint(x,y));
    paint.fillRect(r,QBrush(darkGray,SolidPattern));
    paint.setPen(black);
    paint.drawRect(r);
    paint.setPen(icolor);
    paint.drawText(x+Offset/2,y-Offset/2+1,s);
    paint.setPen(white);
    paint.drawLine(r.left()+1,r.top()+1,r.right()-1,r.top()+1);
    paint.drawLine(r.right()-1,r.top()+1,r.right()-1,r.bottom()-1);          
  }
  paint.end();
  viewport()->repaint(FALSE);
}

void imageFrame::scale(int width, int height,eimageAlignH alignH,eimageAlignV alignV , int x, int y)
{
  QImage temp,m;
  int sx,sy,dx,dy;
  sx=sy=dx=dy=0;
  int w,h;
	double ratio;
  

	if (scaled)
		{
			w=width;
 			h=height;
 			if(keepAspectRatio)
 				{
 					ratio=((double)pmLoad.width())/((double)pmLoad.height());
 					if(((int)(w/ratio))>height)
 						{
 							w=(int)(height*ratio);
 						}
 					else
 						{
 							h=(int)(width/ratio);
 						}
 				}
 		}
 	else
 		{
 			w=(width<pmLoad.width() ? width : pmLoad.width());
  		h=(height<pmLoad.height() ? height : pmLoad.height());		
 		} 	
 	
  switch (alignH)
    {
    	case LEFT:
      	{
					dx=0;
					sx=0;
      	}
    	break;
    	case CENTER:
      	{
					if (pmLoad.width()<width)
	  				{
	    				dx=(width-pmLoad.width())/2;
	    				sx=0;
	  				}
					else
	  				{
	    				dx=0;
	    				sx=(pmLoad.width()-width)/2;
	  				}
	  		}
			break;
			case RIGHT:
	  		{
	    		if (pmLoad.width()<width)
	     			{
							dx=width-pmLoad.width();
							sx=0;
	      		}
	    		else
	      		{
							dx=0;
							sx=pmLoad.width()-width;
	      		}
	  		}
	  	break;
		}
	switch (alignV)
    {
    case TOP:
      {
				dy=0;
				sy=0;
      }
    break;
    case MIDDLE:
      {
				if(pmLoad.height()<height)
	  			{
	    			dy=(height-pmLoad.height())/2;
	    			sy=0;
	  			}
				else
	  			{
	    			dy=0;
	    			sy=(pmLoad.height()-height)/2;
	  			}
      }
    break;
		case BOTTOM:
      {
				if(pmLoad.height()<height)
	  			{
	    			dy=height-pmLoad.height();
	    			sy=0;
	  			}
				else
	  			{
	    			dy=0;
	    			sy=pmLoad.height()-height;
	  			}
	  	}
		break;
   }

  if (scaled && ((pmLoad.width()!=w)||( pmLoad.height()!=h)))
		{
		  temp=pmLoad;
   		m=temp.smoothScale(w,h);
   		sx=0;sy=0;
   		dx=(width-w)/2;
   		dy=(height-h)/2;
   	}
  else
  	{
  		m=pmLoad;
  	}
	temp.create(width,height,image->depth());
	temp.fill(bColor.rgb());
	bitBlt(&temp,dx,dy,&m,sx,sy,w,h);
  pmLoad=temp;
  bitBlt(&pixmap,x,y,&pmLoad,0,0,pmLoad.width(),pmLoad.height());
}


void imageFrame::resizeEvent(QResizeEvent *)
{
  viewport()->repaint(FALSE);
}


void imageFrame::zoom()
{
  if (image==NULL)
    {
      return;
    }
   zoomWindow zm(0);
   zm.zoom(&pixmap);
   zm.exec();
}

void imageFrame::contentsMousePressEvent( QMouseEvent *e )
{
  if (e->button() == RightButton)
    {
      emit mouseRightButtonPressed(e);
    }
  else
  	{
  		emit mouseLeftButtonPressed(e);
  	}
} 






