/***************************************************************************
                          debugger.h  -  qsstv debugger
                             -------------------
    begin                : Sat Jun 2 2001
    copyright            : (C) 2001 by Johan Maes
    email                : on1mh@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DEBUGGER_H
#define DEBUGGER_H

#define NUMSTATES 33
#define NUMFAXSTATES 12

enum eTxRxState
{
	PHASET0,PHASET1,PHASET2,PHASET3,PHASET4,
	PHASET5,PHASET6,PHASET7,PHASET8,PHASET9,
	PHASETA,PHASETB,PHASETC,PHASETD,PHASETE,NEXTRGB,NEXTXYZOE,
	NEXTXYZOE2,
	STARTPIC,HUNT,F1900A,VISSTART,VISDATA,VISSTOP,
	SENDCWSPACE,SENDCW,SENDCWNEXT,ABORTTX,F1900B,F1200A,F1200B,ENDTX,REPTONE
};

enum efaxState {FAXIDLE,FAXFORCE,FAXAPTSTARTB,FAXAPTSTARTW,FAXSTART,
								FAXTOP1,FAXTOP2,FAXTOP3,FAXTOP4,FAXIMAGE,FAXAPTSTOP,FAXEND};

/**qsstv debugger
  *@author Johan Maes
  */

class QString;
class QFile;

struct sdebug
{
	unsigned int sampleCounter;
	unsigned int imageSampleCounter;
	unsigned int stateSampleCounter;
	eTxRxState state;
	float sample;
};


class debugger
{
public: 
	debugger();
	~debugger();
	void rewind(unsigned int len);
	sdebug debugFields;
	bool openForRead(QString basename);
	bool openForWrite(QString basename,const char *s=".dmp");
	int save();
	int read();
	void stop();
	unsigned int numberOfEntries();
private:
	QFile *dinput;
	QFile *doutput;
};

#endif
