/*
 * This file is part of the QPxTool project.
 * Copyright (C) 2006 Gennady "ShultZ" Kozlov <qpxtool@mail.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 */

#include <qlistview.h>
#include <qpushbutton.h>
#include <qmessagebox.h>

#include "ASDB.h"

drive_info*	asdb_drive;

asdb_edit_dialog::asdb_edit_dialog(QWidget* parent, const char* name, bool modal, WFlags fl)
	: asdb_edit_dialog_UI(parent,name,modal,fl)
{
//	printf("=== Creating ASDB editor...\n");
	db_act = ASDB_ADD;
	as_mode = ASDB_CRE_QUICK;
	for (int i=0; i<31; i++) if (asdb_entry[i]) asdb_entry[i] = NULL;
	asdb_redraw();
	text_ascreate_status->clear();

	if (asdb_drive->dev_ID == PLEXTOR_716)
		push_ascreate->setEnabled(false);
	else
		push_ascreate->setEnabled(true);
	printf("Show ASDB editor...\n");
	this->show();
}

asdb_edit_dialog::~asdb_edit_dialog()
{
//	asdb_close();
	list_asdb->clear();
	printf("ASDB editor destroyed\n");
}

void asdb_edit_dialog::asdb_redraw()
{
	int i;
	for (i=0; i<31; i++) if (asdb_entry[i]) {
//		printf("DELETE asdb_entry[%d]\n",i);
		delete asdb_entry[i];
		asdb_entry[i] = NULL;
	}

	plextor_get_autostrategy_db_entry_count(asdb_drive);
	plextor_get_autostrategy_db(asdb_drive);
	list_asdb->clear();
	for (i=0; i< asdb_drive->astrategy.dbcnt; i++){
//		printf("ADD asdb_entry[%d]\n",i);
		asdb_drive->astrategy.entry[i].MID[11]='\0';
		asdb_entry[i] = new QListViewItem(list_asdb,
//		new QCheckListItem(list_asdb,
			QString("%1").arg(asdb_drive->astrategy.entry[i].number),
			QString("%1").arg(asdb_drive->astrategy.entry[i].enabled ? "YES":"NO"),
			QString("%1").arg((asdb_drive->astrategy.entry[i].type == 0xA1) ? "DVD+R":"DVD-R"),
			QString("%1").arg(asdb_drive->astrategy.entry[i].MID),
			QString("%1X").arg(asdb_drive->astrategy.entry[i].speed),
			QString("%1").arg((asdb_drive->astrategy.entry[i].counter[0] << 8) +
			(asdb_drive->astrategy.entry[i].counter[1])));
	}
	if (i) { push_act_deact->setEnabled(true); push_delete->setEnabled(true);}
	else { push_act_deact->setEnabled(false); push_delete->setEnabled(false);}
}

void asdb_edit_dialog::asdb_act_deact()
{
	asdb_act_deact(list_asdb->currentItem());
}

void asdb_edit_dialog::asdb_act_deact(QListViewItem* Item)
{
	QString cItem;
	int index;
	int act;
	cItem = Item->text(0);
	index = (int)atoi(cItem.data());
	if (index<1 || index>31) {
		printf("ASDB index %d out of range\n", index);
		return;
	}
	act = asdb_drive->astrategy.entry[index-1].enabled ? ASDB_DISABLE : ASDB_ENABLE;
	plextor_modify_autostrategy_db(asdb_drive, index, act);
//	arg(asdb_drive->astrategy.entry[i].enabled = !asdb_drive->astrategy.entry[index-1].enabled;
	plextor_get_autostrategy_db_entry_count(asdb_drive);
	plextor_get_autostrategy_db(asdb_drive);
	asdb_entry[index-1]->setText(1,QString("%1").arg(act ? "YES":"NO"));
//	asdb_redraw();
}

void asdb_edit_dialog::asdb_delete()
{
//	printf("Delete ASDB item\n");
	QString cItem;
	int index;
	cItem = list_asdb->currentItem()->text(0);
	index = (int)atoi(cItem.data());

	QMessageBox* ASdelMsg = new QMessageBox (QString("AutoStrategy"),
		QString("ASDB entry will be deleted. Are you sure?"),
		QMessageBox::Warning,
		QMessageBox::Yes,
		QMessageBox::Cancel | QMessageBox::Default | QMessageBox::Escape,
		QMessageBox::NoButton,
		this);
//		3,2,0);
	int asd = ASdelMsg->exec();
	delete ASdelMsg;
	if (asd == QMessageBox::Yes) {
		plextor_modify_autostrategy_db(asdb_drive, index, ASDB_DELETE);
		asdb_redraw();
	}
}

void asdb_edit_dialog::as_quick_toggled(bool state)
{
	if ((!state) || (as_mode == ASDB_CRE_QUICK)) return;
	as_mode = ASDB_CRE_QUICK;
	printf("\tAS Full quick creation (non-destructive)\n");
}

void asdb_edit_dialog::as_full_toggled(bool state)
{
	if ((!state) || (as_mode == ASDB_CRE_FULL)) return;
	as_mode = ASDB_CRE_FULL;
	printf("\tAS Full strategy creation (media will be unusable)\n");
}

void asdb_edit_dialog::db_add_toggled(bool state)
{
	if ((!state) || (db_act == ASDB_ADD)) return;
	db_act = ASDB_ADD;
	printf("\tAS Add strategy even if active exists for this media\n");
}

void asdb_edit_dialog::db_replace_toggled(bool state)
{
	if ((!state) || (db_act == ASDB_REPLACE)) return;
	db_act = ASDB_REPLACE;
	printf("\tAS Replace active strategy for this media if exists\n");
}

void asdb_edit_dialog::asdb_create()
{
	text_ascreate_status->setText("Creating Strategy...");
	if (!plextor_create_strategy(asdb_drive, as_mode | db_act))
		text_ascreate_status->clear();
	else
		text_ascreate_status->setText("Creating failed...");
	asdb_redraw();
}

void asdb_edit_dialog::asdb_close()
{
//	if (asdb_drive) delete asdb_drive;
//	printf("=== ASDB editor destroyed\n");
	this->close();
}
