/*
 * QNixStyle Config (C) 2001 Derek Greene     <del@chek.com>
 * Based on code by
 *           (C) 2001 Melchior FRANZ  <a8603365@unet.univie.ac.at>
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

/*
 * CHANGES:
 *
 * 0.2
 *		- Added config option for MouseOver highlighting
 *    - Added config option for corner detail
*/

#include "config.h"
#include <kconfig.h>
#include <klocale.h>
#include <kglobal.h>
#include <qwhatsthis.h>

//////////////////////////////////////////////////////////////////////////////////////////////////////////////
// CLASS : QNixConfig
//////////////////////////////////////////////////////////////////////////////////////////////////////////////

// 'conf' 	is a pointer to the kwindecoration modules open kwin config,
//			and is by default set to the "Style" group.
//
// 'parent'	is the parent of the QObject, which is a VBox inside the
//			Configure tab in kwindecoration

// --------------------------------------------------------------
// Create widgets
// --------------------------------------------------------------
QNiXConfig::QNiXConfig(KConfig* conf, QWidget* parent) : QObject(parent)
{
	clientrc = new KConfig("kwinqnixrc");
	KGlobal::locale()->insertCatalogue("libkwinqnix_config");
	gb = new QGroupBox(1, Qt::Horizontal, i18n("Decoration Settings"), parent);

	// Show app icon
	cbShowMenuButtonIcon = new QCheckBox(i18n("&Menu button always shows application mini icon"), gb);
	QWhatsThis::add( cbShowMenuButtonIcon,
				i18n("When selected, all titlebar menu buttons will have "
				"the application icon shown. If not selected, the current "
				"theme's defaults are used instead.") );
	// Show left detail
	cbShowLeftDetail = new QCheckBox(i18n("&Show top left corner detail"), gb);
	QWhatsThis::add( cbShowLeftDetail, i18n("Show extra design at top &left corner of window") );
	// Show corner detail
	cbShowCornerDetail = new QCheckBox(i18n("Show bottom &right corner detail"), gb);
	QWhatsThis::add( cbShowLeftDetail, i18n("Show extra design at bottom right corner of window") );
	// MouseOver Highlight
	cbHighlightButtons = new QCheckBox(i18n("&MouseOver Highlight"), gb);
	QWhatsThis::add( cbHighlightButtons, i18n("Highlight titlebar buttons on MouseOver") );

	// Signals & slots
	connect(cbShowLeftDetail, SIGNAL(clicked()), this, SLOT(slotSelectionChanged()));
	connect(cbShowCornerDetail, SIGNAL(clicked()), this, SLOT(slotSelectionChanged()));
	connect(cbShowMenuButtonIcon, SIGNAL(clicked()), this, SLOT(slotSelectionChanged()));
	connect(cbHighlightButtons, SIGNAL(clicked()), this, SLOT(slotSelectionChanged()));
	// Load configuration
	load(conf);
	// Show everything
	gb->show();
}

// --------------------------------------------------------------
// Clean up
// --------------------------------------------------------------
QNiXConfig::~QNiXConfig()
{
	delete cbShowMenuButtonIcon;
	delete cbShowLeftDetail;
	delete cbShowCornerDetail;
	delete cbHighlightButtons;
	delete gb;
	delete clientrc;
}

// --------------------------------------------------------------
// Occurs when the value of a checkbox has been changed
// --------------------------------------------------------------
void QNiXConfig::slotSelectionChanged()
{
	emit changed();
}

// --------------------------------------------------------------
// Load config data
// --------------------------------------------------------------
void QNiXConfig::load(KConfig* /*conf*/)
{
	bool override ;

	clientrc->setGroup("General");

	override = clientrc->readBoolEntry( "ShowMenuButtonIcon", false );
	cbShowMenuButtonIcon->setChecked( override );

	override = clientrc->readBoolEntry( "ShowLeftDetail", true );
	cbShowLeftDetail->setChecked( override );

	override = clientrc->readBoolEntry( "ShowCornerDetail", true );
	cbShowCornerDetail->setChecked( override );

	override = clientrc->readBoolEntry( "HighlightButtons", false );
	cbHighlightButtons->setChecked( override );
}

// --------------------------------------------------------------
// Save config data
// --------------------------------------------------------------
void QNiXConfig::save(KConfig* /*conf*/)
{
	clientrc->setGroup("General");
	clientrc->writeEntry("ShowMenuButtonIcon", cbShowMenuButtonIcon->isChecked());
	clientrc->writeEntry("ShowLeftDetail", cbShowLeftDetail->isChecked());
	clientrc->writeEntry("ShowCornerDetail", cbShowCornerDetail->isChecked());
	clientrc->writeEntry("HighlightButtons", cbHighlightButtons->isChecked());
	clientrc->sync();
}

// --------------------------------------------------------------
// Set config data defaults
// --------------------------------------------------------------
void QNiXConfig::defaults()
{
	cbShowMenuButtonIcon->setChecked( false );
	cbShowLeftDetail->setChecked( true );
	cbShowCornerDetail->setChecked( true );
	cbHighlightButtons->setChecked( false );
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////

extern "C"
{
	QObject* allocate_config( KConfig* conf, QWidget* parent )
	{
		return(new QNiXConfig(conf, parent));
	}
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "config.moc"
