/**********************************************************************************************
    Copyright (C) 2006, 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

**********************************************************************************************/
#ifndef IPROJECTION_H
#define IPROJECTION_H

#include <projects.h>
#include <QRectF>
#include <QPolygonF>
#include <QString>

extern void setupProjection(quint32 key);

class IProjection
{
    public:
        IProjection();
        virtual ~IProjection();

        virtual inline void fwdQRectF(double north, double east, double south, double west, QRectF& rect);

        virtual operator PJ*() const {return pj;}

        virtual void registerMap(const QString& /*name*/, double /*latBottom*/, double /*latTop*/, double /*lonLeft*/, double /*lonRight*/){};

        virtual void switchMap(const QString& /*name*/){};

        virtual double distance(const XY& p1, const XY& p2, double& a1, double& a2);

    protected:
        /// setup parameter for projection lib.
        static char * param[];
        /// projection context
        PJ * pj;

};

struct proj_t
{
    quint32 key;
    QString name;
    IProjection * proj;
};

extern const proj_t projections[];

inline void IProjection::fwdQRectF(double north, double east, double south, double west, QRectF& rect)
{
    XY p1, p2, p3, p4;
    p1.u = west;
    p1.v = north;
    p2.u = east;
    p2.v = north;
    p3.u = east;
    p3.v = south;
    p4.u = west;
    p4.v = south;

    p1 = pj_fwd(p1,pj);
    p2 = pj_fwd(p2,pj);
    p3 = pj_fwd(p3,pj);
    p4 = pj_fwd(p4,pj);

    QPolygonF poly;
    poly << QPointF(p1.u,p1.v) << QPointF(p2.u,p2.v) << QPointF(p3.u,p3.v) << QPointF(p4.u,p4.v);
    rect = poly.boundingRect().normalized();
}


extern IProjection * gpProj;
#endif                           //IPROJECTION_H
