/**********************************************************************************************
    Copyright (C) 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

  Garmin and MapSource are registered trademarks or trademarks of Garmin Ltd.
  or one of its subsidiaries.

**********************************************************************************************/
#include "CCentralResources.h"
#include "CToolViewTrackProfile.h"
#include "CGarminTrack.h"
#include "CGarminDBTrack.h"
#include "CPlotData.h"
#include "CPlotAxis.h"

#include <QtGui>

CToolViewTrackProfile::CToolViewTrackProfile(QWidget * parent, CGarminDBTrack * db)
: CPlot(parent)
{
    connect(db,SIGNAL(sigTrackListChanged()),this,SLOT(slotTrackSelectionChanged()));
}


CToolViewTrackProfile::~CToolViewTrackProfile()
{

}


void CToolViewTrackProfile::mousePressEvent(QMouseEvent * e)
{
    if(track.isNull()) return;

    if(e->button() == Qt::LeftButton) {
        double dist = m_pData->x().pt2val(e->pos().x() - left);
        QVector<CGarminTrack::TrkPt_t>::const_iterator trkpt = track->begin();
        quint32 idx = 0;
        while(trkpt != track->end()) {
            if(trkpt->flags & CGarminTrack::eDeleted) {
                ++trkpt; continue;
            }

            if(dist < trkpt->distance) {
                track->setPointOfFocus(idx);
                break;
            }
            idx = trkpt->idx;

            ++trkpt;
        }
    }
}


void CToolViewTrackProfile::slotTrackSelectionChanged()
{
    track = gpResources->trackdb().highlightedTrack();
    if(track.isNull()) {
        m_pData->line1.points.clear();
        m_pData->line2.points.clear();
        update();
        return;
    }

    QPolygonF line;
    QPolygonF marks;
    QVector<CGarminTrack::TrkPt_t>::const_iterator trackpoint = track->begin();
    while(trackpoint != track->end()) {
        if(trackpoint->flags & CGarminTrack::eDeleted) {
            ++trackpoint; continue;
        }
        line << QPointF(trackpoint->distance, trackpoint->alt);
        if(trackpoint->flags & CGarminTrack::eSelected) {
            marks << QPointF(trackpoint->distance, trackpoint->alt);
        }
        ++trackpoint;
    }
    setLine(line,marks);

}
