/*
 * Decompiled with CFR 0.152.
 */
package molikin;

import driftwood.data.CheapSet;
import driftwood.moldb2.Atom;
import driftwood.moldb2.Residue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import molikin.Util;

public class ResClassifier {
    public static final Object PROTEIN = "protein";
    public static final Object NUCACID = "nucleic_acid";
    public static final Object WATER = "water";
    public static final Object ION = "ion";
    public static final Object OHET = "other_het";
    public static final Object UNKNOWN = "unknown";
    Map map = new HashMap();
    public Set proteinRes = new CheapSet();
    public Set nucAcidRes = new CheapSet();
    public Set waterRes = new CheapSet();
    public Set ionRes = new CheapSet();
    public Set ohetRes = new CheapSet();
    public Set unknownRes = new CheapSet();

    public ResClassifier(Collection collection) {
        Residue residue3 = null;
        Object object = UNKNOWN;
        ArrayList<Residue> arrayList = new ArrayList<Residue>();
        for (Residue residue2 : collection) {
            Object object2;
            if (Util.isProtein(residue2)) {
                object2 = PROTEIN;
            } else if (Util.isNucleicAcid(residue2)) {
                object2 = NUCACID;
            } else if (Util.isWater(residue2)) {
                object2 = WATER;
            } else if (Util.isIon(residue2) && residue2.getAtoms().size() == 1) {
                object2 = ION;
            } else {
                int n = 0;
                for (Atom atom : residue2.getAtoms()) {
                    if (!atom.isHet()) continue;
                    ++n;
                }
                object2 = n > residue2.getAtoms().size() - n ? OHET : UNKNOWN;
            }
            if (object2 == UNKNOWN) {
                if ((object == PROTEIN || object == NUCACID) && this.isSameChain(residue3, residue2)) {
                    object2 = object;
                } else {
                    arrayList.add(residue2);
                }
            } else if (object2 == PROTEIN || object2 == NUCACID) {
                if (arrayList.size() > 0) {
                    for (Residue residue3 : arrayList) {
                        if (this.isSameChain(residue3, residue2)) {
                            this.map.put(residue3, object2);
                        }
                        if (object2 == PROTEIN) {
                            this.proteinRes.add(residue3);
                            continue;
                        }
                        if (object2 != NUCACID) continue;
                        this.nucAcidRes.add(residue3);
                    }
                    arrayList.clear();
                }
            } else {
                arrayList.clear();
            }
            this.map.put(residue2, object2);
            if (object2 == PROTEIN) {
                this.proteinRes.add(residue2);
            } else if (object2 == NUCACID) {
                this.nucAcidRes.add(residue2);
            } else if (object2 == WATER) {
                this.waterRes.add(residue2);
            } else if (object2 == ION) {
                this.ionRes.add(residue2);
            } else if (object2 == OHET) {
                this.ohetRes.add(residue2);
            } else if (object2 == UNKNOWN) {
                this.unknownRes.add(residue2);
            }
            residue3 = residue2;
            object = object2;
        }
    }

    private boolean isSameChain(Residue residue, Residue residue2) {
        return residue.getChain().equals(residue2.getChain()) && residue.sectionID == residue2.sectionID;
    }

    public Object classify(Residue residue) {
        return this.map.get(residue);
    }
}

