/*
 * Decompiled with CFR 0.152.
 */
package driftwood.isosurface;

import driftwood.isosurface.CrystalVertexSource;
import driftwood.util.SoftLog;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class Ccp4VertexSource
extends CrystalVertexSource {
    DataInputStream in;
    float[] data = null;
    boolean littleEndian = false;
    int[] idx = new int[3];
    int[] crs = new int[3];

    public Ccp4VertexSource(InputStream inputStream) throws IOException {
        this(inputStream, true);
    }

    public Ccp4VertexSource(InputStream inputStream, boolean bl) throws IOException {
        inputStream = new BufferedInputStream(inputStream);
        inputStream.mark(10);
        if (inputStream.read() == 31 && inputStream.read() == 139) {
            inputStream.reset();
            inputStream = new GZIPInputStream(inputStream);
        } else {
            inputStream.reset();
        }
        this.in = new DataInputStream(inputStream);
        super.init(bl);
    }

    void readHeader() throws IOException {
        byte[] byArray = new byte[1024];
        this.in.readFully(byArray);
        boolean bl = this.littleEndian = byArray[0] != 0;
        if (this.getInt(byArray, 4) != 2) {
            throw new IllegalArgumentException("Bad map data type: only mode 2 is supported");
        }
        if (byArray[208] != 77 || byArray[209] != 65 || byArray[210] != 80 || byArray[211] != 32) {
            throw new IllegalArgumentException("Bad map format: 'MAP ' missing at word #53");
        }
        this.crs[0] = this.getInt(byArray, 17) - 1;
        this.crs[1] = this.getInt(byArray, 18) - 1;
        this.crs[2] = this.getInt(byArray, 19) - 1;
        this.idx[this.crs[0]] = 0;
        this.idx[this.crs[1]] = 1;
        this.idx[this.crs[2]] = 2;
        this.aCount = this.getInt(byArray, 1 + this.idx[0]);
        this.aMin = this.getInt(byArray, 5 + this.idx[0]);
        this.aMax = this.aMin + this.aCount - 1;
        this.aSteps = this.getInt(byArray, 8);
        this.bCount = this.getInt(byArray, 1 + this.idx[1]);
        this.bMin = this.getInt(byArray, 5 + this.idx[1]);
        this.bMax = this.bMin + this.bCount - 1;
        this.bSteps = this.getInt(byArray, 9);
        this.cCount = this.getInt(byArray, 1 + this.idx[2]);
        this.cMin = this.getInt(byArray, 5 + this.idx[2]);
        this.cMax = this.cMin + this.cCount - 1;
        this.cSteps = this.getInt(byArray, 10);
        this.aLength = Float.intBitsToFloat(this.getInt(byArray, 11));
        this.bLength = Float.intBitsToFloat(this.getInt(byArray, 12));
        this.cLength = Float.intBitsToFloat(this.getInt(byArray, 13));
        this.alpha = Float.intBitsToFloat(this.getInt(byArray, 14));
        this.beta = Float.intBitsToFloat(this.getInt(byArray, 15));
        this.gamma = Float.intBitsToFloat(this.getInt(byArray, 16));
        this.mean = Float.intBitsToFloat(this.getInt(byArray, 22));
        this.sigma = Float.intBitsToFloat(this.getInt(byArray, 55));
        int n = this.getInt(byArray, 24);
        while (n > 0) {
            n = (int)((long)n - this.in.skip(n));
        }
    }

    protected int getInt(byte[] byArray, int n) {
        n = 4 * (n - 1);
        if (this.littleEndian) {
            return (byArray[n + 3] & 0xFF) << 24 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
        }
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    protected int getInt(int n) {
        if (this.littleEndian) {
            return (n & 0xFF) << 24 | (n & 0xFF00) << 8 | (n & 0xFF0000) >>> 8 | (n & 0xFF000000) >>> 24;
        }
        return n;
    }

    void readData() throws IOException {
        this.data = new float[this.aCount * this.bCount * this.cCount];
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        nArray2[this.idx[0]] = this.aCount;
        nArray2[this.idx[1]] = this.bCount;
        nArray2[this.idx[2]] = this.cCount;
        nArray[2] = 0;
        while (nArray[2] < nArray2[2]) {
            nArray[1] = 0;
            while (nArray[1] < nArray2[1]) {
                nArray[0] = 0;
                while (nArray[0] < nArray2[0]) {
                    float f = Float.intBitsToFloat(this.getInt(this.in.readInt()));
                    this.setValue(nArray[this.idx[0]], nArray[this.idx[1]], nArray[this.idx[2]], f);
                    nArray[0] = nArray[0] + 1;
                }
                nArray[1] = nArray[1] + 1;
            }
            nArray[2] = nArray[2] + 1;
        }
        SoftLog.err.println("map header  : mean = " + this.mean + "; sigma = " + this.sigma);
    }

    public boolean hasData() {
        return this.data != null;
    }

    public double getValue(int n, int n2, int n3) {
        return this.data[n + n2 * this.aCount + n3 * this.aCount * this.bCount];
    }

    protected void setValue(int n, int n2, int n3, double d) {
        this.data[n + n2 * this.aCount + n3 * this.aCount * this.bCount] = (float)d;
    }
}

