/*
 * qdacco: offline Dacco Catalan <-> English dictionary
 * Copyright (C) 2005-2006 Carles Pina i estany <carles@pina.cat>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 or any
 * later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 * USA.
*/


#ifndef MAIN_H
#define MAIN_H


#include <QApplication>
#include <QDialog>
#include <QMessageBox>
#include <QToolButton>
#include <QMainWindow>
#include <QClipboard>
#include "ui_main.h"
#include "configure.h"
#include "about.h"
#include "suggeriment.h"
#include "connection.h"
#include "textbrowser.h"
#include "auxiliar.h"

class Main : public QMainWindow, Ui::Main
{
	Q_OBJECT
	public:
		Main(QWidget *parent = 0);
	
	private:
		HTTPConnection *http;
		QProcess process;

		Ui::Main ui;

		int idioma_actiu;
		int showList;
		int numberFound;

		QString directori_usuari;
		QString searched;

		QToolButton *cat_eng;
		QToolButton *eng_cat;

		void treballaBuscar();
		void posarApunt();
		int isValidWord(QString &q);
		void posarApunt(int all);
		char lletra_buscar(QString q);
		void loadList(StructureParser *handler);
		void selectItem();
		void carrega_config(int all);
		
		void posa_idioma();

	private slots:
		void buscar();
		void obrir_configuracio();
		void obrir_about();
		void obrir_suggeriment();
		
		void cat_engf();
		void eng_catf();

		void switchDictionary();

		void copy_definition();
		void paste_word();

		void doList();

		void searchListWord(QListWidgetItem *a);
		void openBrowser(const QUrl &url);

	public slots:
		void changeActive(int a, bool b);
		void browser(QProcess::ProcessError error);
};
#endif
