/***************************************************************************
  hopdelegate.cpp
  -------------------
  Hop delegate editor
  -------------------
  Copyright 2006, David Johnson
  Please see the header file for copyright and license information
 ***************************************************************************/

#include <QAbstractItemModel>
#include <QComboBox>
#include <QDoubleSpinBox>
#include <QSpinBox>

#include "data.h"
#include "hop.h"
#include "hopdelegate.h"

const int extra = 1; // always display one extra blank row

HopDelegate::HopDelegate(QObject *parent) : QItemDelegate(parent) {}

HopDelegate::~HopDelegate() {}

QWidget *HopDelegate::createEditor(QWidget *parent,
                                     const QStyleOptionViewItem &/*option*/,
                                     const QModelIndex &index) const
{
    QComboBox *combo;
    QSpinBox *spin;
    QDoubleSpinBox *dspin;
    QString suffix;
    // can only edit name on blank row
    bool blank = index.row() >= index.model()->rowCount() - extra;


    // different kind of editor for each column
    switch (index.column()) {
      case Hop::NAME:
          combo = new QComboBox(parent);
          combo->setEditable(true);
          combo->addItem(QString());
          combo->addItems(Data::instance()->hopsList());
          combo->installEventFilter(const_cast<HopDelegate*>(this));
          return combo;

      case Hop::QUANTITY:
          if (blank) return 0;
          dspin = new QDoubleSpinBox(parent);
          dspin->setDecimals(2);
          dspin->setRange(0.00, 100.00);
          dspin->setSingleStep(0.25);
          suffix = " " + Data::instance()->defaultHopUnit().symbol();
          dspin->setSuffix(suffix);
          dspin->installEventFilter(const_cast<HopDelegate*>(this));
          return dspin;

      case Hop::ALPHA:
          if (blank) return 0;
          dspin = new QDoubleSpinBox(parent);
          dspin->setDecimals(1);
          dspin->setRange(0.0, 50.0);
          dspin->setSingleStep(0.1);
          dspin->setSuffix("%");
          dspin->installEventFilter(const_cast<HopDelegate*>(this));
          return dspin;

      case Hop::TIME:
          if (blank) return 0;
          spin = new QSpinBox(parent);
          spin->setRange(0, 120);
          spin->setSingleStep(5);
          spin->setSuffix(" min");
          spin->installEventFilter(const_cast<HopDelegate*>(this));
          return spin;

      case Hop::FORM:
          if (blank) return 0;
          combo = new QComboBox(parent);
          combo->setEditable(true);
          combo->addItems(Data::instance()->formsList());
          combo->installEventFilter(const_cast<HopDelegate*>(this));
          return combo;

      default:
          return 0;
    }
}

void HopDelegate::setEditorData(QWidget *editor,
                                const QModelIndex &index) const
{
    QComboBox *combo;
    QSpinBox *spin;
    QDoubleSpinBox *dspin;
    int comboindex;

    QVariant value = index.model()->data(index, Qt::EditRole);

    // different kind of editor for each column
    switch (index.column()) {
      case Hop::NAME:
          combo = static_cast<QComboBox*>(editor);
          if (!combo) return;
          comboindex = combo->findText(value.toString());
          if (comboindex > 0) {
              combo->setCurrentIndex(comboindex);
          } else {
              combo->setEditText(value.toString());
          }
          break;

      case Hop::QUANTITY:
      case Hop::ALPHA:
          dspin = static_cast<QDoubleSpinBox*>(editor);
          if (!dspin) return;
          dspin->setValue(value.toDouble());
          break;

      case Hop::TIME:
          spin = static_cast<QSpinBox*>(editor);
          if (!spin) return;
          spin->setValue(value.toUInt());
          break;

      case Hop::FORM:
          combo = static_cast<QComboBox*>(editor);
          if (!combo) return;
          comboindex = combo->findText(value.toString());
          if (comboindex > 0) {
              combo->setCurrentIndex(comboindex);
          } else {
              combo->setEditText(value.toString());
          }
          break;

      default:
          QItemDelegate::setEditorData(editor, index);
          break;
    }
}

void HopDelegate::setModelData(QWidget *editor, QAbstractItemModel *model,
                      const QModelIndex &index) const
{
    QComboBox *combo;
    QSpinBox *spin;
    QDoubleSpinBox *dspin;
    QVariant value;

    // different kind of editor for each column
    switch (index.column()) {
      case Hop::NAME:
      case Hop::FORM:
          combo = static_cast<QComboBox*>(editor);
          if (!combo) return;
          value = combo->currentText();
          model->setData(index, value);
          break;

      case Hop::QUANTITY:
      case Hop::ALPHA:
          dspin = static_cast<QDoubleSpinBox*>(editor);
          if (!dspin) return;
          value = dspin->value();
          model->setData(index, value);
          break;

      case Hop::TIME:
          spin = static_cast<QSpinBox*>(editor);
          if (!spin) return;
          value = spin->value();
          model->setData(index, value);
          break;

      default:
          QItemDelegate::setModelData(editor, model,index);
          break;
    }
}

void HopDelegate::updateEditorGeometry(QWidget *editor,
                              const QStyleOptionViewItem &option,
                              const QModelIndex &/*index*/) const
{
    editor->setGeometry(option.rect);
}
