#include "listmanager.h"
#include <iostream>
#include <string>
#include <cstdlib>

playlistManager * playlistManager::m_self;

QString formatTime(unsigned int time)
{
	QString strTime;
	ldiv_t timeDiv = ldiv(time/1000, 60);
	strTime.sprintf("%ld:%.2ld", timeDiv.quot, timeDiv.rem);
	return strTime;
}

bool substr_find(const string &haystack, const string &needle)
{
    if (needle.size() > haystack.size())
        return false;
 
    const char *h, *n;
    h = haystack.c_str();
    n = needle.c_str();
 
    while (*h)
    {
        if (tolower(*h) == tolower(*n))
        {
            bool found = false;
            while (tolower(*h) == tolower(*n))
            {
                h++; n++;
                if (! *n)
                {
                    found = true;
                    break;
                }
            }
            if (found == true)
                return true;
            else
                n = needle.c_str();
        }
        h++;
    }
    return false;
}                     


playlistManager::playlistManager() 
	: m_wrapper(playlistWrapper::self())
{
	cout << "playlistManager singleton constructed" << endl;
	m_wrapper.updatePlaylist();
}

void playlistManager::searchTextUpdated(playlistDialog &dialog, const string &text)
{
	// we should have a function which does a once off collection of the data, for the initial bit.
	// then we have another one which periodically gets the latest from the playlist.
	// iterate over the list in the playlistWrapper, search for substrings.
	unsigned int i=0;
	dialog.clearList();
	for (i=0; i<m_wrapper.length(); ++i)
	{
		if (text == "" || substr_find(m_wrapper[i].m_title, text)
			|| substr_find(m_wrapper[i].m_filename, text))
		{
			dialog.addToList(m_wrapper[i]);
		}
	}
}

void playlistManager::doubleClickOnList(playlistDialog &dialog, unsigned int id)
{
	m_wrapper.playFileByPos(id);
}

playlistManager & playlistManager::self()
{
	if (m_self == 0)
		m_self = new playlistManager;
	return *m_self;
}

QString playlistManager::getStatusBarText() const
{
	QString str;
	int stat = m_wrapper.getPlayerStatus();
	
	switch (stat)
	{
	case playlistWrapper::PAUSED:
		str = "Paused: ";
		break;
	case playlistWrapper::PLAYING:
		str = "Playing: ";
		break;
	default:
		str = "Stopped";
		return str;
		break;
	}

	QString ret;
	const t_songInfo & temp = m_wrapper.getCurrentSong();
	QString thisTime, endTime;
	thisTime = formatTime(m_wrapper.getCurrentTime());
	endTime = formatTime(temp.m_time);
	ret.sprintf("%s %s, %s/%s", str.latin1(), temp.m_title.c_str(), thisTime.latin1(), endTime.latin1());

	return ret;
}

bool playlistManager::getRandomStatus() const
{
	return m_wrapper.getRandomStatus();
}

void playlistManager::stopPressed() const
{
	m_wrapper.pressStop();
}

void playlistManager::playPressed() const
{
	m_wrapper.pressPlay();
}

void playlistManager::nextPressed() const
{
	m_wrapper.pressNext();
}

void playlistManager::prevPressed() const
{
	m_wrapper.pressPrev();
}

void playlistManager::pausePressed() const
{
	m_wrapper.pressPause();
}

int playlistManager::getPlayingId() const
{
	int stat = m_wrapper.getPlayerStatus();
	if (stat == playlistWrapper::PAUSED ||
		stat == playlistWrapper::PLAYING)
	{
		return m_wrapper.getCurrentSong().m_position;
	}
	else
		return -1;
}

void playlistManager::randomToggle() const
{
	m_wrapper.setRandomStatus();
}

void playlistManager::updatePlaylist() const
{
	m_wrapper.updatePlaylist();
}
