# File: mailbox.py
# Purpose: pop3 inbox class

from gtk import *
import GtkExtra

import socket
import string

from pyneheaders import *
import mail_recv
from mail_recv import *
import mail_send
from mail_send import *
from superbox import *
import boxformats
import boxformats.configbox
from ptk.big_edit_box import *
import pynei18n

class mailbox(superbox):
	"""
	Pop3 inbox.
	"""
	def get_flags(self):
		return BOX_ISDELETEABLE | BOX_MAKE_NEW_MSG | \
		       BOX_REPLY_SINGLE | BOX_REPLY_GROUP | \
		       BOX_REPLY_FORWARD | BOX_DEL_MESSAGE | \
		       BOX_UPDATE_METHOD
	
	def __init__(self, user, name, uid, no_startup=0):
		"""
		Create new pop inbox.
		"""

		# Basic setup
		superbox.__init__(self, name, uid)

		self.recv_type = mail_recv.MAIL_RECV_POP3
		self.send_type = mail_send.MAIL_SEND_SMTP
		
		self.recv_conf = { "server": "pop.someisp.com",
				    "port": 110,
				    "username": "",
				    "password": "" }
		self.send_conf = { "server": "smtp.someisp.com",
				     "port": 25,
				     "username": "",
				     "password": "" }
		self.realname = "your name"
		self.emailaddr = "someguy@some.com"
		self.replyto = ""
		self.org = ""
		self.sigfile = "~/.signature"
		self.expire_after = None
		self.export_format = (boxformats.BF_FLATFILEBOX, None)

		self.contents = [] # sub-folders
		self.filters = []

		if no_startup == 0:
			self.startup(user)

	def clean_4_save(self):
		"""
		Remove stuff we don't want saved to disk
		"""
		if self.__dict__.has_key("locked"):
			del self.locked
		if self.__dict__.has_key("changed"):
			del self.changed
		del self.recv_server
		del self.send_server
		del self.io
		del self.messages

	def startup(self, user):
		"""
		Get an io module for loading/saving articles
		"""
		i = self.export_format[0]
		# this is a pretty piece of code :-)
		bf_class = boxformats.__dict__[boxformats.__all__[i]]. \
			   __dict__[boxformats.__all__[i]]
		self.io = bf_class(user, self)
		# get recv and send server types
		i = self.recv_type
		self.recv_server = mail_recv.__dict__[mail_recv.__all__[i]]
		i = self.send_type
		self.send_server = mail_send.__dict__[mail_send.__all__[i]]
		self.messages = self.io.get_contents()

	def getstats(self):
		"""
		Returns message to be put in 'items' field of mailbox view.
		"""
		return (len(self.messages),)

	def get_menu(self):
		"""
		This folder type specific options.
		"""
		return []
	
	def menu_chosen(self, _a, choice):
		return

	def post_message(self, connection, msg):
		"""
		Post message 'msg' with SMTP connection.
		"""
		self.send_server.post_message(connection, msg)

	def get_connection(self, recv=0):
		"""
		Return a connection object. if pop=0: smtp, pop=1: pop3.
		"""
		if recv == 0:
			# establish smtp connection
			c = self.send_server.get_connection(self.send_conf)
			return c
		else:
			# establish pop3 connection
			c = self.recv_server.get_connection(self.recv_conf)
			return c

	def setup(self, parent_user):
		"""
		Configure a mailbox.
		"""
		import msgfilter
		win = GtkWindow()
		win.set_title(self.name+" "+_("Setup"))

		box = GtkVBox()
		box.set_border_width(5)
		win.add(box)
		box.show()

		notebook = GtkNotebook()
		notebook.set_tab_pos(POS_TOP)
		box.pack_start(notebook)
		notebook.show()
	
		# First page: Misc settings
		box1 = GtkVBox(spacing=5)

		settings_box0 = big_edit_box( self,
		      ( ("name", _("Name:"), VAR_TYPE_STRING, 0, 0),
			("realname", _("Real name:"), VAR_TYPE_STRING, 0, 0),
			("emailaddr", _("Email address"), VAR_TYPE_STRING, 0, 0),
			("replyto", _("Reply to:"), VAR_TYPE_STRING, 0, 0),
			("sigfile", _("Signature file:"), VAR_TYPE_STRING, 0, 0,
				(GtkExtra.file_sel_box, (_("Select Signature File"),))),
			("expire_after", _("Expire after (days):"), VAR_TYPE_INTEGER, 0, None),
			("opts", _("Thread messages"), VAR_TYPE_PACKED_BIT_BOOLEAN, 0, OPT_THREAD) )
		)

		box1.pack_start(settings_box0, expand=FALSE)
		settings_box0.show()

		def _change_send_server(item, self=self):
			type = item.get_data("0")
			# if changed
			if mail_send.__all__.index(type) != self.send_type:
				self.send_type = mail_send.__all__.index(type)
				self.send_server = mail_send.__dict__[mail_send.__all__[self.send_type]]
				self.send_server.fix_defaults(self.send_conf)
		def _config_send_server(_button, self=self):
			self.send_server.setup(self, self.send_conf)
		def _config_recv_server(_button, self=self):
			self.recv_server.setup(self, self.recv_conf)
				
		def _change_recv_server(item, self=self):
			type = item.get_data("0")
			# if changed
			if mail_recv.__all__.index(type) != self.recv_type:
				self.recv_type = mail_recv.__all__.index(type)
				self.recv_server = mail_recv.__dict__[mail_recv.__all__[self.recv_type]]
				self.recv_server.fix_defaults(self.recv_conf)

		# 2nd page: server settings
		
		table = GtkTable(3,2)
		table.set_row_spacings(5)
		table.set_col_spacings(5)
		box1.pack_start(table, expand=FALSE)
		table.show()
		
		label = GtkLabel(_("Send server"))
		table.attach(label, 0,1, 0,1)
		label.show()
		menu = GtkMenu()
		menu.show()
		for i in range(0, len(mail_send.__all__)):
			menuitem = GtkMenuItem(mail_send.names[i])
			menuitem.set_data("0", mail_send.__all__[i])
			menuitem.connect("activate", _change_send_server)
			menu.append(menuitem)
			menuitem.show()
		optmenu = GtkOptionMenu()
		optmenu.set_menu(menu)
		optmenu.set_history(self.send_type)
		table.attach(optmenu, 1,2, 0,1)
		optmenu.show()
		button = GtkButton(_("Configure"))
		button.connect("clicked", _config_send_server)
		table.attach(button, 2,3, 0,1)
		button.show()
		
		label = GtkLabel(_("Receive server"))
		table.attach(label, 0,1, 1,2)
		label.show()
		menu = GtkMenu()
		menu.show()
		for i in range(0, len(mail_recv.names)):
			menuitem = GtkMenuItem(mail_recv.names[i])
			menuitem.set_data("0", mail_recv.__all__[i])
			menuitem.connect("activate", _change_recv_server)
			menu.append(menuitem)
			menuitem.show()
		optmenu = GtkOptionMenu()
		optmenu.set_menu(menu)
		optmenu.set_history(self.recv_type)
		table.attach(optmenu, 1,2, 1,2)
		optmenu.show()
		button = GtkButton(_("Configure"))
		button.connect("clicked", _config_recv_server)
		table.attach(button, 2,3, 1,2)
		button.show()

		
		label = GtkLabel(_("Settings"))
		notebook.append_page(box1, label)
		box1.show()

		# 3rd page: mail filters
		label = GtkLabel(_("Filters"))
		filterbox = msgfilter.filter_editbox(self, parent_user)
		notebook.append_page(filterbox, label)
		filterbox.show()

		# 4th page: storage method
		label = GtkLabel(_("Mailbox Format"))
		formatbox = boxformats.configbox.configbox(self, parent_user)
		notebook.append_page(formatbox, label)
		formatbox.show()

		def save_changes(_button, filterbox=filterbox, self=self, \
				parent_user=parent_user, win=win, settings_box0 = settings_box0):
			# Extract info
			settings_box0.apply_changes()
			self.filters = filterbox.filters
			# update folder list
			self.changed = 1
			parent_user.update()
			win.destroy()

		# Seperator between entry boxes and buttons
		separator = GtkHSeparator()
		box.pack_start(separator, expand=FALSE)
		separator.show()

		# Buttons at bottom
		lastbox = GtkHBox(spacing=5)
		lastbox.set_border_width(10)
		box.pack_start(lastbox, expand=FALSE)
		lastbox.show()

		cancel_button = GtkButton(" "+_("Cancel")+" ")
		cancel_button.connect("clicked", win.destroy)
		lastbox.pack_end(cancel_button, expand=FALSE)
		cancel_button.show()

		ok_button = GtkButton(" "+_("Ok")+" ")
		ok_button.connect("clicked", save_changes)
		lastbox.pack_end(ok_button, expand=FALSE)
		ok_button.show()

		win.show()

	def remote_get_header(self, connection, index):
		"""
		Return header of message 'index' in pop3 box.
		Get rid of nasty nulls.
		"""
		head = connection.get_header(index)
		head = string.replace(head, "\000", "")
		return head

	def remote_get_body(self, connection, index):
		"""
		return body of message 'index' in pop3 box.
		Get rid of nasty nulls.
		"""
		body = connection.get_body(index)
		body = string.replace(body, "\000", "")
		return body

	def remote_delete(self, connection, index):
		"""
		delete message from remote pop3 inbox.
		"""
		connection.delete_msg(index)

	def update(self, parent_user, pager):
		"""
		Update the box. Collect mail from pop3 server.
		"""
		import msgfilter
		self.locked = 1
		# If no server is designated abort collection
		if self.recv_type == mail_recv.MAIL_RECV_NONE:
			del self.locked
			return
		threads_enter()
		progressbar = pager.get_progress_bar()
		progressbar.set_format_string(_("Collecting %s mail") % self.name)
		msg_print = pager.msg_print
		msg_print(_("%s: Connecting to %s...") % (self.name, self.recv_conf["server"]))
		threads_leave()

		try:
			# Connect to server
			p = self.get_connection(recv=1)
		except socket.error, e:
			usermsg = _("Error downloading %s: %s") % (self.name, str(e.args))
			threads_enter()
			progressbar.set_format_string(usermsg)
			msg_print(usermsg)
			progressbar.set_sensitive(FALSE)
			threads_leave()
			del self.locked
			return

		usermsg = _("Verifying %s username and password") % self.name
		threads_enter()
		msg_print(usermsg)
		progressbar.set_format_string(usermsg)
		threads_leave()

		try:
			# Verify username & password
			p.auth()
		except recv.auth_exception:
			p.close_connection()
			usermsg = _("%s login incorrect") % self.name
			threads_enter()
			msg_print(usermsg)
			progressbar.set_format_string(usermsg)
			progressbar.set_sensitive(FALSE)
			threads_leave()
			del self.locked
			return

		# store nice listy thing of messages to collect
		self.pending_msgs = p.get_msg_list()
		nummsgs = len( self.pending_msgs )

		# Start collecting
		num = 0
		for i in self.pending_msgs.keys():
			#s = "<%s> Collecting message " % self.name +str(i+1)+"/"+str(nummsgs)
			threads_enter()
			#msg_print(s)
			progressbar.set_percentage(num/float(nummsgs))
			progressbar.set_format_string("%d/%d of " % (num, nummsgs) + self.name)
			threads_leave()

			msg = msgfilter.filter_collect(parent_user, self, p, i)
			if msg != "":
				threads_enter()
				msg_print(msg)
				threads_leave()
			num = num + 1
		p.close_connection()

		usermsg = _("%s done, %d/%d messages collected.") % (self.name, num, nummsgs)
		threads_enter()
		msg_print(usermsg)
		progressbar.set_percentage(0.0)
		progressbar.set_format_string(usermsg)
		progressbar.set_sensitive(FALSE)
		threads_leave()

		threads_enter()
		self.changed = 1
		parent_user.update()
		threads_leave()

		del self.pending_msgs
		del self.locked

