#
# Flat file pyne box. base64 filename of message id.
# Headers marshalled first, then message body.
#

import marshal
import os
import os.path
import time
import binascii
from base64 import encodestring
from base64 import decodestring
from string import find, replace
from glob import glob
from pyneheaders import *
from superbox import superbox

def id_2_hash(id):
	x = encodestring(id)
	# some things are nasty in filenames.. yeah this is retarded
	x = replace(x, "\012", "")
	x = replace(x, "/", "|")
	# remove this junk some time
	return x

def hash_2_id(hash):
	try:
		return decodestring(replace(hash, "|", "/"))
	except binascii.Error:
		return None

class flatfilebox(superbox):
	def __init__(self, user, parent_messagebox):
		self.prefix = str(parent_messagebox.uid)
		self.user = user

		# make sure our folder is here
		if not os.path.isdir(self.prefix):
			os.mkdir(self.prefix)

	def get_contents(self):
		files = glob(self.prefix+"/*")
		ids = []
		for i in files:
			ids.append(hash_2_id(os.path.basename(i)))
		return ids

	def nuke(self):
		"""
		Delete database entirely.
		"""
		for i in glob(self.prefix+"/*"):
			os.remove(i)
		os.removedirs(self.prefix)

	def __del__(self):
		pass
		
	def load_header(self, msg_id):
		"""
		Return message header or None if not found. in form:
		(date, date_received, message-id, references,
		subject, from, type, isread, isreplied, senduid)
		"""
		try:
			f = open(self.prefix+"/"+id_2_hash(msg_id))
			return marshal.load(f)
		except (TypeError, IOError, EOFError):
			return None

	def _load_article(self, msg_id):
		"""
		Returm body for message 'msg_id'.
		"""
		try:
			f = open(self.prefix+"/"+id_2_hash(msg_id))
			head = marshal.load(f)
			body = f.read()
			f.close()
			return (head, body)
		except IOError:
			return (None, None)

	def _save_article(self, headers, body_text, msg_id):
		"""
		Do not use directly. use save_article.
		"""
		s = marshal.dumps(headers)
		f = open(self.prefix+"/"+id_2_hash(msg_id), "w")
		f.write(s)
		f.write(body_text)

	def delete_article(self, msg_id):
		try:
			os.remove(self.prefix+"/"+id_2_hash(msg_id))
		except OSError:
			pass

	def has_article(self, msg_id):
		"""
		Is the article cached?
		"""
		# NOTE: we check for presence of headers not bodies
		if os.path.isfile(self.prefix+"/"+id_2_hash(msg_id)):
			return 1
		else:
			return 0


