## This file contains the default templates used when creating a
## project
# >>>   IMPORTANT!  <<<<
# Notice that default license is GPL

__all__ = ( "DEFAULT_HEADER", "DEFAULT_MAP" )


header = """#  -------------------------------------------------------------------------
#  This file was initially generated by gtkmvc progen-$version
#  Generation timestamp: $date 
#  -------------------------------------------------------------------------
#
#  Author: $author  $email
#
#  $copyright
#
#  This file is part of ${name}.
#
$license
#  -------------------------------------------------------------------------

$comment
"""


gpl = """#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
"""

model = """
from gtkmvc import ${base_class_name}

class ${class_name} (${base_class_name}):

    # Observable properties
    __properties__ = {
        }
    
    def __init__(self):
        ${base_class_name}.__init__(self)
        return
    
    pass # end of class ${class_name}
"""

ctrl = """
from gtkmvc import Controller
from gtkmvc import adapters
import gtk

class ${class_name} (${base_class_name}):
    
    def __init__(self, model):
        ${base_class_name}.__init__(self, model)
        return

    def register_view(self, view):
        ${base_class_name}.register_view(self, view)

        # setup of widgets
        self.view['${top_widget}'].connect('delete-event', self.on_${top_widget}_delete_event)
        return

    def register_adapters(self):
        # setup of adapters
        return

    # Handlers for signals:
    def on_${top_widget}_delete_event(self, win, event):
        gtk.main_quit() # say goodbye
        return True

    # Notifications from observable properties:
    
    pass # end of class ${class_name}
"""

view_glade = """
from gtkmvc import View
import utils.globals

import gtk
import os.path

class ${class_name} (${base_class_name}):
    GLADE_FILE = os.path.join(utils.globals.GLADE_DIR, "${glade_fn}")
    def __init__(self, ctrl):
        ${base_class_name}.__init__(self, ctrl, self.GLADE_FILE,
                                     "${top_widget}", register=False)
        self.setup_widgets()
        ctrl.register_view(self)
        return

    def setup_widgets(self):
        # construction of manual widgets and other settings
        return

    pass # end of class ${class_name}
"""


view_noglade = """
from gtkmvc import View
import gtk

class ${class_name} (${base_class_name}):

    def __init__(self, ctrl):
        ${base_class_name}.__init__(self, ctrl, register=False)
        self.setup_widgets()
        ctrl.register_view(self)
        return

    def setup_widgets(self):
        # construction of manual widgets and other settings
        w = gtk.Window()
        w.set_title("Hello ${name}")
        h = gtk.VBox(); w.add(h)
        lbl = gtk.Label()
        lbl.set_markup("<big><b>Hello ${author}!</b></big>")
        h.add(lbl)
        self['label1'] = lbl

        lbl = gtk.Label()
        lbl.set_markup('''This is a demo of a <b>gtkmvc</b>-based application
without a <i>glade</i> file''')
        h.add(lbl)
        self['label2'] = lbl

        w.show_all()
        self['${top_widget}'] = w
        return

    pass # end of class ${class_name}
"""

glob = """
import os.path
import sys

if sys.argv[0]: top_dir = os.path.dirname(os.path.abspath(sys.argv[0]))
else: top_dir = "."

# ----------------------------------------------------------------------
TOPDIR = top_dir
RESOURCES_DIR = os.path.join(TOPDIR, "${res_name}")
GLADE_DIR = os.path.join(RESOURCES_DIR, "glade")
STYLES_DIR = os.path.join(RESOURCES_DIR, "styles")
APPL_SHORT_NAME = "${name}"
APPL_VERSION = (1, 0, 0)
# ----------------------------------------------------------------------

"""


main = '''
import gtk

def setup_path():
    """Sets up the python include paths to include needed directories"""
    import os.path; import sys
    from ${src_name}.utils.globals import TOPDIR 
    sys.path = [os.path.join(TOPDIR, "${src_name}")] + sys.path
    return


def check_requirements():
    """Checks versions and other requirements"""
    import gtkmvc; gtkmvc.require("1.2.0")
    return

def main(*args, **kargs):
    ${model_import} as ApplModel
    ${ctrl_import} as ApplCtrl
    ${view_import} as ApplView

    m = ApplModel()
    c = ApplCtrl(m)
    v = ApplView(c)

    gtk.main()    
    return

if __name__ == "__main__":
    setup_path()
    check_requirements()
    main()
    pass
'''

glade_file = '''<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<!DOCTYPE glade-interface SYSTEM "glade-2.0.dtd">
<!--Generated with glade3 3.2.0 on Thu Oct  4 16:50:42 2007 by cavada@asia-->
<glade-interface>
  <widget class="GtkWindow" id="${top_widget}">
    <property name="visible">True</property>
    <property name="events">GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK | GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK</property>
    <property name="border_width">12</property>    
    <property name="title" translatable="yes">Hello ${name}</property>
    <child>
      <widget class="GtkVBox" id="vbox1">
        <property name="visible">True</property>
        <property name="events">GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK | GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK</property>
        <property name="spacing">12</property>
        <child>
          <widget class="GtkLabel" id="label1">
            <property name="visible">True</property>
            <property name="events">GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK | GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK</property>
            <property name="label" translatable="yes">&lt;big&gt;&lt;b&gt;Hello ${author}!&lt;/b&gt;&lt;/big&gt;

This is a demo from gtkmvc Project Generator</property>
            <property name="use_markup">True</property>
            <property name="justify">GTK_JUSTIFY_CENTER</property>
          </widget>
          <packing>
            <property name="expand">False</property>
          </packing>
        </child>
        <child>
          <widget class="GtkLabel" id="label2">
            <property name="visible">True</property>
            <property name="events">GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK | GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK</property>
            <property name="label" translatable="yes">To start editing your project:
1. Change glade file into resources/glade by using &lt;tt&gt;Glade&lt;/tt&gt;
2. Adapt skeleton source code that has been generated

Hope you will enjoy designing and developing with gtkmvc!

For further information take a tour at 
&lt;u&gt;http://pygtkmvc.sourceforge.net&lt;/u&gt;</property>
            <property name="use_markup">True</property>
          </widget>
          <packing>
            <property name="position">1</property>
          </packing>
        </child>
      </widget>
    </child>
  </widget>
</glade-interface>
'''

# These are exported outside
# ----------------------------------------------------------------------
DEFAULT_HEADER = header
VERSION=("1","2","0")
DEFAULT_MAP = { 'license' : gpl, 'version' : ".".join(VERSION) }
# ----------------------------------------------------------------------
