/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Switch;
import visad.BadMappingException;
import visad.BaseColorControl;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.DisplayTupleType;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.GraphicsModeControl;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.ImageFlatField;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.LinearNDSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.Set;
import visad.ShadowFunctionOrSetType;
import visad.ShadowRealTupleType;
import visad.ShadowRealType;
import visad.ShadowType;
import visad.Unit;
import visad.VisADException;
import visad.VisADQuadArray;
import visad.VisADTriangleStripArray;
import visad.bom.ImageRendererJ3D;
import visad.bom.Mosaic;
import visad.bom.SwitchNotify;
import visad.bom.Tile;
import visad.java3d.AVControlJ3D;
import visad.java3d.AnimationControlJ3D;
import visad.java3d.ShadowFunctionTypeJ3D;
import visad.java3d.VisADImageNode;
import visad.java3d.VisADImageTile;
import visad.util.Util;

public class ShadowImageByRefFunctionTypeJ3D
extends ShadowFunctionTypeJ3D {
    private static final int MISSING1 = -128;
    private VisADImageNode imgNode = null;
    private VisADImageNode prevImgNode = null;
    private int prevDataWidth = -1;
    private int prevDataHeight = -1;
    private int prevNumImages = -1;
    AnimationControlJ3D animControl = null;
    private boolean reuse = false;
    private boolean reuseImages = false;

    public ShadowImageByRefFunctionTypeJ3D(MathType t, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        super(t, link, parent);
        System.out.println("Using Image byReference rendering");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean doTransform(Object group, Data data, float[] value_array, float[] default_values, DataRenderer renderer) throws VisADException, RemoteException {
        Iterator iter;
        VisADImageTile tile;
        int color_length;
        DisplayImpl display;
        int cMapCurveSize;
        Node g;
        DataDisplayLink link = renderer.getLink();
        if (data.isMissing()) {
            ((ImageRendererJ3D)renderer).markMissingVisADBranch();
            return false;
        }
        if (this.getLevelOfDifficulty() == 6) {
            return false;
        }
        if (group instanceof BranchGroup && ((BranchGroup)group).numChildren() > 0 && (g = ((BranchGroup)group).getChild(0)) instanceof BranchGroup && ((BranchGroup)g).numChildren() > 0) {
            this.reuseImages = true;
        }
        int curved_size = (cMapCurveSize = (int)default_values[(display = this.getDisplay()).getDisplayScalarIndex(Display.CurvedSize)]) > 0 ? cMapCurveSize : display.getGraphicsModeControl().getCurvedSize();
        this.prevImgNode = ((ImageRendererJ3D)renderer).getImageNode();
        BranchGroup bgImages = null;
        if (!this.reuse) {
            BranchGroup branch = new BranchGroup();
            branch.setCapability(17);
            branch.setCapability(14);
            branch.setCapability(12);
            branch.setCapability(13);
            Switch swit = (Switch)this.makeSwitch();
            this.imgNode = new VisADImageNode();
            bgImages = new BranchGroup();
            bgImages.setCapability(17);
            bgImages.setCapability(14);
            bgImages.setCapability(12);
            bgImages.setCapability(13);
            swit.addChild((Node)bgImages);
            swit.setWhichChild(0);
            branch.addChild((Node)swit);
            this.imgNode.setBranch(branch);
            this.imgNode.setSwitch(swit);
            ((ImageRendererJ3D)renderer).setImageNode(this.imgNode);
            if (((BranchGroup)group).numChildren() > 0) {
                ((BranchGroup)group).setChild((Node)branch, 0);
            } else {
                ((BranchGroup)group).addChild((Node)branch);
            }
        } else {
            this.imgNode = ((ImageRendererJ3D)renderer).getImageNode();
        }
        ShadowFunctionOrSetType adaptedShadowType = (ShadowFunctionOrSetType)this.getAdaptedShadowType();
        GraphicsModeControl mode = (GraphicsModeControl)display.getGraphicsModeControl().clone();
        boolean anyContour = adaptedShadowType.getAnyContour();
        boolean anyFlow = adaptedShadowType.getAnyFlow();
        boolean anyShape = adaptedShadowType.getAnyShape();
        boolean anyText = adaptedShadowType.getAnyText();
        if (anyContour || anyFlow || anyShape || anyText) {
            throw new BadMappingException("no contour, flow, shape or text allowed");
        }
        int valueArrayLength = display.getValueArrayLength();
        int[] valueToScalar = display.getValueToScalar();
        int[] valueToMap = display.getValueToMap();
        Vector MapVector = display.getMapVector();
        float[][] display_values = new float[valueArrayLength][];
        int[] inherited_values = adaptedShadowType.getInheritedValues();
        for (int i = 0; i < valueArrayLength; ++i) {
            if (inherited_values[i] <= 0) continue;
            display_values[i] = new float[1];
            display_values[i][0] = value_array[i];
        }
        Set domain_set = ((Field)data).getDomainSet();
        Unit[] dataUnits = null;
        CoordinateSystem dataCoordinateSystem = null;
        int numImages = 1;
        FlatField imgFlatField = null;
        ShadowRealType[] DomainComponents = adaptedShadowType.getDomainComponents();
        if (!adaptedShadowType.getIsTerminal()) {
            ScalarMap map;
            Vector domain_maps = DomainComponents[0].getSelectedMapVector();
            ScalarMap amap = null;
            if (domain_set.getDimension() == 1 && domain_maps.size() == 1 && Display.Animation.equals((map = (ScalarMap)domain_maps.elementAt(0)).getDisplayScalar())) {
                amap = map;
            }
            if (amap == null) {
                throw new BadMappingException("time must be mapped to Animation");
            }
            this.animControl = (AnimationControlJ3D)amap.getControl();
            double[][] values = domain_set.getDoubles();
            double[] times = values[0];
            int len = times.length;
            double delta = Math.abs((times[len - 1] - times[0]) / (1000.0 * (double)len));
            numImages = len;
            SwitchNotify swit = new SwitchNotify(this.imgNode, len);
            this.animControl.addPair(swit, domain_set, renderer);
            ((AVControlJ3D)this.animControl).init();
            adaptedShadowType = (ShadowFunctionOrSetType)adaptedShadowType.getRange();
            DomainComponents = adaptedShadowType.getDomainComponents();
            imgFlatField = (FlatField)((FieldImpl)data).getSample(0);
        } else {
            imgFlatField = (FlatField)data;
        }
        domain_set = imgFlatField.getDomainSet();
        dataUnits = imgFlatField.getDomainUnits();
        dataCoordinateSystem = imgFlatField.getDomainCoordinateSystem();
        int domain_length = domain_set.getLength();
        int[] lengths = ((GriddedSet)domain_set).getLengths();
        int data_width = lengths[0];
        int data_height = lengths[1];
        this.imgNode.numImages = numImages;
        this.imgNode.data_width = data_width;
        this.imgNode.data_height = data_height;
        int texture_width_max = link.getDisplay().getDisplayRenderer().getTextureWidthMax();
        int texture_height_max = link.getDisplay().getDisplayRenderer().getTextureWidthMax();
        Mosaic mosaic = new Mosaic(data_height, texture_height_max, data_width, texture_width_max);
        int texture_width = this.textureWidth(data_width);
        int texture_height = this.textureHeight(data_height);
        if (this.reuseImages && (this.prevImgNode.numImages != numImages || this.prevImgNode.data_width != data_width || this.prevImgNode.data_height != data_height)) {
            this.reuseImages = false;
        }
        if (this.reuseImages) {
            this.imgNode.numChildren = this.prevImgNode.numChildren;
            this.imgNode.imageTiles = this.prevImgNode.imageTiles;
        } else {
            Iterator iter2 = mosaic.iterator();
            while (iter2.hasNext()) {
                Tile tile2 = (Tile)iter2.next();
                this.imgNode.addTile(new VisADImageTile(numImages, tile2.height, tile2.y_start, tile2.width, tile2.x_start));
            }
        }
        this.prevImgNode = this.imgNode;
        ShadowRealTupleType Domain2 = adaptedShadowType.getDomain();
        Unit[] domain_units = ((RealTupleType)Domain2.getType()).getDefaultUnits();
        float constant_alpha = Float.NaN;
        float[] constant_color = null;
        if (!Domain2.getAllSpatial() || Domain2.getMultipleDisplayScalar()) {
            throw new BadMappingException("domain must be only spatial");
        }
        ShadowRealType[] RangeComponents = adaptedShadowType.getRangeComponents();
        int rangesize = RangeComponents.length;
        if (rangesize != 1 && rangesize != 3) {
            throw new BadMappingException("image values must single or triple");
        }
        ScalarMap cmap = null;
        ScalarMap[] cmaps = null;
        int[] permute = new int[]{-1, -1, -1};
        boolean hasAlpha = false;
        if (rangesize == 1) {
            Vector mvector = RangeComponents[0].getSelectedMapVector();
            if (mvector.size() != 1) {
                throw new BadMappingException("image values must be mapped to RGB only");
            }
            cmap = (ScalarMap)mvector.elementAt(0);
            if (!Display.RGB.equals(cmap.getDisplayScalar())) {
                if (!Display.RGBA.equals(cmap.getDisplayScalar())) throw new BadMappingException("image values must be mapped to RGB or RGBA");
                hasAlpha = true;
            }
        } else {
            cmaps = new ScalarMap[3];
            for (int i = 0; i < 3; ++i) {
                Vector mvector = RangeComponents[i].getSelectedMapVector();
                if (mvector.size() != 1) {
                    throw new BadMappingException("image values must be mapped to color only");
                }
                cmaps[i] = (ScalarMap)mvector.elementAt(0);
                if (Display.Red.equals(cmaps[i].getDisplayScalar())) {
                    permute[0] = i;
                    continue;
                }
                if (Display.Green.equals(cmaps[i].getDisplayScalar())) {
                    permute[1] = i;
                    continue;
                }
                if (!Display.Blue.equals(cmaps[i].getDisplayScalar())) throw new BadMappingException("image values must be mapped to Red, Green or Blue only");
                permute[2] = i;
            }
            if (permute[0] < 0 || permute[1] < 0 || permute[2] < 0) {
                throw new BadMappingException("image values must be mapped to Red, Green and Blue");
            }
        }
        constant_alpha = default_values[display.getDisplayScalarIndex(Display.Alpha)];
        ImageRendererJ3D imgRenderer = (ImageRendererJ3D)renderer;
        int imageType = imgRenderer.getSuggestedBufImageType();
        if (imageType == 6) {
            color_length = 4;
            if (!hasAlpha) {
                color_length = 3;
                imageType = 5;
            }
        } else if (imageType == 5) {
            color_length = 3;
        } else if (imageType == 11) {
            color_length = 2;
        } else {
            if (imageType != 10) throw new VisADException("renderer returned unsupported image type");
            color_length = 1;
        }
        byte[][] color_bytes = null;
        byte[] byteData = null;
        BufferedImage image = null;
        Iterator iter3 = this.imgNode.getTileIterator();
        while (iter3.hasNext()) {
            VisADImageTile tile3 = (VisADImageTile)iter3.next();
            int tile_width = tile3.width;
            int tile_height = tile3.height;
            int xStart = tile3.xStart;
            int yStart = tile3.yStart;
            texture_width = this.textureWidth(tile_width);
            texture_height = this.textureHeight(tile_height);
            if (!this.reuseImages) {
                image = this.createImageByRef(texture_width, texture_height, imageType);
                tile3.setImage(0, image);
            } else {
                image = tile3.getImage(0);
            }
            WritableRaster raster = image.getRaster();
            DataBuffer db = raster.getDataBuffer();
            byteData = ((DataBufferByte)db).getData();
            ShadowImageByRefFunctionTypeJ3D.makeColorBytes(imgFlatField, cmap, cmaps, constant_alpha, RangeComponents, color_length, domain_length, permute, color_bytes, byteData, data_width, data_height, tile_width, tile_height, xStart, yStart, texture_width, texture_height);
        }
        boolean isTextureMap = adaptedShadowType.getIsTextureMap() && (domain_set instanceof Linear2DSet || domain_set instanceof LinearNDSet && domain_set.getDimension() == 2) && domain_set.getManifoldDimension() == 2;
        boolean curvedTexture = adaptedShadowType.getCurvedTexture() && !isTextureMap && curved_size > 0 && (domain_set instanceof Gridded2DSet || domain_set instanceof GriddedSet && domain_set.getDimension() == 2) && domain_set.getManifoldDimension() == 2;
        Object coordinates = null;
        Object texCoords = null;
        Object normals = null;
        Object colors = null;
        Object coordinatesX = null;
        Object texCoordsX = null;
        Object normalsX = null;
        Object colorsX = null;
        Object coordinatesY = null;
        Object texCoordsY = null;
        Object normalsY = null;
        Object colorsY = null;
        if (color_length == 4) {
            constant_alpha = Float.NaN;
        }
        if (isTextureMap) {
            if (this.imgNode.getNumTiles() == 1) {
                VisADImageTile tile4 = this.imgNode.getTile(0);
                this.buildLinearTexture(bgImages, domain_set, dataUnits, domain_units, default_values, DomainComponents, valueArrayLength, inherited_values, valueToScalar, mode, constant_alpha, value_array, constant_color, display, tile4);
            } else {
                BranchGroup branch = new BranchGroup();
                branch.setCapability(17);
                branch.setCapability(14);
                branch.setCapability(12);
                branch.setCapability(13);
                Iterator iter4 = this.imgNode.getTileIterator();
                while (iter4.hasNext()) {
                    tile = (VisADImageTile)iter4.next();
                    float[][] g00 = ((GriddedSet)domain_set).gridToValue(new float[][]{{tile.xStart}, {tile.yStart}});
                    float[][] g11 = ((GriddedSet)domain_set).gridToValue(new float[][]{{tile.xStart + tile.width - 1}, {tile.yStart + tile.height - 1}});
                    double x0 = g00[0][0];
                    double x1 = g11[0][0];
                    double y0 = g00[1][0];
                    double y1 = g11[1][0];
                    Linear2DSet dset = new Linear2DSet(x0, x1, tile.width, y0, y1, tile.height);
                    BranchGroup branch1 = new BranchGroup();
                    branch1.setCapability(17);
                    branch1.setCapability(14);
                    branch1.setCapability(12);
                    branch1.setCapability(13);
                    this.buildLinearTexture(branch1, dset, dataUnits, domain_units, default_values, DomainComponents, valueArrayLength, inherited_values, valueToScalar, mode, constant_alpha, value_array, constant_color, display, tile);
                    branch.addChild((Node)branch1);
                }
                if (bgImages.numChildren() > 0) {
                    bgImages.setChild((Node)branch, 0);
                } else {
                    bgImages.addChild((Node)branch);
                }
            }
        } else {
            int[] lens;
            if (!curvedTexture) throw new BadMappingException("must be texture map or curved texture map");
            int[] domain_lens = lens = ((GriddedSet)domain_set).getLengths();
            if (this.imgNode.getNumTiles() == 1) {
                tile = this.imgNode.getTile(0);
                this.buildCurvedTexture(bgImages, domain_set, dataUnits, domain_units, default_values, DomainComponents, valueArrayLength, inherited_values, valueToScalar, mode, constant_alpha, value_array, constant_color, display, curved_size, Domain2, dataCoordinateSystem, renderer, adaptedShadowType, new int[]{0, 0}, domain_lens[0], domain_lens[1], null, domain_lens[0], domain_lens[1], tile);
            } else {
                float[][] samples = ((GriddedSet)domain_set).getSamples(false);
                BranchGroup branch = new BranchGroup();
                branch.setCapability(17);
                branch.setCapability(14);
                branch.setCapability(12);
                branch.setCapability(13);
                iter = this.imgNode.getTileIterator();
                while (iter.hasNext()) {
                    VisADImageTile tile5 = (VisADImageTile)iter.next();
                    BranchGroup branch1 = new BranchGroup();
                    branch1.setCapability(17);
                    branch1.setCapability(14);
                    branch1.setCapability(12);
                    branch1.setCapability(13);
                    this.buildCurvedTexture(branch1, null, dataUnits, domain_units, default_values, DomainComponents, valueArrayLength, inherited_values, valueToScalar, mode, constant_alpha, value_array, constant_color, display, curved_size, Domain2, dataCoordinateSystem, renderer, adaptedShadowType, new int[]{tile5.xStart, tile5.yStart}, tile5.width, tile5.height, samples, domain_lens[0], domain_lens[1], tile5);
                    branch.addChild((Node)branch1);
                }
                if (bgImages.numChildren() > 0) {
                    bgImages.setChild((Node)branch, 0);
                } else {
                    bgImages.addChild((Node)branch);
                }
            }
        }
        if (group instanceof BranchGroup) {
            ((ImageRendererJ3D)renderer).setBranchEarly((BranchGroup)group);
        }
        for (int k = 1; k < numImages; ++k) {
            FlatField ff = (FlatField)((Field)data).getSample(k);
            GriddedSet domSet = (GriddedSet)ff.getDomainSet();
            int[] lens = domSet.getLengths();
            if (lens[0] != data_width || lens[1] != data_height) {
                ff = (FlatField)ff.resample(imgFlatField.getDomainSet(), 100, 202);
            }
            iter = this.imgNode.getTileIterator();
            while (iter.hasNext()) {
                VisADImageTile tile6 = (VisADImageTile)iter.next();
                int tile_width = tile6.width;
                int tile_height = tile6.height;
                int xStart = tile6.xStart;
                int yStart = tile6.yStart;
                texture_width = this.textureWidth(tile_width);
                texture_height = this.textureHeight(tile_height);
                if (!this.reuseImages) {
                    image = this.createImageByRef(texture_width, texture_height, imageType);
                    tile6.setImage(k, image);
                } else {
                    image = tile6.getImage(k);
                }
                WritableRaster raster = image.getRaster();
                DataBuffer db = raster.getDataBuffer();
                byteData = ((DataBufferByte)db).getData();
                ShadowImageByRefFunctionTypeJ3D.makeColorBytes(ff, cmap, cmaps, constant_alpha, RangeComponents, color_length, domain_length, permute, color_bytes, byteData, data_width, data_height, tile_width, tile_height, xStart, yStart, texture_width, texture_height);
            }
        }
        this.ensureNotEmpty(bgImages);
        return false;
    }

    public static void makeColorBytes(Data data, ScalarMap cmap, ScalarMap[] cmaps, float constant_alpha, ShadowRealType[] RangeComponents, int color_length, int domain_length, int[] permute, byte[][] color_bytes, byte[] byteData, int data_width, int data_height, int tile_width, int tile_height, int xStart, int yStart, int texture_width, int texture_height) throws VisADException, RemoteException {
        if (cmap != null) {
            BaseColorControl control = (BaseColorControl)cmap.getControl();
            float[][] table = control.getTable();
            byte[][] bytes = null;
            Set rset = null;
            boolean is_default_unit = false;
            if (data instanceof FlatField) {
                RealType rtype;
                Unit def_unit;
                bytes = ((FlatField)data).grabBytes();
                Set[] rsets = ((FlatField)data).getRangeSets();
                if (rsets != null) {
                    rset = rsets[0];
                }
                if ((def_unit = (rtype = (RealType)RangeComponents[0].getType()).getDefaultUnit()) == null) {
                    is_default_unit = true;
                } else {
                    Unit[][] data_units = ((FlatField)data).getRangeUnits();
                    Unit data_unit = data_units == null ? null : data_units[0][0];
                    is_default_unit = def_unit.equals(data_unit);
                }
            }
            if (table != null) {
                byte[][] itable = new byte[table[0].length][4];
                int c = (int)(255.0 * (double)(1.0f - constant_alpha));
                int a = c < 0 ? 0 : (c > 255 ? 255 : c);
                for (int j = 0; j < table[0].length; ++j) {
                    int b;
                    c = (int)(255.0 * (double)table[0][j]);
                    int r = c < 0 ? 0 : (c > 255 ? 255 : c);
                    c = (int)(255.0 * (double)table[1][j]);
                    int g = c < 0 ? 0 : (c > 255 ? 255 : c);
                    c = (int)(255.0 * (double)table[2][j]);
                    int n = c < 0 ? 0 : (b = c > 255 ? 255 : c);
                    if (color_length == 4) {
                        c = (int)(255.0 * (double)table[3][j]);
                        a = c < 0 ? 0 : (c > 255 ? 255 : c);
                    }
                    itable[j][0] = (byte)r;
                    itable[j][1] = (byte)g;
                    itable[j][2] = (byte)b;
                    itable[j][3] = (byte)a;
                }
                int tblEnd = table[0].length - 1;
                int table_scale = table[0].length;
                if (data instanceof ImageFlatField && bytes != null && is_default_unit) {
                    bytes[0] = cmap.scaleValues(bytes[0], table_scale);
                    byte[] bytes0 = bytes[0];
                    for (int y = 0; y < tile_height; ++y) {
                        for (int x = 0; x < tile_width; ++x) {
                            int ndx;
                            int i = x + xStart + (y + yStart) * data_width;
                            int k = x + y * texture_width;
                            k *= color_length;
                            int j = bytes0[i] & 0xFF;
                            int n = j < 0 ? 0 : (ndx = j > tblEnd ? tblEnd : j);
                            if (color_length == 4) {
                                byteData[k] = itable[ndx][3];
                                byteData[k + 1] = itable[ndx][2];
                                byteData[k + 2] = itable[ndx][1];
                                byteData[k + 3] = itable[ndx][0];
                            }
                            if (color_length == 3) {
                                byteData[k] = itable[ndx][2];
                                byteData[k + 1] = itable[ndx][1];
                                byteData[k + 2] = itable[ndx][0];
                            }
                            if (color_length != 1) continue;
                            byteData[k] = itable[ndx][0];
                        }
                    }
                } else if (bytes != null && bytes[0] != null && is_default_unit && rset != null && rset instanceof Linear1DSet) {
                    double first = ((Linear1DSet)rset).getFirst();
                    double step = ((Linear1DSet)rset).getStep();
                    double[] so = new double[2];
                    double[] da = new double[2];
                    double[] di = new double[2];
                    cmap.getScale(so, da, di);
                    double scale = so[0];
                    double offset = so[1];
                    float mult = (float)((double)table_scale * scale * step);
                    float add = (float)((double)table_scale * (offset + scale * first));
                    byte[][] fast_table = new byte[256][];
                    for (int j = 0; j < 256; ++j) {
                        int index = j - 1;
                        if (index < 0) continue;
                        int k = (int)(add + mult * (float)index);
                        int ndx = k < 0 ? 0 : (k > tblEnd ? tblEnd : k);
                        fast_table[j] = itable[ndx];
                    }
                    byte[] bytes0 = bytes[0];
                    for (int y = 0; y < tile_height; ++y) {
                        for (int x = 0; x < tile_width; ++x) {
                            int i = x + xStart + (y + yStart) * data_width;
                            int k = x + y * texture_width;
                            k *= color_length;
                            int ndx = bytes0[i] - -128;
                            if (color_length == 4) {
                                byteData[k] = fast_table[ndx][3];
                                byteData[k + 1] = fast_table[ndx][2];
                                byteData[k + 2] = fast_table[ndx][1];
                                byteData[k + 3] = fast_table[ndx][0];
                            }
                            if (color_length == 3) {
                                byteData[k] = fast_table[ndx][2];
                                byteData[k + 1] = fast_table[ndx][1];
                                byteData[k + 2] = fast_table[ndx][0];
                            }
                            if (color_length != 1) continue;
                            byteData[k] = fast_table[ndx][0];
                        }
                    }
                    bytes = null;
                } else {
                    bytes = null;
                    float[][] values = ((Field)data).getFloats(false);
                    values[0] = cmap.scaleValues(values[0]);
                    float[] values0 = values[0];
                    boolean m = false;
                    for (int y = 0; y < tile_height; ++y) {
                        for (int x = 0; x < tile_width; ++x) {
                            int ndx;
                            int i = x + xStart + (y + yStart) * data_width;
                            int k = x + y * texture_width;
                            k *= color_length;
                            if (Float.isNaN(values0[i])) continue;
                            int j = (int)((float)table_scale * values0[i]);
                            int n = j < 0 ? 0 : (ndx = j > tblEnd ? tblEnd : j);
                            if (color_length == 4) {
                                byteData[k] = itable[ndx][3];
                                byteData[k + 1] = itable[ndx][2];
                                byteData[k + 2] = itable[ndx][1];
                                byteData[k + 3] = itable[ndx][0];
                            }
                            if (color_length == 3) {
                                byteData[k] = itable[ndx][2];
                                byteData[k + 1] = itable[ndx][1];
                                byteData[k + 2] = itable[ndx][0];
                            }
                            if (color_length != 1) continue;
                            byteData[k] = itable[ndx][0];
                        }
                    }
                    values = null;
                }
            } else {
                bytes = null;
                float[][] values = ((Field)data).getFloats(false);
                values[0] = cmap.scaleValues(values[0]);
                float[][] color_values = control.lookupValues(values[0]);
                int c = (int)(255.0 * (double)(1.0f - constant_alpha));
                int a = c < 0 ? 0 : (c > 255 ? 255 : c);
                boolean m = false;
                for (int y = 0; y < tile_height; ++y) {
                    for (int x = 0; x < tile_width; ++x) {
                        int b;
                        int i = x + xStart + (y + yStart) * data_width;
                        int k = x + y * texture_width;
                        k *= color_length;
                        if (Float.isNaN(values[0][i])) continue;
                        c = (int)(255.0 * (double)color_values[0][i]);
                        int r = c < 0 ? 0 : (c > 255 ? 255 : c);
                        c = (int)(255.0 * (double)color_values[1][i]);
                        int g = c < 0 ? 0 : (c > 255 ? 255 : c);
                        c = (int)(255.0 * (double)color_values[2][i]);
                        int n = c < 0 ? 0 : (b = c > 255 ? 255 : c);
                        if (color_length == 4) {
                            c = (int)(255.0 * (double)color_values[3][i]);
                            int n2 = c < 0 ? 0 : (a = c > 255 ? 255 : c);
                        }
                        if (color_length == 4) {
                            byteData[k] = (byte)a;
                            byteData[k + 1] = (byte)b;
                            byteData[k + 2] = (byte)g;
                            byteData[k + 3] = (byte)r;
                        }
                        if (color_length == 3) {
                            byteData[k] = (byte)b;
                            byteData[k + 1] = (byte)g;
                            byteData[k + 2] = (byte)r;
                        }
                        if (color_length != 1) continue;
                        byteData[k] = (byte)b;
                    }
                }
                values = null;
                color_values = null;
            }
        } else if (cmaps != null) {
            byte[][] bytes = null;
            if (data instanceof ImageFlatField) {
                bytes = ((ImageFlatField)data).grabBytes();
            }
            if (bytes != null) {
                color_bytes = new byte[4][];
                color_bytes[0] = cmaps[permute[0]].scaleValues(bytes[permute[0]], 255);
                color_bytes[1] = cmaps[permute[1]].scaleValues(bytes[permute[1]], 255);
                color_bytes[2] = cmaps[permute[2]].scaleValues(bytes[permute[2]], 255);
                int c = (int)(255.0 * (double)(1.0f - constant_alpha));
                color_bytes[3] = new byte[domain_length];
                Arrays.fill(color_bytes[3], (byte)c);
            } else {
                Object values = ((Field)data).getFloats(false);
                float[][] new_values = new float[][]{cmaps[permute[0]].scaleValues(values[permute[0]]), cmaps[permute[1]].scaleValues(values[permute[1]]), cmaps[permute[2]].scaleValues(values[permute[2]])};
                values = new_values;
                int c = (int)(255.0 * (double)(1.0f - constant_alpha));
                int a = c < 0 ? 0 : (c > 255 ? 255 : c);
                boolean m = false;
                for (int y = 0; y < tile_height; ++y) {
                    for (int x = 0; x < tile_width; ++x) {
                        int b;
                        int i = x + xStart + (y + yStart) * data_width;
                        int k = x + y * texture_width;
                        k *= color_length;
                        if (Float.isNaN(values[0][i]) || Float.isNaN(values[1][i]) || Float.isNaN(values[2][i])) continue;
                        c = (int)(255.0 * (double)values[0][i]);
                        int r = c < 0 ? 0 : (c > 255 ? 255 : c);
                        c = (int)(255.0 * (double)values[1][i]);
                        int g = c < 0 ? 0 : (c > 255 ? 255 : c);
                        c = (int)(255.0 * (double)values[2][i]);
                        int n = c < 0 ? 0 : (b = c > 255 ? 255 : c);
                        if (color_length == 4) {
                            byteData[k] = (byte)a;
                            byteData[k + 1] = (byte)b;
                            byteData[k + 2] = (byte)g;
                            byteData[k + 3] = (byte)r;
                        }
                        if (color_length == 3) {
                            byteData[k] = (byte)b;
                            byteData[k + 1] = (byte)g;
                            byteData[k + 2] = (byte)r;
                        }
                        if (color_length != 1) continue;
                        byteData[k] = (byte)b;
                    }
                }
                values = null;
            }
        } else {
            throw new BadMappingException("cmap == null and cmaps == null ??");
        }
    }

    public static boolean spatialLinear(float[][] spatial_values, int lenx, int leny) {
        float del_x = Float.NaN;
        float del_y = Float.NaN;
        float area = Float.NaN;
        for (int j = 2; j < leny - 2; ++j) {
            for (int i = 2; i < lenx - 2; ++i) {
                float doty;
                float dy_c;
                float len_c;
                float dx_c;
                int k = i + j * lenx;
                float xa = spatial_values[0][k];
                float ya = spatial_values[1][k];
                float za = spatial_values[2][k];
                float xb = spatial_values[0][k + 1];
                float yb = spatial_values[1][k + 1];
                float zb = spatial_values[2][k + 1];
                float xc = spatial_values[0][k + lenx];
                float yc = spatial_values[1][k + lenx];
                float zc = spatial_values[2][k + lenx];
                float xd = spatial_values[0][k + lenx + 1];
                float yd = spatial_values[1][k + lenx + 1];
                float zd = spatial_values[2][k + lenx + 1];
                if (Float.isNaN(xa) || Float.isNaN(ya) || Float.isNaN(za) || Float.isNaN(xb) || Float.isNaN(yb) || Float.isNaN(zb) || Float.isNaN(xc) || Float.isNaN(yc) || Float.isNaN(zc) || Float.isNaN(xd) || Float.isNaN(yd) || Float.isNaN(zd)) continue;
                float dx = xb - xa;
                float dy = yb - ya;
                float len = (float)Math.sqrt(dx * dx + dy * dy);
                float dotx = dx / len * ((dx_c = xc - xa) / (len_c = (float)Math.sqrt(dx_c * dx_c + (dy_c = yc - ya) * dy_c)));
                float dot_mag = (float)Math.sqrt(dotx * dotx + (doty = dy / len * (dy_c / len_c)) * doty);
                if (!Util.isApproximatelyEqual((double)dot_mag, 0.0, 0.05)) {
                    System.out.println("(" + j + "," + i + "), " + dot_mag);
                    return false;
                }
                if (!Util.isApproximatelyEqual((double)dx, 0.0, 0.005) && !Util.isApproximatelyEqual((double)dy, 0.0, 0.005)) {
                    System.out.println("not aligned: (" + j + "," + i + "), " + dx + "," + dy);
                    return false;
                }
                float ar = dx * dy_c - dy * dx_c;
                if (Float.isNaN(area)) {
                    area = ar;
                    continue;
                }
                if (!Util.isApproximatelyEqual((double)area, (double)ar, 0.005)) {
                    System.out.println("(" + j + "," + i + "), area: " + area);
                    return false;
                }
                area = ar;
            }
        }
        return true;
    }

    public void buildCurvedTexture(Object group, Set domain_set, Unit[] dataUnits, Unit[] domain_units, float[] default_values, ShadowRealType[] DomainComponents, int valueArrayLength, int[] inherited_values, int[] valueToScalar, GraphicsModeControl mode, float constant_alpha, float[] value_array, float[] constant_color, DisplayImpl display, int curved_size, ShadowRealTupleType Domain2, CoordinateSystem dataCoordinateSystem, DataRenderer renderer, ShadowFunctionOrSetType adaptedShadowType, int[] start, int lenX, int lenY, float[][] samples, int bigX, int bigY, VisADImageTile tile) throws VisADException, DisplayException {
        int len;
        int i;
        int i2;
        RealTupleType ref;
        float[] coordinates = null;
        float[] texCoords = null;
        float[] normals = null;
        int data_width = 0;
        int data_height = 0;
        int texture_width = 1;
        int texture_height = 1;
        int[] lengths = null;
        lengths = domain_set != null ? ((GriddedSet)domain_set).getLengths() : new int[]{lenX, lenY};
        data_width = lengths[0];
        data_height = lengths[1];
        texture_width = this.textureWidth(data_width);
        texture_height = this.textureHeight(data_height);
        int size = (data_width + data_height) / 2;
        curved_size = Math.max(2, Math.min(curved_size, size / 32));
        int nwidth = 2 + (data_width - 1) / curved_size;
        int nheight = 2 + (data_height - 1) / curved_size;
        int nn = nwidth * nheight;
        int[] is = new int[nwidth];
        int[] js = new int[nheight];
        for (int i3 = 0; i3 < nwidth; ++i3) {
            is[i3] = Math.min(i3 * curved_size, data_width - 1);
        }
        for (int j = 0; j < nheight; ++j) {
            js[j] = Math.min(j * curved_size, data_height - 1);
        }
        int[] indices = new int[nn];
        int k = 0;
        for (int j = 0; j < nheight; ++j) {
            for (int i4 = 0; i4 < nwidth; ++i4) {
                indices[k] = is[i4] + data_width * js[j];
                ++k;
            }
        }
        float[][] spline_domain = null;
        if (domain_set == null) {
            int kk;
            for (kk = 0; kk < indices.length; ++kk) {
                int x = indices[kk] % lenX;
                int y = indices[kk] / lenX;
                indices[kk] = start[0] + x + (start[1] + y) * bigX;
            }
            spline_domain = new float[2][indices.length];
            for (kk = 0; kk < indices.length; ++kk) {
                spline_domain[0][kk] = samples[0][indices[kk]];
                spline_domain[1][kk] = samples[1][indices[kk]];
            }
        } else {
            spline_domain = domain_set.indexToValue(indices);
        }
        spline_domain = Unit.convertTuple(spline_domain, dataUnits, domain_units, false);
        ShadowRealTupleType domain_reference = Domain2.getReference();
        ShadowRealType[] DC = DomainComponents;
        if (domain_reference != null && domain_reference.getMappedDisplayScalar()) {
            ref = (RealTupleType)domain_reference.getType();
            renderer.setEarthSpatialData(Domain2, domain_reference, ref, ref.getDefaultUnits(), (RealTupleType)Domain2.getType(), new CoordinateSystem[]{dataCoordinateSystem}, domain_units);
            spline_domain = CoordinateSystem.transformCoordinates(ref, null, ref.getDefaultUnits(), null, (RealTupleType)Domain2.getType(), dataCoordinateSystem, domain_units, null, spline_domain);
            DC = adaptedShadowType.getDomainReferenceComponents();
        } else {
            ref = domain_reference == null ? null : (RealTupleType)domain_reference.getType();
            Unit[] ref_units = ref == null ? null : ref.getDefaultUnits();
            renderer.setEarthSpatialData(Domain2, domain_reference, ref, ref_units, (RealTupleType)Domain2.getType(), new CoordinateSystem[]{dataCoordinateSystem}, domain_units);
        }
        int[] tuple_index = new int[3];
        int[] spatial_value_indices = new int[]{-1, -1, -1};
        ScalarMap[] spatial_maps = new ScalarMap[3];
        DisplayTupleType spatial_tuple = null;
        for (int i5 = 0; i5 < DC.length; ++i5) {
            Enumeration maps = DC[i5].getSelectedMapVector().elements();
            ScalarMap map = (ScalarMap)maps.nextElement();
            DisplayRealType real = map.getDisplayScalar();
            spatial_tuple = real.getTuple();
            if (spatial_tuple == null) {
                throw new DisplayException("texture with bad tuple: ShadowImageFunctionTypeJ3D.doTransform");
            }
            tuple_index[i5] = real.getTupleIndex();
            spatial_value_indices[tuple_index[i5]] = map.getValueIndex();
            spatial_maps[tuple_index[i5]] = map;
            if (!maps.hasMoreElements()) continue;
            throw new DisplayException("texture with multiple spatial: ShadowImageFunctionTypeJ3D.doTransform");
        }
        tuple_index[2] = 3 - (tuple_index[0] + tuple_index[1]);
        DisplayRealType real = (DisplayRealType)spatial_tuple.getComponent(tuple_index[2]);
        int value2_index = display.getDisplayScalarIndex(real);
        float value2 = default_values[value2_index];
        for (int i6 = 0; i6 < valueArrayLength; ++i6) {
            if (inherited_values[i6] <= 0 || !real.equals(display.getDisplayScalar(valueToScalar[i6]))) continue;
            value2 = value_array[i6];
            break;
        }
        Object spatial_values = new float[3][];
        spatial_values[tuple_index[0]] = spline_domain[0];
        spatial_values[tuple_index[1]] = spline_domain[1];
        spatial_values[tuple_index[2]] = new float[nn];
        for (i2 = 0; i2 < nn; ++i2) {
            spatial_values[tuple_index[2]][i2] = value2;
        }
        for (i2 = 0; i2 < 3; ++i2) {
            if (spatial_maps[i2] == null) continue;
            spatial_values[i2] = spatial_maps[i2].scaleValues(spatial_values[i2], false);
        }
        if (spatial_tuple.equals(Display.DisplaySpatialCartesianTuple)) {
            renderer.setEarthSpatialDisplay(null, spatial_tuple, display, spatial_value_indices, default_values, null);
        } else {
            CoordinateSystem coord = spatial_tuple.getCoordinateSystem();
            spatial_values = coord.toReference((float[][])spatial_values);
            renderer.setEarthSpatialDisplay(coord, spatial_tuple, display, spatial_value_indices, default_values, null);
        }
        coordinates = new float[3 * nn];
        k = 0;
        for (int i7 = 0; i7 < nn; ++i7) {
            coordinates[k++] = spatial_values[0][i7];
            coordinates[k++] = spatial_values[1][i7];
            coordinates[k++] = spatial_values[2][i7];
        }
        boolean spatial_all_select = true;
        for (int i8 = 0; i8 < 3 * nn; ++i8) {
            if (coordinates[i8] == coordinates[i8]) continue;
            spatial_all_select = false;
        }
        normals = Gridded3DSet.makeNormals(coordinates, nwidth, nheight);
        float ratiow = (float)data_width / (float)texture_width;
        float ratioh = (float)data_height / (float)texture_height;
        float half_width = 0.5f / (float)texture_width;
        float half_height = 0.5f / (float)texture_height;
        float width = 1.0f / (float)texture_width;
        float height = 1.0f / (float)texture_height;
        int mt = 0;
        texCoords = new float[2 * nn];
        for (int j = 0; j < nheight; ++j) {
            for (i = 0; i < nwidth; ++i) {
                float isfactor = (float)is[i] / ((float)data_width - 1.0f);
                float jsfactor = (float)js[j] / ((float)data_height - 1.0f);
                texCoords[mt++] = (ratiow - width) * isfactor + half_width;
                boolean yUp = true;
                texCoords[mt++] = yUp ? (ratioh - height) * jsfactor + half_height : 1.0f - (ratioh - height) * jsfactor - half_height;
            }
        }
        VisADTriangleStripArray tarray = new VisADTriangleStripArray();
        tarray.stripVertexCounts = new int[nheight - 1];
        for (i = 0; i < nheight - 1; ++i) {
            tarray.stripVertexCounts[i] = 2 * nwidth;
        }
        tarray.vertexCount = len = (nheight - 1) * (2 * nwidth);
        tarray.normals = new float[3 * len];
        tarray.coordinates = new float[3 * len];
        tarray.texCoords = new float[2 * len];
        k = 0;
        int kt = 0;
        int nwidth3 = 3 * nwidth;
        int nwidth2 = 2 * nwidth;
        for (int i9 = 0; i9 < nheight - 1; ++i9) {
            int m = i9 * nwidth3;
            mt = i9 * nwidth2;
            for (int j = 0; j < nwidth; ++j) {
                tarray.coordinates[k] = coordinates[m];
                tarray.coordinates[k + 1] = coordinates[m + 1];
                tarray.coordinates[k + 2] = coordinates[m + 2];
                tarray.coordinates[k + 3] = coordinates[m + nwidth3];
                tarray.coordinates[k + 4] = coordinates[m + nwidth3 + 1];
                tarray.coordinates[k + 5] = coordinates[m + nwidth3 + 2];
                tarray.normals[k] = normals[m];
                tarray.normals[k + 1] = normals[m + 1];
                tarray.normals[k + 2] = normals[m + 2];
                tarray.normals[k + 3] = normals[m + nwidth3];
                tarray.normals[k + 4] = normals[m + nwidth3 + 1];
                tarray.normals[k + 5] = normals[m + nwidth3 + 2];
                tarray.texCoords[kt] = texCoords[mt];
                tarray.texCoords[kt + 1] = texCoords[mt + 1];
                tarray.texCoords[kt + 2] = texCoords[mt + nwidth2];
                tarray.texCoords[kt + 3] = texCoords[mt + nwidth2 + 1];
                k += 6;
                m += 3;
                kt += 4;
                mt += 2;
            }
        }
        if (!spatial_all_select) {
            tarray = (VisADTriangleStripArray)tarray.removeMissing();
        }
        if (adaptedShadowType.getAdjustProjectionSeam()) {
            tarray = (VisADTriangleStripArray)tarray.adjustLongitude(renderer);
            tarray = (VisADTriangleStripArray)tarray.adjustSeam(renderer);
        }
        if (!this.reuse) {
            BufferedImage image = tile.getImage(0);
            this.textureToGroup(group, tarray, image, mode, constant_alpha, constant_color, texture_width, texture_height, true, true, tile);
        } else if (this.animControl == null) {
            this.imgNode.setCurrent(0);
        }
    }

    public void buildLinearTexture(Object group, Set domain_set, Unit[] dataUnits, Unit[] domain_units, float[] default_values, ShadowRealType[] DomainComponents, int valueArrayLength, int[] inherited_values, int[] valueToScalar, GraphicsModeControl mode, float constant_alpha, float[] value_array, float[] constant_color, DisplayImpl display, VisADImageTile tile) throws VisADException, DisplayException {
        float[] coordinates = null;
        float[] texCoords = null;
        float[] normals = null;
        byte[] colors = null;
        int data_width = 0;
        int data_height = 0;
        int texture_width = 1;
        int texture_height = 1;
        Linear1DSet X = null;
        Linear1DSet Y = null;
        if (domain_set instanceof Linear2DSet) {
            X = ((Linear2DSet)domain_set).getX();
            Y = ((Linear2DSet)domain_set).getY();
        } else {
            X = ((LinearNDSet)domain_set).getLinear1DComponent(0);
            Y = ((LinearNDSet)domain_set).getLinear1DComponent(1);
        }
        float[][] limits = new float[2][2];
        limits[0][0] = (float)X.getFirst();
        limits[0][1] = (float)X.getLast();
        limits[1][0] = (float)Y.getFirst();
        limits[1][1] = (float)Y.getLast();
        data_width = X.getLength();
        data_height = Y.getLength();
        texture_width = this.textureWidth(data_width);
        texture_height = this.textureHeight(data_height);
        float half_width = 0.5f / (float)(data_width - 1);
        float half_height = 0.5f / (float)(data_height - 1);
        half_width = (limits[0][1] - limits[0][0]) * half_width;
        half_height = (limits[1][1] - limits[1][0]) * half_height;
        float[] fArray = limits[0];
        fArray[0] = fArray[0] - half_width;
        float[] fArray2 = limits[0];
        fArray2[1] = fArray2[1] + half_width;
        float[] fArray3 = limits[1];
        fArray3[0] = fArray3[0] - half_height;
        float[] fArray4 = limits[1];
        fArray4[1] = fArray4[1] + half_height;
        limits = Unit.convertTuple(limits, dataUnits, domain_units);
        int[] tuple_index = new int[3];
        if (DomainComponents.length != 2) {
            throw new DisplayException("texture domain dimension != 2:ShadowFunctionOrSetType.doTransform");
        }
        for (int i = 0; i < DomainComponents.length; ++i) {
            Enumeration maps = DomainComponents[i].getSelectedMapVector().elements();
            ScalarMap map = (ScalarMap)maps.nextElement();
            limits[i] = map.scaleValues(limits[i]);
            DisplayRealType real = map.getDisplayScalar();
            DisplayTupleType tuple = real.getTuple();
            if (tuple == null || !tuple.equals(Display.DisplaySpatialCartesianTuple)) {
                throw new DisplayException("texture with bad tuple: ShadowFunctionOrSetType.doTransform");
            }
            tuple_index[i] = real.getTupleIndex();
            if (!maps.hasMoreElements()) continue;
            throw new DisplayException("texture with multiple spatial: ShadowFunctionOrSetType.doTransform");
        }
        tuple_index[2] = 3 - (tuple_index[0] + tuple_index[1]);
        DisplayRealType real = (DisplayRealType)Display.DisplaySpatialCartesianTuple.getComponent(tuple_index[2]);
        int value2_index = display.getDisplayScalarIndex(real);
        float value2 = default_values[value2_index];
        for (int i = 0; i < valueArrayLength; ++i) {
            if (inherited_values[i] <= 0 || !real.equals(display.getDisplayScalar(valueToScalar[i]))) continue;
            value2 = value_array[i];
            break;
        }
        coordinates = new float[12];
        coordinates[tuple_index[0]] = limits[0][0];
        coordinates[tuple_index[1]] = limits[1][0];
        coordinates[tuple_index[2]] = value2;
        coordinates[3 + tuple_index[0]] = limits[0][1];
        coordinates[3 + tuple_index[1]] = limits[1][0];
        coordinates[3 + tuple_index[2]] = value2;
        coordinates[6 + tuple_index[0]] = limits[0][1];
        coordinates[6 + tuple_index[1]] = limits[1][1];
        coordinates[6 + tuple_index[2]] = value2;
        coordinates[9 + tuple_index[0]] = limits[0][0];
        coordinates[9 + tuple_index[1]] = limits[1][1];
        coordinates[9 + tuple_index[2]] = value2;
        this.adjustZ(coordinates);
        texCoords = new float[8];
        float ratiow = (float)data_width / (float)texture_width;
        float ratioh = (float)data_height / (float)texture_height;
        boolean yUp = true;
        this.setTexCoords(texCoords, ratiow, ratioh, yUp);
        normals = new float[12];
        float n0 = (coordinates[5] - coordinates[2]) * (coordinates[7] - coordinates[1]) - (coordinates[4] - coordinates[1]) * (coordinates[8] - coordinates[2]);
        float n1 = (coordinates[3] - coordinates[0]) * (coordinates[8] - coordinates[2]) - (coordinates[5] - coordinates[2]) * (coordinates[6] - coordinates[0]);
        float n2 = (coordinates[4] - coordinates[1]) * (coordinates[6] - coordinates[0]) - (coordinates[3] - coordinates[0]) * (coordinates[7] - coordinates[1]);
        float nlen = (float)Math.sqrt(n0 * n0 + n1 * n1 + n2 * n2);
        normals[0] = n0 /= nlen;
        normals[1] = n1 /= nlen;
        normals[2] = n2 /= nlen;
        normals[3] = n0;
        normals[4] = n1;
        normals[5] = n2;
        normals[6] = n0;
        normals[7] = n1;
        normals[8] = n2;
        normals[9] = n0;
        normals[10] = n1;
        normals[11] = n2;
        colors = new byte[12];
        for (int i = 0; i < 12; ++i) {
            colors[i] = 127;
        }
        VisADQuadArray qarray = new VisADQuadArray();
        qarray.vertexCount = 4;
        qarray.coordinates = coordinates;
        qarray.texCoords = texCoords;
        qarray.colors = colors;
        qarray.normals = normals;
        if (!this.reuse) {
            BufferedImage image = tile.getImage(0);
            this.textureToGroup(group, qarray, image, mode, constant_alpha, constant_color, texture_width, texture_height, true, true, tile);
        } else if (this.animControl == null) {
            this.imgNode.setCurrent(0);
        }
    }

    public BufferedImage createImageByRef(int texture_width, int texture_height, int imageType) {
        return new BufferedImage(texture_width, texture_height, imageType);
    }
}

