/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.StringTokenizer;
import visad.Control;
import visad.DisplayImpl;
import visad.VisADException;
import visad.browser.Convert;

public abstract class GraphicsModeControl
extends Control
implements Cloneable {
    public static final int SOLID_STYLE = 0;
    public static final int DASH_STYLE = 1;
    public static final int DOT_STYLE = 2;
    public static final int DASH_DOT_STYLE = 3;
    public static final int AVERAGE_COLOR_MODE = 0;
    public static final int SUM_COLOR_MODE = 1;
    public static final int STACK2D = 0;
    public static final int TEXTURE3D = 1;

    public GraphicsModeControl(DisplayImpl d) {
        super(d);
    }

    public abstract boolean getMode2D();

    public abstract float getLineWidth();

    public abstract void setLineWidth(float var1) throws VisADException, RemoteException;

    public abstract void setLineWidth(float var1, boolean var2);

    public abstract float getPointSize();

    public abstract void setPointSize(float var1) throws VisADException, RemoteException;

    public abstract void setPointSize(float var1, boolean var2);

    public abstract int getLineStyle();

    public abstract void setLineStyle(int var1) throws VisADException, RemoteException;

    public abstract void setLineStyle(int var1, boolean var2);

    public abstract int getColorMode();

    public abstract void setColorMode(int var1) throws VisADException, RemoteException;

    public abstract boolean getPointMode();

    public abstract void setPointMode(boolean var1) throws VisADException, RemoteException;

    public abstract boolean getTextureEnable();

    public abstract void setTextureEnable(boolean var1) throws VisADException, RemoteException;

    public abstract boolean getScaleEnable();

    public abstract void setScaleEnable(boolean var1) throws VisADException, RemoteException;

    public abstract int getTransparencyMode();

    public abstract void setTransparencyMode(int var1) throws VisADException, RemoteException;

    public abstract void setProjectionPolicy(int var1) throws VisADException, RemoteException;

    public abstract int getProjectionPolicy();

    public abstract void setPolygonMode(int var1) throws VisADException, RemoteException;

    public abstract void setPolygonMode(int var1, boolean var2) throws VisADException, RemoteException;

    public abstract int getPolygonMode();

    public abstract void setPolygonOffset(float var1) throws VisADException, RemoteException;

    public abstract void setPolygonOffset(float var1, boolean var2);

    public abstract float getPolygonOffset();

    public abstract void setPolygonOffsetFactor(float var1) throws VisADException, RemoteException;

    public abstract void setPolygonOffsetFactor(float var1, boolean var2);

    public abstract float getPolygonOffsetFactor();

    public abstract void setMissingTransparent(boolean var1) throws VisADException, RemoteException;

    public abstract boolean getMissingTransparent();

    public abstract void setAdjustProjectionSeam(boolean var1) throws VisADException, RemoteException;

    public abstract boolean getAdjustProjectionSeam();

    public abstract void setTexture3DMode(int var1) throws VisADException, RemoteException;

    public abstract int getTexture3DMode();

    public abstract void setCurvedSize(int var1);

    public abstract int getCurvedSize();

    public abstract void setCacheAppearances(boolean var1);

    public abstract boolean getCacheAppearances();

    public abstract void setMergeGeometries(boolean var1);

    public abstract boolean getMergeGeometries();

    public String getSaveString() {
        return "" + this.getLineWidth() + " " + this.getPointSize() + " " + this.getPointMode() + " " + this.getTextureEnable() + " " + this.getScaleEnable() + " " + this.getTransparencyMode() + " " + this.getProjectionPolicy() + " " + this.getPolygonMode() + " " + this.getMissingTransparent() + " " + this.getCurvedSize() + " " + this.getLineStyle() + " " + this.getColorMode() + " " + this.getPolygonOffset() + " " + this.getPolygonOffsetFactor() + " " + this.getAdjustProjectionSeam() + " " + this.getCacheAppearances() + " " + this.getMergeGeometries();
    }

    public void setSaveString(String save) throws VisADException, RemoteException {
        if (save == null) {
            throw new VisADException("Invalid save string");
        }
        StringTokenizer st = new StringTokenizer(save);
        int numTokens = st.countTokens();
        if (numTokens < 10) {
            throw new VisADException("Invalid save string");
        }
        float lw = Convert.getFloat(st.nextToken());
        float ps = Convert.getFloat(st.nextToken());
        boolean pm = Convert.getBoolean(st.nextToken());
        boolean te = Convert.getBoolean(st.nextToken());
        boolean se = Convert.getBoolean(st.nextToken());
        int tm = Convert.getInt(st.nextToken());
        int pp = Convert.getInt(st.nextToken());
        int pm2 = Convert.getInt(st.nextToken());
        boolean mt = Convert.getBoolean(st.nextToken());
        int cs = Convert.getInt(st.nextToken());
        int ls = st.hasMoreTokens() ? Convert.getInt(st.nextToken()) : 0;
        int cm = st.hasMoreTokens() ? Convert.getInt(st.nextToken()) : 0;
        float po = st.hasMoreTokens() ? Convert.getFloat(st.nextToken()) : Float.NaN;
        float pof = st.hasMoreTokens() ? Convert.getFloat(st.nextToken()) : 0.0f;
        boolean as = st.hasMoreTokens() ? Convert.getBoolean(st.nextToken()) : this.getAdjustProjectionSeam();
        int t3dm = st.hasMoreTokens() ? Convert.getInt(st.nextToken()) : 0;
        boolean ca = st.hasMoreTokens() ? Convert.getBoolean(st.nextToken()) : this.getCacheAppearances();
        boolean mg = st.hasMoreTokens() ? Convert.getBoolean(st.nextToken()) : this.getMergeGeometries();
        this.setLineWidth(lw);
        this.setPointSize(ps);
        this.setLineStyle(ls);
        this.setPointMode(pm);
        this.setTextureEnable(te);
        this.setScaleEnable(se);
        this.setTransparencyMode(tm);
        this.setProjectionPolicy(pp);
        this.setPolygonMode(pm2);
        this.setMissingTransparent(mt);
        this.setCurvedSize(cs);
        this.setColorMode(cm);
        this.setPolygonOffset(po);
        this.setPolygonOffsetFactor(pof);
        this.setAdjustProjectionSeam(as);
        this.setTexture3DMode(t3dm);
        this.setCacheAppearances(ca);
        this.setMergeGeometries(mg);
    }

    public abstract Object clone();
}

