/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.thredds.server;

import java.awt.Color;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.NCdump;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ui.StopButton;
import ucar.nc2.util.IO;

public class TestConcurrentAccess {
    private StopButton stopButton;
    private JLabel label;
    public static JPanel main;

    TestConcurrentAccess(String name) throws IOException {
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createLineBorder(Color.black));
        p.add(new JLabel(name + ":"));
        this.label = new JLabel();
        p.add(this.label);
        this.stopButton = new StopButton("stop");
        p.add(this.stopButton);
        main.add(p);
    }

    public static void main(String[] args) throws IOException {
        int i;
        String dodsName = "http://localhost:8080/thredds/dodsC/fmrc/NAM-CONUS-12/Formica-NAM-CONUS-12_best.ncd";
        String catName = "http://motherlode:8080/thredds/catalog/fmrc/NCEP/RUC2/CONUS_20km/surface/catalog.html";
        JFrame frame = new JFrame("TestTDS");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        main = new JPanel();
        main.setLayout(new BoxLayout(main, 1));
        int n = 10;
        Thread[] task = new Thread[n];
        for (i = 0; i < n; ++i) {
            new TestConcurrentAccess(catName);
            task[i] = new Thread(new ReadCatalog(catName, i));
        }
        frame.getContentPane().add(main);
        frame.pack();
        frame.setLocation(40, 300);
        frame.setVisible(true);
        for (i = 0; i < n; ++i) {
            task[i].start();
        }
    }

    private static class ReadCatalog
    implements Runnable {
        private String name;
        private int who;

        ReadCatalog(String name, int who) {
            this.name = name;
            this.who = who;
        }

        public void run() {
            System.out.println(this.who + " readCat " + this.name);
            String content = IO.readURLcontents(this.name);
            System.out.println(this.who + " readCat done " + content.length());
        }
    }

    private static class FetchOpendapDataset
    implements Runnable {
        private String name;
        private int who;

        FetchOpendapDataset(String name, int who) {
            this.name = name;
            this.who = who;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            NetcdfDataset ncd = null;
            try {
                ncd = NetcdfDataset.openDataset(this.name);
                System.out.println(this.who + " Open " + this.name);
                List<Variable> vars = ncd.getVariables();
                for (int i = 0; i < vars.size(); ++i) {
                    Variable v = vars.get(i);
                    System.out.println(" " + this.who + " " + v.getName());
                    this.read(v);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
            }
            finally {
                if (ncd != null) {
                    try {
                        ncd.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        private void read(Variable v) throws IOException, InvalidRangeException {
            int[] shape = v.getShape();
            int[] origin = v.getShape();
            for (int i = 0; i < shape.length; ++i) {
                origin[i] = shape[i] / 2;
                shape[i] = 1;
            }
            Array data = v.read(origin, shape);
            NCdump.printArray(data, this.who + " " + v.getName(), System.out, null);
        }
    }
}

