/*
 * Decompiled with CFR 0.152.
 */
package org.bounce;

public class FormConstraints {
    public static final int LEFT = 0;
    public static final int BOTTOM = 1;
    public static final int RIGHT = 2;
    public static final int TOP = 3;
    public static final int CENTER = 4;
    public static final int FULL = 5;
    private int position;
    private int horizontalAlignment;
    private int verticalAlignment;
    private boolean filled;

    public FormConstraints() {
        this(5, 0, 4);
    }

    public FormConstraints(int position) {
        this(position, 0, 4);
    }

    public FormConstraints(int position, boolean filled) {
        this(position, 0, 4);
        this.filled = filled;
    }

    public FormConstraints(int position, int horizontalAlignment) {
        this(position, horizontalAlignment, 4);
    }

    public FormConstraints(int position, int horizontalAlignment, int verticalAlignment) {
        this.position = position;
        this.horizontalAlignment = horizontalAlignment;
        this.verticalAlignment = verticalAlignment;
        this.filled = false;
    }

    public FormConstraints(FormConstraints constraint) {
        this.horizontalAlignment = constraint.getHorizontalAlignment();
        this.verticalAlignment = constraint.getVerticalAlignment();
        this.filled = constraint.isFilled();
        this.position = constraint.getPosition();
    }

    public void setFilled(boolean enabled) {
        this.filled = enabled;
    }

    public boolean isFilled() {
        return this.filled;
    }

    public void setHorizontalAlignment(int alignment) {
        this.horizontalAlignment = alignment;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setVerticalAlignment(int alignment) {
        this.verticalAlignment = alignment;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean equals(Object object) {
        boolean equal = true;
        if (this != object) {
            if (object instanceof FormConstraints) {
                FormConstraints constraint = (FormConstraints)object;
                if (constraint.isFilled() != this.filled) {
                    equal = false;
                } else if (constraint.getPosition() != this.position) {
                    equal = false;
                } else if (constraint.getHorizontalAlignment() != this.horizontalAlignment) {
                    equal = false;
                } else if (constraint.getVerticalAlignment() != this.verticalAlignment) {
                    equal = false;
                }
            } else {
                equal = false;
            }
        }
        return equal;
    }
}

