#-*- coding:utf-8 -*-

#  Copyright © 2009-2011  B. Clausius <barcc@gmx.de>
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.


# Ported from GNUbik
# Original filename: rand.scm
# Original copyright and license: 2004 Dale Mellor, GPL3+


import pybikplugin as plugin

# Procedure which generates a list of lists of three random items, and sends it
# to gnubik-rotate-animated. The three random components are the face number
# (0, 1 or 2), the slice number (-(size-1), ..., size-3, size-1), and the
# direction to turn the slice (0 or 1).
def randomize(num):
    size = plugin.cube_state().dimension
    moves = [(plugin.random(3), plugin.random(size), plugin.random(2)) for i in xrange(num)]
    plugin.rotate_animated(moves)


N_ = lambda t: t

def items(s):
    return N_('Randomize'), s

for path, func in [
            (items(N_('1 Move')),  lambda: randomize(1)),
            (items(N_('2 Moves')), lambda: randomize(2)),
            (items(N_('3 Moves')), lambda: randomize(3)),
            (items(N_('4 Moves')), lambda: randomize(4)),
            (items(N_('5 Moves')), lambda: randomize(5)),
            (items(N_('6 Moves')), lambda: randomize(6)),
            (items(N_('7 Moves')), lambda: randomize(7)),
            (items(N_('8 Moves')), lambda: randomize(8)),
            (items(N_('50 Moves')),lambda: (randomize(50),  plugin.run_moves())),
        ]:
    plugin.register_script(path, func)

