#include <time.h>
#include "ptexlib.h"

#undef DebugPW
#ifdef DebugPW
static char pdfcrypt_param_str[84];
static int  pdfcrypt_param_pos = 0;
#endif

static int pdfcryptstarted = 0;
static int pdfcryptcurrent = 0;


static char ownerKey[64], ownerPassword[64], userKey[64], userPassword[64], fileID[64];
static int ownerPasswordLength = 0;
static int  userPasswordLength = 0;


/* previously in gtypes.h */
typedef unsigned char Guchar;
typedef unsigned long Gulong;

static Guchar fileKey[5];
static Guchar objKey[16];
static Guchar state[256];
static Guchar x, y;

static void rc4InitKey(Guchar *key, int keyLen, Guchar *state);
static Guchar rc4DecryptByte(Guchar *state, Guchar *x, Guchar *y, Guchar c);
static void md5(Guchar *msg, int msgLen, Guchar *digest);

static Guchar passwordPad[32] = {
  0x28, 0xbf, 0x4e, 0x5e, 0x4e, 0x75, 0x8a, 0x41,
  0x64, 0x00, 0x4e, 0x56, 0xff, 0xfa, 0x01, 0x08, 
  0x2e, 0x2e, 0x00, 0xb6, 0xd0, 0x68, 0x3e, 0x80, 
  0x2f, 0x0c, 0xa9, 0xfe, 0x64, 0x53, 0x69, 0x7a
};

/*------------------------------------------------------------------------*/
/* Decrypt */
/*------------------------------------------------------------------------*/


void pdfcryptpw(integer i, strnumber s)
{
    static boolean nocrypt_warned = false;
    char *t;
    /* Encrypted strings or streams already shipped: ignore \pdfcrypt */
    if (pdfcryptstarted)
        return;
    if (pdfcryptobjnum > 0) {
        if (!nocrypt_warned) {
            pdftex_warn("\\pdfcrypt ignored (must be enable before the first object is written out)");
            nocrypt_warned = true;
        }
        return;
    }
    pdfcrypting = true;
    switch (i) {
    case pdfcryptowner:         
        strncpy(ownerPassword, t = makecstring(s), sizeof(ownerPassword));
        if (strlen(t) >= sizeof(ownerPassword) - 1)
            ownerPassword[sizeof(ownerPassword) - 1] = 0;
        ownerPasswordLength = strlen(ownerPassword);
        break;                 
    case pdfcryptuser:
        strncpy(userPassword, t = makecstring(s), sizeof(userPassword));
        if (strlen(t) >= sizeof(userPassword) - 1)
            userPassword[sizeof(userPassword) - 1] = 0;
        userPasswordLength = strlen(userPassword);
        break;                 
    case pdfcryptprint:
        pdfcryptpermit |= 0x0004; /* do Print */
        break;                 
    case pdfcryptedit:
        pdfcryptpermit |= 0x0008; /* do Edit */
        break;                 
    case pdfcryptcopy:
        pdfcryptpermit |= 0x0010; /* do Copy */
        break;                 
    case pdfcryptannotate:
        pdfcryptpermit |= 0x0020; /* do Annotate */
        break;                 
    case pdfcryptall:
        pdfcryptpermit |= 0x003c; /* do all */
        break;                 
    case pdfcryptnoprint:
        pdfcryptpermit &= 0xfff8; /* no Print */
        break;                 
    case pdfcryptnoedit:
        pdfcryptpermit &= 0xfff4; /* no Edit */
        break;                 
    case pdfcryptnocopy:
        pdfcryptpermit &= 0xffec; /* no Copy */
        break;                 
    case pdfcryptnoannotate:
        pdfcryptpermit &= 0xffdc; /* no Annotate */
        break;
    case pdfcryptnone:
        pdfcryptpermit &= 0xffc0; /* none */
        break;
    }
}

void pdfcrypt_init()
{
  unsigned char *buf, *key, ch;
  int i, len;

  buf = (unsigned char *)gmalloc(84);
  key = (unsigned char *)gmalloc(16);


  /* calculate a fileID: trailer << /ID [<16 bytes><16 bytes>] >> */
  srandom(time(NULL));
  for (i = 0; i < 16; i++) {
    ch = random() & 0xff;
    fileID[i] = ch;
    fileID[i+16] = fileID[i];
    sprintf(buf+2*i, "%02x", ch);
    }
  buf[32] = 0;
#ifdef DebugPW
  sprintf(buf,"%s;%s[P%d,E%d,C%d,A%d]", &ownerPassword, \
                                         &userPassword, \
                                        (pdfcryptpermit & 0x0004) >> 2, \
                                        (pdfcryptpermit & 0x0008) >> 3, \
                                        (pdfcryptpermit & 0x0010) >> 4, \
                                        (pdfcryptpermit & 0x0020) >> 5);
#endif
  pdfcryptid1=maketexstring(buf);
#ifdef DebugPW
  sprintf(buf, "%s", &pdfcrypt_param_str);
#endif
  pdfcryptid2=maketexstring(buf);


  /* Computing the O(wner) value of the Encryption dictionary */

  /* Adjust owner password string to 32 bytes as previously (or user pw if none) */
  if (ownerPasswordLength == 0) {
    memcpy(ownerPassword, userPassword, 32);
    ownerPasswordLength = userPasswordLength;
  }
  len = ownerPasswordLength;
  if (len < 32) memcpy(ownerPassword + len, passwordPad, 32 - len);
  ownerPasswordLength = 32;

  /* => MD5 => use 1st 5 bytes as RC4 key */
  md5(ownerPassword, 32, key);

  /* Adjust user password string to 32 bytes as previously */
  len = userPasswordLength;
  if (len < 32) memcpy(userPassword + len, passwordPad, 32 - len);
  userPasswordLength = 32;

  /* (RC4 key) and (adjusted user pw) => RC4 => store output as O value */
  x = y = 0;
  rc4InitKey(key, 5, state);
  for (i = 0; i < 32; ++i) {
      ch = rc4DecryptByte(state, &x, &y, userPassword[i]);
      ownerKey[i] = ch;
      sprintf(buf+2*i, "%02x", ch);
      }
  buf[64]=0;
  pdfcryptovalue=maketexstring(buf);


  /* Computing the U(ser) value of the Encryption dictionary */

  /* Create a 5-byte key using the 5-bytes-key generation algorithm from the user pw */

  /* Adjust user password string to 32 bytes as previously (already done) */
  memcpy(buf, userPassword, 32);

  /* Append 32-byte O(wner) value of the Encryption dictionary */
  memcpy(buf+32, ownerKey, 32);

  /* Append P(ermission) value trated as a 4-byte unsigned number */
  /* memcpy(buf+64, pdfcryptpermit, 4); */
  buf[64] =  pdfcryptpermit        & 0xff;
  buf[65] = (pdfcryptpermit >>  8) & 0xff;
  buf[66] = (pdfcryptpermit >> 16) & 0xff;
  buf[67] = (pdfcryptpermit >> 24) & 0xff;

  /* Append 1st element of file's file identifier: trailer<</ID[<1st><2nd>]>> */
  memcpy(buf+68, fileID, 16);

  /* => MD5 => take 1st 5 bytes of output as the key */
  md5(buf, 84, key);
  memcpy(fileKey, key, 5);

  /* (5-byte key) and (32-byte padding string) => RC4 => store output as U value */
  x = y = 0;
  rc4InitKey(fileKey, 5, state);
  for (i = 0; i < 32; ++i) {
      ch = rc4DecryptByte(state, &x, &y, passwordPad[i]);
      userKey[i] = ch;
      sprintf(buf+2*i, "%02x", ch);
      }
  buf[64]=0;
  pdfcryptuvalue=maketexstring(buf);


  gfree(key);
  gfree(buf);
}


void pdfcrypt_initkey()
{
  int pdfcryptobjgen = 0; /* in case there is ever an object generation <> 0 */

  if (!pdfcryptstarted) {
      pdfcryptstarted = 1;
      pdfcrypt_init();
      }

  if (pdfcryptcurrent != pdfcryptobjnum) {
      pdfcryptcurrent = pdfcryptobjnum;

      /* construct object key */
      objKey[0] = fileKey[0];
      objKey[1] = fileKey[1];
      objKey[2] = fileKey[2];
      objKey[3] = fileKey[3];
      objKey[4] = fileKey[4];
      objKey[5] =  pdfcryptobjnum        & 0xff;
      objKey[6] = (pdfcryptobjnum >>  8) & 0xff;
      objKey[7] = (pdfcryptobjnum >> 16) & 0xff;
      objKey[8] =  pdfcryptobjgen        & 0xff;
      objKey[9] = (pdfcryptobjgen >>  8) & 0xff;
      md5(objKey, 10, objKey);
      }

  /* set up for decryption */
  x = y = 0;
  rc4InitKey(objKey, 10, state);
}


char *add_ch(char *t, char *s, int *x, int encrypt)
{
    char ch;

    ch = s[0];
    *x = 1;
    if ( (encrypt) && (ch == 92) ) {
      switch (s[1]) {
        case  40: ch=40; (*x)++; break; /* \( */
        case  41: ch=41; (*x)++; break; /* \) */
        case  92: ch=92; (*x)++; break; /* \\ */
        case  98: ch= 8; (*x)++; break; /* \b */
        case 116: ch= 9; (*x)++; break; /* \t */
        case 110: ch=10; (*x)++; break; /* \n */
        case 102: ch=12; (*x)++; break; /* \f */
        case 114: ch=13; (*x)++; break; /* \r */
        default: /* octal */
           /* HO, 2002-01-09: backslash should not be ignored, if no
              special character is followed (b,t,n,r,\,(,),0-8) */
           if ( (s[*x] > 47) && (s[*x] < 56) ) {
             ch = s[(*x)++] - 48;
             if ( (s[*x] > 47) && (s[*x] < 56) ) ch = s[(*x)++] - 48 + ch*8;
             if ( (s[*x] > 47) && (s[*x] < 56) ) ch = s[(*x)++] - 48 + ch*8;
           }
           else {
             /* ignore backslash, if the next character is not special */
             ch = s[(*x)++];
           }
        }
      }
    if (encrypt) ch = pdfcrypt_byte(ch);
    switch (ch) {
        case  0:
/*
        case  8:
        case  9:
        case 10:
        case 12:
*/
        case 13:
        case 14: sprintf(t, "\\%03o", ch); t += 4; break;
        case 40:
        case 41:
        case 92: if (encrypt) sprintf(t++, "\\");
        default: sprintf(t++, "%c", ch);
        }
    return t;
}

strnumber pdfcrypt_maketexstring(char *s, int l)
{
    if (s == 0 || l == 0)
        return getnullstr();
    check_buf(poolptr + l, poolsize);
    while (l-- > 0)
        strpool[poolptr++] = *s++;
    last_tex_string = makestring();
    return last_tex_string;
}

int pdfcrypt_object(unsigned char **pool, int len)
{
    int encrypt, i, j, k, x, parenlevel, stream;
    unsigned char *t, *tstart, *obj, ch, chs;

    if ( (!pdfcrypting) || (len <= 0) ) return len;
    obj = *pool;

    parenlevel = 0;
    t = tstart = (unsigned char *)gmalloc(len * 4);
    for (i = 0; i < len; i += x) {
        ch = obj[i];
        stream = 0;

        if ( ch == 40 ) {
            if (parenlevel == 0) pdfcrypt_initkey();
            parenlevel++;
            }
        else
        if ( ch == 41 ) { parenlevel--; }
        else
        if ( (parenlevel == 0) && ( ch == 62 ) && ( obj[i + 1] == 62 ) && (i < len - 15) ) {
           /*
              Very dirty hack to find streams: a proper parser is needed here.
              It will fail if the input contains more than one stream:
              for example, with user-defined object arrays.
           */
           /* search the begining of a stream */
           j= i + 1;
           do { chs = obj[++j]; }
               while ( ( j < len - 15) &&
                     ( ( chs == 32 ) || ( chs == 9 ) || ( chs == 10 ) || ( chs == 13 ) )
                     );
           if ( ( j < len - 15) && ( strncmp(obj + j, "stream", 6) == 0 )) {
               /* stream found, search the end */
               stream = 1;
               j += 6;
               if ( obj[j] == 13 ) j++;
               if ( obj[j] == 10 ) j++;
               /* j now stores the pos of the first char in the stream */
               k = len - 9;
               while ( (k > j) && ( strncmp(obj + k, "endstream", 9) != 0 ) ) k--;
               /* k now stores the pos of the last+1 char in the stream */
               if ( strncmp(obj + k, "endstream", 9) == 0 ) {
                   /* send chars leading the stream unencrypted */
                   for (x = i; x < j; x++) *t++ = obj[x];
                   /* send the stream encrypted */
                   pdfcrypt_initkey();
                   for (x = j; x < k; x++) *t++ = pdfcrypt_byte(obj[x]);
                   /* send chars closing the stream unencrypted */
                   for (x = k; x < k + 9; x++) *t++ = obj[x];
                   /* and continue normally */
                   i = x;
                   x = 0;
                   }
               }
           }

        if (!stream) {
            /* encrypt chars if inside external parenthesis */
            encrypt = !( (!parenlevel) || (parenlevel == 1) && (ch == 40) );
            t = add_ch(t, obj + i, &x, encrypt);
            }
        }

    len = t - tstart;
    *pool = tstart;
    return len;
}


void pdfcryptfile(bytefile f)
{
    int i, len;
    unsigned char *buf, *tstart;

    /* The file is opened and closed in pdftex.ch */

    /* get the file length to allocate the buffer */
    fseek(f, 0, SEEK_END);
    len = ftell(f);
    fseek(f, 0, SEEK_SET);
    if (len <= 0) return;

    /* allocate the buffer and read the file */
    tstart = buf = (unsigned char *)gmalloc(len);
    fread(buf, len, 1, f);

    /* encrypt strings and streams and save the file */
    len = pdfcrypt_object(&tstart, len);
    for (i = 0; i < len; i++) pdfout(tstart[i]);

    /* deallocate buffers */
    if (tstart != buf) gfree(tstart);
    gfree(buf);
}


strnumber pdfcryptstringlist(strnumber s)
{
    int len;
    unsigned char *tstart;

    len = strstart[s + 1] - strstart[s];
    if ( (!pdfcrypting) || (len <= 0) ) return s;
    tstart = strpool + strstart[s];
    len = pdfcrypt_object(&tstart, len);

    /* do not use maketexstring with encrypted streams:
       they may contain NULL chars and they would be truncated */
    s = pdfcrypt_maketexstring(tstart, len);

    if (tstart != strpool) gfree(tstart);
    return s;
}

strnumber pdfcryptstring(strnumber s)
{
    int len, i, x;
    char *t, *tstart;

    len = strstart[s + 1] - strstart[s];
    if ( (!pdfcrypting) || (len <= 0) ) return s;

    /* Initialize key for current string */
    pdfcrypt_initkey();

    t = tstart = (char *)gmalloc(len * 4);
    for (i = strstart[s]; i < strstart[s + 1]; i += x)
        t = add_ch(t, strpool + i, &x, 1);

    /* ensure that the encrypted string ends with a NULL char */
    *t = 0;
    s = maketexstring(tstart);

    gfree(tstart);
    return s;
}

void pdfcryptstream(strnumber s)
{
    int i, len;

    len = strstart[s + 1] - strstart[s];
    if ( (!pdfcrypting) || (len <= 0) ) return;

    /* Initialize key for current stream */
    pdfcrypt_initkey();

    for (i = strstart[s]; i < strstart[s + 1]; i++)
        strpool[i] = pdfcrypt_byte(strpool[i]);
}


unsigned char pdfcrypt_byte(unsigned char c)
{
  return rc4DecryptByte(state, &x, &y, c);
}


/*------------------------------------------------------------------------*/
/* RC4-compatible decryption */
/*------------------------------------------------------------------------*/

static void rc4InitKey(Guchar *key, int keyLen, Guchar *state) {
  Guchar index1, index2;
  Guchar t;
  int i;

  for (i = 0; i < 256; ++i)
    state[i] = i;
  index1 = index2 = 0;
  for (i = 0; i < 256; ++i) {
    index2 = (key[index1] + state[i] + index2) % 256;
    t = state[i];
    state[i] = state[index2];
    state[index2] = t;
    index1 = (index1 + 1) % keyLen;
  }
}

static Guchar rc4DecryptByte(Guchar *state, Guchar *x, Guchar *y, Guchar c) {
  Guchar x1, y1, tx, ty;

  x1 = *x = (*x + 1) % 256;
  y1 = *y = (state[*x] + *y) % 256;
  tx = state[x1];
  ty = state[y1];
  state[x1] = ty;
  state[y1] = tx;
  return c ^ state[(tx + ty) % 256];
}

/*------------------------------------------------------------------------*/
/* MD5 message digest */
/*------------------------------------------------------------------------*/

static inline Gulong rotateLeft(Gulong x, int r) {
  x &= 0xffffffff;
  return ((x << r) | (x >> (32 - r))) & 0xffffffff;
}

static inline Gulong md5Round1(Gulong a, Gulong b, Gulong c, Gulong d,
			       Gulong Xk,  Gulong s, Gulong Ti) {
  return b + rotateLeft((a + ((b & c) | (~b & d)) + Xk + Ti), s);
}

static inline Gulong md5Round2(Gulong a, Gulong b, Gulong c, Gulong d,
			       Gulong Xk,  Gulong s, Gulong Ti) {
  return b + rotateLeft((a + ((b & d) | (c & ~d)) + Xk + Ti), s);
}

static inline Gulong md5Round3(Gulong a, Gulong b, Gulong c, Gulong d,
			       Gulong Xk,  Gulong s, Gulong Ti) {
  return b + rotateLeft((a + (b ^ c ^ d) + Xk + Ti), s);
}

static inline Gulong md5Round4(Gulong a, Gulong b, Gulong c, Gulong d,
			       Gulong Xk,  Gulong s, Gulong Ti) {
  return b + rotateLeft((a + (c ^ (b | ~d)) + Xk + Ti), s);
}

static void md5(Guchar *msg, int msgLen, Guchar *digest) {
  Gulong x[16];
  Gulong a, b, c, d, aa, bb, cc, dd;
  int n64;
  int i, j, k;

  /* compute number of 64-byte blocks */
  /* (length + pad byte (0x80) + 8 bytes for length) */
  n64 = (msgLen + 1 + 8 + 63) / 64;

  /* initialize a, b, c, d */
  a = 0x67452301;
  b = 0xefcdab89;
  c = 0x98badcfe;
  d = 0x10325476;

  /* loop through blocks */
  k = 0;
  for (i = 0; i < n64; ++i) {

    /* grab a 64-byte block */
    for (j = 0; j < 16 && k < msgLen - 3; ++j, k += 4)
      x[j] = (((((msg[k+3] << 8) + msg[k+2]) << 8) + msg[k+1]) << 8) + msg[k];
    if (i == n64 - 1) {
      if (k == msgLen - 3)
	x[j] = 0x80000000 + (((msg[k+2] << 8) + msg[k+1]) << 8) + msg[k];
      else if (k == msgLen - 2)
	x[j] = 0x800000 + (msg[k+1] << 8) + msg[k];
      else if (k == msgLen - 1)
	x[j] = 0x8000 + msg[k];
      else
	x[j] = 0x80;
      ++j;
      while (j < 16)
	x[j++] = 0;
      x[14] = msgLen << 3;
    }

    /* save a, b, c, d */
    aa = a;
    bb = b;
    cc = c;
    dd = d;

    /* round 1 */
    a = md5Round1(a, b, c, d, x[0],   7, 0xd76aa478);
    d = md5Round1(d, a, b, c, x[1],  12, 0xe8c7b756);
    c = md5Round1(c, d, a, b, x[2],  17, 0x242070db);
    b = md5Round1(b, c, d, a, x[3],  22, 0xc1bdceee);
    a = md5Round1(a, b, c, d, x[4],   7, 0xf57c0faf);
    d = md5Round1(d, a, b, c, x[5],  12, 0x4787c62a);
    c = md5Round1(c, d, a, b, x[6],  17, 0xa8304613);
    b = md5Round1(b, c, d, a, x[7],  22, 0xfd469501);
    a = md5Round1(a, b, c, d, x[8],   7, 0x698098d8);
    d = md5Round1(d, a, b, c, x[9],  12, 0x8b44f7af);
    c = md5Round1(c, d, a, b, x[10], 17, 0xffff5bb1);
    b = md5Round1(b, c, d, a, x[11], 22, 0x895cd7be);
    a = md5Round1(a, b, c, d, x[12],  7, 0x6b901122);
    d = md5Round1(d, a, b, c, x[13], 12, 0xfd987193);
    c = md5Round1(c, d, a, b, x[14], 17, 0xa679438e);
    b = md5Round1(b, c, d, a, x[15], 22, 0x49b40821);

    /* round 2 */
    a = md5Round2(a, b, c, d, x[1],   5, 0xf61e2562);
    d = md5Round2(d, a, b, c, x[6],   9, 0xc040b340);
    c = md5Round2(c, d, a, b, x[11], 14, 0x265e5a51);
    b = md5Round2(b, c, d, a, x[0],  20, 0xe9b6c7aa);
    a = md5Round2(a, b, c, d, x[5],   5, 0xd62f105d);
    d = md5Round2(d, a, b, c, x[10],  9, 0x02441453);
    c = md5Round2(c, d, a, b, x[15], 14, 0xd8a1e681);
    b = md5Round2(b, c, d, a, x[4],  20, 0xe7d3fbc8);
    a = md5Round2(a, b, c, d, x[9],   5, 0x21e1cde6);
    d = md5Round2(d, a, b, c, x[14],  9, 0xc33707d6);
    c = md5Round2(c, d, a, b, x[3],  14, 0xf4d50d87);
    b = md5Round2(b, c, d, a, x[8],  20, 0x455a14ed);
    a = md5Round2(a, b, c, d, x[13],  5, 0xa9e3e905);
    d = md5Round2(d, a, b, c, x[2],   9, 0xfcefa3f8);
    c = md5Round2(c, d, a, b, x[7],  14, 0x676f02d9);
    b = md5Round2(b, c, d, a, x[12], 20, 0x8d2a4c8a);

    /* round 3 */
    a = md5Round3(a, b, c, d, x[5],   4, 0xfffa3942);
    d = md5Round3(d, a, b, c, x[8],  11, 0x8771f681);
    c = md5Round3(c, d, a, b, x[11], 16, 0x6d9d6122);
    b = md5Round3(b, c, d, a, x[14], 23, 0xfde5380c);
    a = md5Round3(a, b, c, d, x[1],   4, 0xa4beea44);
    d = md5Round3(d, a, b, c, x[4],  11, 0x4bdecfa9);
    c = md5Round3(c, d, a, b, x[7],  16, 0xf6bb4b60);
    b = md5Round3(b, c, d, a, x[10], 23, 0xbebfbc70);
    a = md5Round3(a, b, c, d, x[13],  4, 0x289b7ec6);
    d = md5Round3(d, a, b, c, x[0],  11, 0xeaa127fa);
    c = md5Round3(c, d, a, b, x[3],  16, 0xd4ef3085);
    b = md5Round3(b, c, d, a, x[6],  23, 0x04881d05);
    a = md5Round3(a, b, c, d, x[9],   4, 0xd9d4d039);
    d = md5Round3(d, a, b, c, x[12], 11, 0xe6db99e5);
    c = md5Round3(c, d, a, b, x[15], 16, 0x1fa27cf8);
    b = md5Round3(b, c, d, a, x[2],  23, 0xc4ac5665);

    /* round 4 */
    a = md5Round4(a, b, c, d, x[0],   6, 0xf4292244);
    d = md5Round4(d, a, b, c, x[7],  10, 0x432aff97);
    c = md5Round4(c, d, a, b, x[14], 15, 0xab9423a7);
    b = md5Round4(b, c, d, a, x[5],  21, 0xfc93a039);
    a = md5Round4(a, b, c, d, x[12],  6, 0x655b59c3);
    d = md5Round4(d, a, b, c, x[3],  10, 0x8f0ccc92);
    c = md5Round4(c, d, a, b, x[10], 15, 0xffeff47d);
    b = md5Round4(b, c, d, a, x[1],  21, 0x85845dd1);
    a = md5Round4(a, b, c, d, x[8],   6, 0x6fa87e4f);
    d = md5Round4(d, a, b, c, x[15], 10, 0xfe2ce6e0);
    c = md5Round4(c, d, a, b, x[6],  15, 0xa3014314);
    b = md5Round4(b, c, d, a, x[13], 21, 0x4e0811a1);
    a = md5Round4(a, b, c, d, x[4],   6, 0xf7537e82);
    d = md5Round4(d, a, b, c, x[11], 10, 0xbd3af235);
    c = md5Round4(c, d, a, b, x[2],  15, 0x2ad7d2bb);
    b = md5Round4(b, c, d, a, x[9],  21, 0xeb86d391);

    /* increment a, b, c, d */
    a += aa;
    b += bb;
    c += cc;
    d += dd;
  }

  /* break digest into bytes */
  digest[0] = a & 0xff;
  digest[1] = (a >>= 8) & 0xff;
  digest[2] = (a >>= 8) & 0xff;
  digest[3] = (a >>= 8) & 0xff;
  digest[4] = b & 0xff;
  digest[5] = (b >>= 8) & 0xff;
  digest[6] = (b >>= 8) & 0xff;
  digest[7] = (b >>= 8) & 0xff;
  digest[8] = c & 0xff;
  digest[9] = (c >>= 8) & 0xff;
  digest[10] = (c >>= 8) & 0xff;
  digest[11] = (c >>= 8) & 0xff;
  digest[12] = d & 0xff;
  digest[13] = (d >>= 8) & 0xff;
  digest[14] = (d >>= 8) & 0xff;
  digest[15] = (d >>= 8) & 0xff;
}
