# -*- perl -*-
# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released "AS IS WITH ALL FAULTS"
# and WITHOUT ANY WARRANTIES under the terms of the GNU Lesser
# General Public License, Version 2.1, a copy of which can be
# found in the "COPYING" file of this distribution.

# $Id: include.t,v 1.1 2000/12/10 23:06:49 muaddib Exp $

use strict;
use Test;
use Data::Dumper;
use PSP::Parser;

my $n_iterations = 1;
plan tests => $n_iterations * 82;
for (my $n=0; $n<$n_iterations; $n++) {

#create a parser.
my $parser;
ok $parser = PSP::Parser->new();

#print Dumper($parser);
ok !$parser->{verbose};
ok !$parser->{pile_name};
ok !@{$parser->{includepath}};
ok !$parser->{sub_lvl};
ok $parser->{back_compat} eq 1;
ok @{$parser->{propagatable}};
ok %{$parser->{handlers_begin}};
ok %{$parser->{handlers_end}};
ok @{$parser->{stack_text_sub}};
ok @{$parser->{stack_code_sub}};
ok !@{$parser->{stack_handlers}};
ok !@{$parser->{depends}};
ok !%{$parser->{depends_h}};
ok !$parser->{is_cdata};
ok !$parser->{text_to_flush};
ok !$parser->{current_code};
ok !$parser->{current_indent};
ok @{$parser->{stack_decl}};
ok @{$parser->{stack_context}};
ok $parser->{prev_context};
ok $parser->{current_line_n};
ok !$parser->{current_fname};
ok !%{$parser->{preparsed}};
ok !$parser->{debug};

#map { touch("include$_-$$.inc") } qw(0 1 2 3 4);
sub touch_file { open FILE, ">>".$_[0]; close FILE; }
#map { create_file("include.inc","<psp:include src='include.inc'/>\n");
sub create_file { open FILE, ">".shift and print FILE @_ and close FILE; }

ok(-d "tmp" or mkdir "tmp", 0755);
ok create_file("tmp/test.psp","<psp:include src='include-1.inc'/>\n");
ok create_file("tmp/include-1.inc","<psp:include src='include-2.inc'/>\n");
ok create_file("tmp/include-2.inc","<psp:include src='include-3.inc'/>\n");
ok(!-f "tmp/include-3.inc" or unlink("tmp/include-3.inc"));

# parse the input source file.

print STDERR "\nexpect an error==================\n";
ok !$parser->parse_file("tmp/test.psp");
print STDERR "expected an error================\n";

# fix the error.
ok touch_file("tmp/include-3.inc");
ok $parser = PSP::Parser->new();
ok $parser->parse_file("tmp/test.psp");

ok @{$parser->{depends}};
ok %{$parser->{depends_h}};
ok $parser->{current_code};
ok $parser->{current_fname};

#clean up after that test.
ok unlink("tmp/include-3.inc");
ok unlink("tmp/include-2.inc");
ok unlink("tmp/include-1.inc");
ok unlink("tmp/test.psp");

# do a more complex test.
ok(-d "tmp/inc1" or mkdir "tmp/inc1", 0755);
ok(-d "tmp/inc2" or mkdir "tmp/inc2", 0755);
ok(-d "tmp/inc1/inc3" or mkdir "tmp/inc1/inc3", 0755);
ok create_file("tmp/test.psp",
	       "<psp:include src='inc1/include.inc'/>\n");
ok create_file("tmp/inc1/include.inc",
	       "<psp:include src='../inc2/include.inc'/>\n");
ok create_file("tmp/inc2/include.inc",
	       "<psp:include src='../inc1/inc3/include.inc'/>\n");
unlink("tmp/inc1/inc3/include.inc");

ok $parser = PSP::Parser->new();
print STDERR "\nexpect an error==================\n";
ok !$parser->parse_file("tmp/test.psp");
print STDERR "expected an error================\n";

ok touch_file("tmp/inc1/inc3/include.inc");
ok $parser = PSP::Parser->new();
ok $parser->parse_file("tmp/test.psp");

ok unlink("tmp/test.psp");
ok unlink("tmp/inc1/include.inc");
ok unlink("tmp/inc2/include.inc");
ok unlink("tmp/inc1/inc3/include.inc");
ok rmdir("tmp/inc1/inc3");
ok rmdir("tmp/inc1");
ok rmdir("tmp/inc2");

ok create_file("tmp/test.psp","<psp:include src='include1.inc'/>\n");
ok(-d "tmp/inc" or mkdir "tmp/inc", 0755);
ok(-d "tmp/inc/erf" or mkdir "tmp/inc/erf", 0755);
ok create_file("tmp/inc/include1.inc",
	       "<psp:include src='erf/include2.inc'/>\n");
ok create_file("tmp/inc/erf/include2.inc",
	       "<psp:include src='include3.inc'/>\n");
ok(!-f "tmp/inc/include3.inc" or unlink("tmp/inc/include3.inc"));

ok $parser = PSP::Parser->new();
print STDERR "\nexpect an error==================\n";
ok !$parser->parse_file("tmp/test.psp",["tmp/inc"]);
print STDERR "expected an error================\n";

ok touch_file("tmp/inc/include3.inc");
ok $parser = PSP::Parser->new();
ok $parser->parse_file("tmp/test.psp",["tmp/inc"]);

#print Dumper($parser);
ok @{$parser->{depends}};
ok %{$parser->{depends_h}};
ok $parser->{current_code};
ok $parser->{current_fname};

ok unlink("tmp/test.psp");
ok unlink("tmp/inc/include1.inc");
ok unlink("tmp/inc/include3.inc");
ok unlink("tmp/inc/erf/include2.inc");
ok rmdir("tmp/inc/erf");
ok rmdir("tmp/inc");
ok rmdir("tmp");


}#for $n_iterations
