package AtomicData::TaxID;

# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released under the GNU Lesser General
# Public License, Version 2.1.  Please read the important licensing and
# disclaimer information included below.

# $Id: TaxID.pm,v 1.1 2000/11/23 23:36:15 muaddib Exp $

use strict;

=head1 NAME

AtmoicData::TaxID - data encapsulator for tax ID numbers

=head1 SYNOPSIS

see AtomicData.pm

=head1 DESCRIPTION

Implements data encapsulation for tax ID numbers. See
AtomicData.pm for further details.

=cut

use AtomicData::Text;
@AtomicData::TaxID::ISA = qw (AtomicData::Text);

=head1 METHODS

see AtomicData.pm for further methods.

=head2 parameters

see parent class for further documentation. Note that min/max_length
are overidden by this class and set to both be 9.

=head2 set_format

Will accept dashes and dash which display the canonical form in the
form /\d{3}-\d\d-\d{4}/ and /\d\d-\d{7}/ if not blank where the '-' is
the default but can be changed be setting the value of 'seperator' in
C<set_format()> to either '-', '.', ' ' or '/'.

=head2 _canonicalize

 instance/private
 (int $value) _canonicalize (int $raw_value)

DESCRIPTION:

Will accept a value and return the cannonical form or undef and set
C<$this->{_can_failed}>.

=cut

sub _canonicalize {
  my ($this, $val) = @_;

  $val = $this->SUPER::_canonicalize($val);
  defined $val or return;

  $val =~ s/(\d{3})${AtomicData::deliminators}(\d{2})${AtomicData::deliminators}(\d{4})/$1$2$3/;
  $val =~ s/(\d\d)${AtomicData::deliminators}(\d{7})/$1$2/;
  $val =~ s/^\s*(\d+)\s*$/$1/;
  if ($val && 
      !($val =~ /^(\d{9})$/)) { #should be blank or 9 digits
    $this->{_can_failed} = ['Invalid tax ID number.'];
    return undef;
  }

  return $val;
}

=head2 _verify

 instance/private
 (1) _verify ()

DESCRIPTION:

=cut

sub _verify {
  my ($this, @args) = @_;
  
  $this->{_parameters}->{min_length} = 9;
  $this->{_parameters}->{max_length} = 9;

  return $this->SUPER::_verify(@args);
}

=head2 _format

 instance/private
 (string $tax_id) _format (int $value)

DESCRIPTION:

Will format per formatting options.

=cut

sub _format {
  my ($this, $value) = @_;

  my $sep = $this->{_format}->{seperator} || '-';
  
  if ($sep =~ /\.|\//) {
    $sep = '\\'.$sep;
  }
  elsif ($sep !~ / |-/) {
    $sep = `-`;
  }

  if ($this->{_format}->{dashes}) {
    $value =~ s/(\d{3})(\d\d)(\d{4})/$1$sep$2$sep$3/;
  }
  if ($this->{_format}->{dash}) {
    $value =~ s/(\d\d)(\d{7})/$1$sep$2/;
  }

  return $value;
}

1;
__END__

=head1 BUGS

No known bugs, but this does not mean no bugs exist.

=head1 SEE ALSO

L<AtomicData>, L<HTMLIO>, L<Field>.

=head1 COPYRIGHT

 PSP - Perl Server Pages
 Copyright (c) 2000, FundsXpress Financial Network, Inc.

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.

 BECAUSE THIS LIBRARY IS LICENSED FREE OF CHARGE, THIS LIBRARY IS
 BEING PROVIDED "AS IS WITH ALL FAULTS," WITHOUT ANY WARRANTIES
 OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING, WITHOUT
 LIMITATION, ANY IMPLIED WARRANTIES OF TITLE, NONINFRINGEMENT,
 MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, AND THE
 ENTIRE RISK AS TO SATISFACTORY QUALITY, PERFORMANCE, ACCURACY,
 AND EFFORT IS WITH THE YOU.  See the GNU Lesser General Public
 License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

=cut
