#
#@BEGIN LICENSE
#
# PSI4: an ab initio quantum chemistry software package
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#
#@END LICENSE
#

def function_5pt(xa, ya, x):
    x1 = xa[0]
    x2 = xa[1]
    x3 = xa[2]
    x4 = xa[3]
    x5 = xa[4]
    
    y1 = ya[0]
    y2 = ya[1]
    y3 = ya[2]
    y4 = ya[3]
    y5 = ya[4]
    
    result = (y1 + (x - x1)*((-y1 + y2)/(-x1 + x2) + 
          (x - x2)*((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3) + 
             (x - x3)*((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                 (-x1 + x4) + ((x - x4)*
                   (-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                          (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                        (-x1 + x4)) + (-((-((-y2 + y3)/(-x2 + x3)) + 
                             (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                        (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                        (-x2 + x5)))/(-x1 + x5)))))
    return result

def first_deriv_5pt(xa, ya, x):
    x1 = xa[0]
    x2 = xa[1]
    x3 = xa[2]
    x4 = xa[3]
    x5 = xa[4]
    
    y1 = ya[0]
    y2 = ya[1]
    y3 = ya[2]
    y4 = ya[3]
    y5 = ya[4]
    
    result = ((-y1 + y2)/(-x1 + x2) + (x - x2)*((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
           (-x1 + x3) + (x - x3)*((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                   (-x1 + x3)) + (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                 (-x2 + x4))/(-x1 + x4) + 
             ((x - x4)*(-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                          (-x1 + x3)) + 
                       (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                     (-x1 + x4)) + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                        (-x2 + x4)) + (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                      (-x3 + x5))/(-x2 + x5)))/(-x1 + x5))) + 
       (x - x1)*((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3) + 
          (x - x3)*((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/(-x1 + x4)\
              + ((x - x4)*(-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                          (-x1 + x3)) + 
                       (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                     (-x1 + x4)) + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                        (-x2 + x4)) + (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                      (-x3 + x5))/(-x2 + x5)))/(-x1 + x5)) + 
          (x - x2)*((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/(-x1 + x4)\
              + ((x - x3)*(-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                          (-x1 + x3)) + 
                       (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                     (-x1 + x4)) + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                        (-x2 + x4)) + (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                      (-x3 + x5))/(-x2 + x5)))/(-x1 + x5) + 
             ((x - x4)*(-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                          (-x1 + x3)) + 
                       (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                     (-x1 + x4)) + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                        (-x2 + x4)) + (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                        (-x3 + x5))/(-x2 + x5)))/(-x1 + x5))))
    return result

def second_deriv_5pt(xa, ya, x):
    x1 = xa[0]
    x2 = xa[1]
    x3 = xa[2]
    x4 = xa[3]
    x5 = xa[4]
    
    y1 = ya[0]
    y2 = ya[1]
    y3 = ya[2]
    y4 = ya[3]
    y5 = ya[4]
    
    result = ((2.0*(-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3)))/(-x1 + x3) + 
       2.0*(x - x3)*((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
             (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/(-x1 + x4) + 
          ((x - x4)*(-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                    (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                  (-x1 + x4)) + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                     (-x2 + x4)) + (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                   (-x3 + x5))/(-x2 + x5)))/(-x1 + x5)) + 
       2.0*(x - x2)*((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
             (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/(-x1 + x4) + 
          ((x - x3)*(-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                    (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                  (-x1 + x4)) + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                     (-x2 + x4)) + (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                   (-x3 + x5))/(-x2 + x5)))/(-x1 + x5) + 
          ((x - x4)*(-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                    (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                  (-x1 + x4)) + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                     (-x2 + x4)) + (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                   (-x3 + x5))/(-x2 + x5)))/(-x1 + x5)) + 
       (x - x1)*((2.0*(-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
               (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)))/(-x1 + x4)\
           + (2.0*(x - x2)*(-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                       (-x1 + x3)) + (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                     (-x2 + x4))/(-x1 + x4)) + 
               (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                  (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/(-x2 + x5)
               ))/(-x1 + x5) + (2.0*(x - x3)*
             (-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                    (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                  (-x1 + x4)) + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                     (-x2 + x4)) + (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                   (-x3 + x5))/(-x2 + x5)))/(-x1 + x5) + 
          (2.0*(x - x4)*(-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                       (-x1 + x3)) + (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                     (-x2 + x4))/(-x1 + x4)) + 
               (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                  (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/(-x2 + x5)
               ))/(-x1 + x5)))
    return result

def third_deriv_5pt(xa, ya, x):
    x1 = xa[0]
    x2 = xa[1]
    x3 = xa[2]
    x4 = xa[3]
    x5 = xa[4]
    
    y1 = ya[0]
    y2 = ya[1]
    y3 = ya[2]
    y4 = ya[3]
    y5 = ya[4]
    
    result = ((2.0*(-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
            (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)))/(-x1 + x4) + 
       (6.0*(x - x1)*(-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                 (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/(-x1 + x4))
              + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
               (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/(-x2 + x5)))/
        (-x1 + x5) + (6.0*(x - x2)*(-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                    (-x1 + x3)) + (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                  (-x2 + x4))/(-x1 + x4)) + 
            (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
               (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/(-x2 + x5)))/
        (-x1 + x5) + (4.0*(x - x3)*(-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                    (-x1 + x3)) + (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                  (-x2 + x4))/(-x1 + x4)) + 
            (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
               (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/(-x2 + x5)))/
        (-x1 + x5) + (2.0*(x - x4)*(-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                    (-x1 + x3)) + (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                  (-x2 + x4))/(-x1 + x4)) + 
            (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
               (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/(-x2 + x5)))/
        (-x1 + x5) + 2.0*((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                (-x1 + x3)) + (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)
             )/(-x1 + x4) + ((x - x4)*(-((-((-((-y1 + y2)/(-x1 + x2)) + 
                         (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                    (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                  (-x1 + x4)) + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                     (-x2 + x4)) + (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                   (-x3 + x5))/(-x2 + x5)))/(-x1 + x5)) + 
       2.0*((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
             (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/(-x1 + x4) + 
          ((x - x3)*(-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                    (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                  (-x1 + x4)) + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                     (-x2 + x4)) + (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                   (-x3 + x5))/(-x2 + x5)))/(-x1 + x5) + 
          ((x - x4)*(-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                    (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                  (-x1 + x4)) + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                     (-x2 + x4)) + (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                   (-x3 + x5))/(-x2 + x5)))/(-x1 + x5)))
    return result

def fourth_deriv_5pt(xa, ya, x):
    x1 = xa[0]
    x2 = xa[1]
    x3 = xa[2]
    x4 = xa[3]
    x5 = xa[4]
    
    y1 = ya[0]
    y2 = ya[1]
    y3 = ya[2]
    y4 = ya[3]
    y5 = ya[4]
    
    result = ((24.0*(-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/(-x1 + x4))\
            + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
              (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/(-x2 + x5)))/
       (-x1 + x5))
    return result

def function_9pt(xa, ya, x):
    x1 = xa[0]
    x2 = xa[1]
    x3 = xa[2]
    x4 = xa[3]
    x5 = xa[4]
    x6 = xa[5]
    x7 = xa[6]
    x8 = xa[7]
    x9 = xa[8]
    
    y1 = ya[0]
    y2 = ya[1]
    y3 = ya[2]
    y4 = ya[3]
    y5 = ya[4]
    y6 = ya[5]
    y7 = ya[6]
    y8 = ya[7]
    y9 = ya[8]
    
    result = (y1 + (x - x1)*((-y1 + y2)/(-x1 + x2) + 
          (x - x2)*((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3) + 
             (x - x3)*((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/(-x1 + x4)\
                 + (x - x4)*((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                              (-x1 + x3)) + 
                           (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                         (-x1 + x4)) + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                            (-x2 + x4)) + 
                         (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                       (-x2 + x5))/(-x1 + x5) + 
                   (x - x5)*((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                              (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                 (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                  (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                         (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                 (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                  (-x3 + x5))/(-x2 + x5)) + 
                            (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                  (-x3 + x5)) + 
                               (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))
                              /(-x3 + x6))/(-x2 + x6))/(-x1 + x6) + 
                      (x - x6)*((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                 (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                            (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                               (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                  (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                           + (x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                  ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                  (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                               )/(-x1 + x8) + 
                            ((x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                   )/(-x1 + x8)) + 
                                 (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                   ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                   (-((-((-((-((-y4 + y5)/(-x4 + x5)) + 
                                   (-y5 + y6)/(-x5 + x6))/(-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                                   )/(-x2 + x9)))/(-x1 + x9)))))))))
    return result

def first_deriv_9pt(xa, ya, x):
    x1 = xa[0]
    x2 = xa[1]
    x3 = xa[2]
    x4 = xa[3]
    x5 = xa[4]
    x6 = xa[5]
    x7 = xa[6]
    x8 = xa[7]
    x9 = xa[8]
    
    y1 = ya[0]
    y2 = ya[1]
    y3 = ya[2]
    y4 = ya[3]
    y5 = ya[4]
    y6 = ya[5]
    y7 = ya[6]
    y8 = ya[7]
    y9 = ya[8]
    
    result = ((-y1 + y2)/(-x1 + x2) + (x - x2)*((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
           (-x1 + x3) + (x - x3)*((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                   (-x1 + x3)) + (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                 (-x2 + x4))/(-x1 + x4) + 
             (x - x4)*((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                           (-x1 + x3)) + 
                        (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                      (-x1 + x4)) + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                         (-x2 + x4)) + (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                       (-x3 + x5))/(-x2 + x5))/(-x1 + x5) + 
                (x - x5)*((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)
                                )/(-x1 + x4)) + 
                           (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                 (-x2 + x4)) + 
                              (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                            (-x2 + x5))/(-x1 + x5)) + 
                      (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                              (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                            (-x2 + x5)) + 
                         (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                            (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                          (-x3 + x6))/(-x2 + x6))/(-x1 + x6) + 
                   (x - x6)*((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                              (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                 (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                         (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                 (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                            (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                               (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                  (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                        + (x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                 (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                               ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                               (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                  (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                            )/(-x1 + x8) + 
                         ((x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                   )/(-x1 + x8)) + 
                              (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                   ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                   (-((-((-((-((-y4 + y5)/(-x4 + x5)) + 
                                   (-y5 + y6)/(-x5 + x6))/(-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                                 )/(-x2 + x9)))/(-x1 + x9))))))) + 
       (x - x1)*((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3) + 
          (x - x3)*((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/(-x1 + x4) + 
             (x - x4)*((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                           (-x1 + x3)) + 
                        (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                      (-x1 + x4)) + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                         (-x2 + x4)) + (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                       (-x3 + x5))/(-x2 + x5))/(-x1 + x5) + 
                (x - x5)*((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)
                                )/(-x1 + x4)) + 
                           (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                 (-x2 + x4)) + 
                              (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                            (-x2 + x5))/(-x1 + x5)) + 
                      (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                              (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                            (-x2 + x5)) + 
                         (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                            (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                          (-x3 + x6))/(-x2 + x6))/(-x1 + x6) + 
                   (x - x6)*((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                              (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                 (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                         (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                 (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                            (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                               (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                  (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                        + (x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                 (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                               ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                               (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                  (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                            )/(-x1 + x8) + 
                         ((x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                   )/(-x1 + x8)) + 
                              (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                   ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                   (-((-((-((-((-y4 + y5)/(-x4 + x5)) + 
                                   (-y5 + y6)/(-x5 + x6))/(-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                                 )/(-x2 + x9)))/(-x1 + x9)))))) + 
          (x - x2)*((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/(-x1 + x4) + 
             (x - x4)*((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                           (-x1 + x3)) + 
                        (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                      (-x1 + x4)) + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                         (-x2 + x4)) + (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                       (-x3 + x5))/(-x2 + x5))/(-x1 + x5) + 
                (x - x5)*((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)
                                )/(-x1 + x4)) + 
                           (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                 (-x2 + x4)) + 
                              (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                            (-x2 + x5))/(-x1 + x5)) + 
                      (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                              (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                            (-x2 + x5)) + 
                         (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                            (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                          (-x3 + x6))/(-x2 + x6))/(-x1 + x6) + 
                   (x - x6)*((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                              (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                 (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                         (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                 (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                            (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                               (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                  (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                        + (x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                 (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                               ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                               (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                  (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                            )/(-x1 + x8) + 
                         ((x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                   )/(-x1 + x8)) + 
                              (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                   ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                   (-((-((-((-((-y4 + y5)/(-x4 + x5)) + 
                                   (-y5 + y6)/(-x5 + x6))/(-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                                 )/(-x2 + x9)))/(-x1 + x9))))) + 
             (x - x3)*((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                           (-x1 + x3)) + 
                        (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                      (-x1 + x4)) + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                         (-x2 + x4)) + (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                       (-x3 + x5))/(-x2 + x5))/(-x1 + x5) + 
                (x - x5)*((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)
                                )/(-x1 + x4)) + 
                           (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                 (-x2 + x4)) + 
                              (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                            (-x2 + x5))/(-x1 + x5)) + 
                      (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                              (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                            (-x2 + x5)) + 
                         (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                            (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                          (-x3 + x6))/(-x2 + x6))/(-x1 + x6) + 
                   (x - x6)*((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                              (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                 (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                         (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                 (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                            (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                               (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                  (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                        + (x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                 (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                               ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                               (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                  (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                            )/(-x1 + x8) + 
                         ((x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                   )/(-x1 + x8)) + 
                              (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                   ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                   (-((-((-((-((-y4 + y5)/(-x4 + x5)) + 
                                   (-y5 + y6)/(-x5 + x6))/(-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                                 )/(-x2 + x9)))/(-x1 + x9)))) + 
                (x - x4)*((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)
                                )/(-x1 + x4)) + 
                           (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                 (-x2 + x4)) + 
                              (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                            (-x2 + x5))/(-x1 + x5)) + 
                      (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                              (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                            (-x2 + x5)) + 
                         (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                            (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                          (-x3 + x6))/(-x2 + x6))/(-x1 + x6) + 
                   (x - x6)*((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                              (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                 (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                         (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                 (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                            (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                               (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                  (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                        + (x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                 (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                               ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                               (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                  (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                            )/(-x1 + x8) + 
                         ((x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                   )/(-x1 + x8)) + 
                              (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                   ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                   (-((-((-((-((-y4 + y5)/(-x4 + x5)) + 
                                   (-y5 + y6)/(-x5 + x6))/(-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                                 )/(-x2 + x9)))/(-x1 + x9))) + 
                   (x - x5)*((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                              (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                 (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                         (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                 (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                            (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                               (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                  (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                        + (x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                 (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                               ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                               (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                  (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                            )/(-x1 + x8) + 
                         ((x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                   )/(-x1 + x8)) + 
                              (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                   ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                   (-((-((-((-((-y4 + y5)/(-x4 + x5)) + 
                                   (-y5 + y6)/(-x5 + x6))/(-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                                 )/(-x2 + x9)))/(-x1 + x9)) + 
                      (x - x6)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                 (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                               ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                               (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                  (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                            )/(-x1 + x8) + 
                         ((x - x7)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                   )/(-x1 + x8)) + 
                              (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                   ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                   (-((-((-((-((-y4 + y5)/(-x4 + x5)) + 
                                   (-y5 + y6)/(-x5 + x6))/(-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                                 )/(-x2 + x9)))/(-x1 + x9) + 
                         ((x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                   )/(-x1 + x8)) + 
                              (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                   ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                   (-((-((-((-((-y4 + y5)/(-x4 + x5)) + 
                                   (-y5 + y6)/(-x5 + x6))/(-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                                   )/(-x2 + x9)))/(-x1 + x9))))))))
    return result

def second_deriv_9pt(xa, ya, x):
    x1 = xa[0]
    x2 = xa[1]
    x3 = xa[2]
    x4 = xa[3]
    x5 = xa[4]
    x6 = xa[5]
    x7 = xa[6]
    x8 = xa[7]
    x9 = xa[8]
    
    y1 = ya[0]
    y2 = ya[1]
    y3 = ya[2]
    y4 = ya[3]
    y5 = ya[4]
    y6 = ya[5]
    y7 = ya[6]
    y8 = ya[7]
    y9 = ya[8]
    
    result = ((2*(-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3)))/(-x1 + x3) + 
       2*(x - x3)*((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
             (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/(-x1 + x4) + 
          (x - x4)*((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                     (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                   (-x1 + x4)) + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                      (-x2 + x4)) + (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                    (-x3 + x5))/(-x2 + x5))/(-x1 + x5) + 
             (x - x5)*((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                (-x1 + x3)) + 
                             (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                           (-x1 + x4)) + 
                        (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                           (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                         (-x2 + x5))/(-x1 + x5)) + 
                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                           (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                         (-x2 + x5)) + (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                            (-x3 + x5)) + 
                         (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                       (-x3 + x6))/(-x2 + x6))/(-x1 + x6) + 
                (x - x6)*((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                           (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                              (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                      (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                              (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                         (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6)) + 
                            (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6)) + 
                               (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/(-x5 + x7))
                              /(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7) + 
                   (x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                              (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                            ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                            (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                               (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                  (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                         )/(-x1 + x8) + 
                      ((x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                )/(-x1 + x8)) + 
                           (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                 ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                 (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                              )/(-x2 + x9)))/(-x1 + x9)))))) + 
       2*(x - x2)*((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
             (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/(-x1 + x4) + 
          (x - x4)*((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                     (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                   (-x1 + x4)) + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                      (-x2 + x4)) + (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                    (-x3 + x5))/(-x2 + x5))/(-x1 + x5) + 
             (x - x5)*((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                (-x1 + x3)) + 
                             (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                           (-x1 + x4)) + 
                        (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                           (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                         (-x2 + x5))/(-x1 + x5)) + 
                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                           (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                         (-x2 + x5)) + (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                            (-x3 + x5)) + 
                         (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                       (-x3 + x6))/(-x2 + x6))/(-x1 + x6) + 
                (x - x6)*((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                           (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                              (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                      (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                              (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                         (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6)) + 
                            (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6)) + 
                               (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/(-x5 + x7))
                              /(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7) + 
                   (x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                              (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                            ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                            (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                               (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                  (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                         )/(-x1 + x8) + 
                      ((x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                )/(-x1 + x8)) + 
                           (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                 ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                 (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                              )/(-x2 + x9)))/(-x1 + x9))))) + 
          (x - x3)*((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                     (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                   (-x1 + x4)) + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                      (-x2 + x4)) + (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                    (-x3 + x5))/(-x2 + x5))/(-x1 + x5) + 
             (x - x5)*((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                (-x1 + x3)) + 
                             (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                           (-x1 + x4)) + 
                        (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                           (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                         (-x2 + x5))/(-x1 + x5)) + 
                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                           (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                         (-x2 + x5)) + (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                            (-x3 + x5)) + 
                         (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                       (-x3 + x6))/(-x2 + x6))/(-x1 + x6) + 
                (x - x6)*((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                           (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                              (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                      (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                              (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                         (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6)) + 
                            (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6)) + 
                               (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/(-x5 + x7))
                              /(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7) + 
                   (x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                              (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                            ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                            (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                               (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                  (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                         )/(-x1 + x8) + 
                      ((x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                )/(-x1 + x8)) + 
                           (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                 ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                 (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                              )/(-x2 + x9)))/(-x1 + x9)))) + 
             (x - x4)*((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                (-x1 + x3)) + 
                             (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                           (-x1 + x4)) + 
                        (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                           (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                         (-x2 + x5))/(-x1 + x5)) + 
                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                           (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                         (-x2 + x5)) + (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                            (-x3 + x5)) + 
                         (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                       (-x3 + x6))/(-x2 + x6))/(-x1 + x6) + 
                (x - x6)*((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                           (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                              (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                      (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                              (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                         (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6)) + 
                            (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6)) + 
                               (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/(-x5 + x7))
                              /(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7) + 
                   (x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                              (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                            ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                            (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                               (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                  (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                         )/(-x1 + x8) + 
                      ((x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                )/(-x1 + x8)) + 
                           (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                 ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                 (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                              )/(-x2 + x9)))/(-x1 + x9))) + 
                (x - x5)*((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                           (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                              (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                      (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                              (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                         (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6)) + 
                            (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6)) + 
                               (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/(-x5 + x7))
                              /(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7) + 
                   (x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                              (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                            ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                            (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                               (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                  (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                         )/(-x1 + x8) + 
                      ((x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                )/(-x1 + x8)) + 
                           (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                 ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                 (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                              )/(-x2 + x9)))/(-x1 + x9)) + 
                   (x - x6)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                              (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                            ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                            (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                               (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                  (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                         )/(-x1 + x8) + 
                      ((x - x7)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                )/(-x1 + x8)) + 
                           (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                 ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                 (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                              )/(-x2 + x9)))/(-x1 + x9) + 
                      ((x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                )/(-x1 + x8)) + 
                           (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                 ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                 (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                              )/(-x2 + x9)))/(-x1 + x9)))))) + 
       (x - x1)*((2*(-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
               (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)))/(-x1 + x4) + 
          2*(x - x4)*((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                     (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                   (-x1 + x4)) + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                      (-x2 + x4)) + (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                    (-x3 + x5))/(-x2 + x5))/(-x1 + x5) + 
             (x - x5)*((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                (-x1 + x3)) + 
                             (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                           (-x1 + x4)) + 
                        (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                           (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                         (-x2 + x5))/(-x1 + x5)) + 
                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                           (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                         (-x2 + x5)) + (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                            (-x3 + x5)) + 
                         (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                       (-x3 + x6))/(-x2 + x6))/(-x1 + x6) + 
                (x - x6)*((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                           (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                              (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                      (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                              (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                         (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6)) + 
                            (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6)) + 
                               (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/(-x5 + x7))
                              /(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7) + 
                   (x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                              (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                            ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                            (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                               (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                  (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                         )/(-x1 + x8) + 
                      ((x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                )/(-x1 + x8)) + 
                           (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                 ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                 (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                              )/(-x2 + x9)))/(-x1 + x9))))) + 
          2*(x - x3)*((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                     (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                   (-x1 + x4)) + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                      (-x2 + x4)) + (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                    (-x3 + x5))/(-x2 + x5))/(-x1 + x5) + 
             (x - x5)*((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                (-x1 + x3)) + 
                             (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                           (-x1 + x4)) + 
                        (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                           (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                         (-x2 + x5))/(-x1 + x5)) + 
                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                           (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                         (-x2 + x5)) + (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                            (-x3 + x5)) + 
                         (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                       (-x3 + x6))/(-x2 + x6))/(-x1 + x6) + 
                (x - x6)*((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                           (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                              (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                      (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                              (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                         (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6)) + 
                            (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6)) + 
                               (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/(-x5 + x7))
                              /(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7) + 
                   (x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                              (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                            ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                            (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                               (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                  (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                         )/(-x1 + x8) + 
                      ((x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                )/(-x1 + x8)) + 
                           (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                 ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                 (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                              )/(-x2 + x9)))/(-x1 + x9)))) + 
             (x - x4)*((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                (-x1 + x3)) + 
                             (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                           (-x1 + x4)) + 
                        (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                           (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                         (-x2 + x5))/(-x1 + x5)) + 
                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                           (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                         (-x2 + x5)) + (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                            (-x3 + x5)) + 
                         (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                       (-x3 + x6))/(-x2 + x6))/(-x1 + x6) + 
                (x - x6)*((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                           (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                              (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                      (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                              (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                         (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6)) + 
                            (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6)) + 
                               (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/(-x5 + x7))
                              /(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7) + 
                   (x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                              (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                            ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                            (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                               (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                  (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                         )/(-x1 + x8) + 
                      ((x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                )/(-x1 + x8)) + 
                           (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                 ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                 (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                              )/(-x2 + x9)))/(-x1 + x9))) + 
                (x - x5)*((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                           (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                              (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                      (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                              (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                         (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6)) + 
                            (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6)) + 
                               (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/(-x5 + x7))
                              /(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7) + 
                   (x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                              (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                            ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                            (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                               (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                  (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                         )/(-x1 + x8) + 
                      ((x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                )/(-x1 + x8)) + 
                           (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                 ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                 (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                              )/(-x2 + x9)))/(-x1 + x9)) + 
                   (x - x6)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                              (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                            ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                            (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                               (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                  (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                         )/(-x1 + x8) + 
                      ((x - x7)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                )/(-x1 + x8)) + 
                           (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                 ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                 (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                              )/(-x2 + x9)))/(-x1 + x9) + 
                      ((x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                )/(-x1 + x8)) + 
                           (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                 ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                 (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                              )/(-x2 + x9)))/(-x1 + x9))))) + 
          (x - x2)*((2*(-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                          (-x1 + x3)) + 
                       (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                     (-x1 + x4)) + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                        (-x2 + x4)) + (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                      (-x3 + x5))/(-x2 + x5)))/(-x1 + x5) + 
             2*(x - x5)*((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                (-x1 + x3)) + 
                             (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                           (-x1 + x4)) + 
                        (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                           (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                         (-x2 + x5))/(-x1 + x5)) + 
                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                           (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                         (-x2 + x5)) + (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                            (-x3 + x5)) + 
                         (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                       (-x3 + x6))/(-x2 + x6))/(-x1 + x6) + 
                (x - x6)*((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                           (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                              (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                      (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                              (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                         (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6)) + 
                            (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6)) + 
                               (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/(-x5 + x7))
                              /(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7) + 
                   (x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                              (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                            ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                            (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                               (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                  (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                         )/(-x1 + x8) + 
                      ((x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                )/(-x1 + x8)) + 
                           (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                 ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                 (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                              )/(-x2 + x9)))/(-x1 + x9)))) + 
             2*(x - x4)*((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                (-x1 + x3)) + 
                             (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                           (-x1 + x4)) + 
                        (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                           (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                         (-x2 + x5))/(-x1 + x5)) + 
                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                           (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                         (-x2 + x5)) + (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                            (-x3 + x5)) + 
                         (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                       (-x3 + x6))/(-x2 + x6))/(-x1 + x6) + 
                (x - x6)*((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                           (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                              (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                      (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                              (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                         (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6)) + 
                            (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6)) + 
                               (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/(-x5 + x7))
                              /(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7) + 
                   (x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                              (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                            ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                            (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                               (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                  (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                         )/(-x1 + x8) + 
                      ((x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                )/(-x1 + x8)) + 
                           (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                 ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                 (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                              )/(-x2 + x9)))/(-x1 + x9))) + 
                (x - x5)*((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                           (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                              (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                      (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                              (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                         (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6)) + 
                            (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6)) + 
                               (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/(-x5 + x7))
                              /(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7) + 
                   (x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                              (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                            ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                            (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                               (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                  (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                         )/(-x1 + x8) + 
                      ((x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                )/(-x1 + x8)) + 
                           (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                 ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                 (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                              )/(-x2 + x9)))/(-x1 + x9)) + 
                   (x - x6)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                              (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                            ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                            (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                               (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                  (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                         )/(-x1 + x8) + 
                      ((x - x7)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                )/(-x1 + x8)) + 
                           (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                 ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                 (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                              )/(-x2 + x9)))/(-x1 + x9) + 
                      ((x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                )/(-x1 + x8)) + 
                           (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                 ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                 (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                              )/(-x2 + x9)))/(-x1 + x9)))) + 
             (x - x3)*((2*(-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                  (-x1 + x3)) + 
                               (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))
                              /(-x1 + x4)) + 
                          (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                (-x2 + x4)) + 
                             (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                           (-x2 + x5))/(-x1 + x5)) + 
                     (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                             (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                           (-x2 + x5)) + 
                        (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                           (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                         (-x3 + x6))/(-x2 + x6)))/(-x1 + x6) + 
                2*(x - x6)*((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                           (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                              (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                      (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                              (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                         (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6)) + 
                            (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6)) + 
                               (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/(-x5 + x7))
                              /(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7) + 
                   (x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                              (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                            ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                            (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                               (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                  (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                         )/(-x1 + x8) + 
                      ((x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                )/(-x1 + x8)) + 
                           (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                 ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                 (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                              )/(-x2 + x9)))/(-x1 + x9))) + 
                2*(x - x5)*((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                           (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                              (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                      (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                              (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                         (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6)) + 
                            (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6)) + 
                               (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/(-x5 + x7))
                              /(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7) + 
                   (x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                              (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                            ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                            (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                               (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                  (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                         )/(-x1 + x8) + 
                      ((x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                )/(-x1 + x8)) + 
                           (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                 ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                 (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                              )/(-x2 + x9)))/(-x1 + x9)) + 
                   (x - x6)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                              (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                            ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                            (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                               (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                  (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                         )/(-x1 + x8) + 
                      ((x - x7)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                )/(-x1 + x8)) + 
                           (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                 ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                 (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                              )/(-x2 + x9)))/(-x1 + x9) + 
                      ((x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                )/(-x1 + x8)) + 
                           (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                 ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                 (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                              )/(-x2 + x9)))/(-x1 + x9))) + 
                (x - x4)*((2*(-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                  (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                             (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                        (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                           (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                              (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                 (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                  (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)))/(-x1 + x7)
                     + 2*(x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                              (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                            ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                            (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                               (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                  (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                         )/(-x1 + x8) + 
                      ((x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                )/(-x1 + x8)) + 
                           (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                 ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                 (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                              )/(-x2 + x9)))/(-x1 + x9)) + 
                   2*(x - x6)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                              (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                            ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                            (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                               (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                  (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                         )/(-x1 + x8) + 
                      ((x - x7)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                )/(-x1 + x8)) + 
                           (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                 ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                 (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                              )/(-x2 + x9)))/(-x1 + x9) + 
                      ((x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                )/(-x1 + x8)) + 
                           (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                 ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                 (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                              )/(-x2 + x9)))/(-x1 + x9)) + 
                   (x - x5)*((2*(-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                              ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                              (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                 (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                           ))/(-x1 + x8) + 
                      (2*(x - x6)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                )/(-x1 + x8)) + 
                           (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                 ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                 (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                              )/(-x2 + x9)))/(-x1 + x9) + 
                      (2*(x - x7)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                )/(-x1 + x8)) + 
                           (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                 ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                 (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                              )/(-x2 + x9)))/(-x1 + x9) + 
                      (2*(x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                )/(-x1 + x8)) + 
                           (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                 ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                 (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                                   )/(-x2 + x9)))/(-x1 + x9)))))))
    return result

def third_deriv_9pt(xa, ya, x):
    x1 = xa[0]
    x2 = xa[1]
    x3 = xa[2]
    x4 = xa[3]
    x5 = xa[4]
    x6 = xa[5]
    x7 = xa[6]
    x8 = xa[7]
    x9 = xa[8]
    
    y1 = ya[0]
    y2 = ya[1]
    y3 = ya[2]
    y4 = ya[3]
    y5 = ya[4]
    y6 = ya[5]
    y7 = ya[6]
    y8 = ya[7]
    y9 = ya[8]
    
    result = ((2*(-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
            (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)))/(-x1 + x4) + 
       2*(x - x4)*((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                  (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/(-x1 + x4))\
              + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/(-x2 + x5))/
           (-x1 + x5) + (x - x5)*((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                               (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                          (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                        (-x1 + x4)) + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                           (-x2 + x4)) + 
                        (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                      (-x2 + x5))/(-x1 + x5)) + 
                (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                        (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                      (-x2 + x5)) + (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                         (-x3 + x5)) + (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                       (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6) + 
             (x - x6)*((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                  (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                             (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5))/(-x1 + x5)) + 
                        (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                  (-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5)) + 
                           (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                 (-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5)) + 
                           (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                 (-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6))/(-x2 + x6)) + 
                      (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6)) + 
                         (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6)) + 
                            (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/(-x5 + x7))/
                          (-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7) + 
                (x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                           (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                         ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                         (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                            (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                               (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                  (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                      )/(-x1 + x8) + ((x - x8)*
                      (-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                  (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                             )/(-x1 + x8)) + 
                        (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                              ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                              (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                 (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                           )/(-x2 + x9)))/(-x1 + x9))))) + 
       4*(x - x3)*((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                  (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/(-x1 + x4))\
              + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/(-x2 + x5))/
           (-x1 + x5) + (x - x5)*((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                               (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                          (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                        (-x1 + x4)) + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                           (-x2 + x4)) + 
                        (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                      (-x2 + x5))/(-x1 + x5)) + 
                (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                        (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                      (-x2 + x5)) + (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                         (-x3 + x5)) + (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                       (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6) + 
             (x - x6)*((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                  (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                             (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5))/(-x1 + x5)) + 
                        (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                  (-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5)) + 
                           (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                 (-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5)) + 
                           (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                 (-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6))/(-x2 + x6)) + 
                      (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6)) + 
                         (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6)) + 
                            (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/(-x5 + x7))/
                          (-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7) + 
                (x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                           (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                         ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                         (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                            (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                               (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                  (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                      )/(-x1 + x8) + ((x - x8)*
                      (-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                  (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                             )/(-x1 + x8)) + 
                        (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                              ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                              (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                 (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                           )/(-x2 + x9)))/(-x1 + x9)))) + 
          (x - x4)*((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                             (-x1 + x3)) + 
                          (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                        (-x1 + x4)) + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                           (-x2 + x4)) + 
                        (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                      (-x2 + x5))/(-x1 + x5)) + 
                (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                        (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                      (-x2 + x5)) + (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                         (-x3 + x5)) + (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                       (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6) + 
             (x - x6)*((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                  (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                             (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5))/(-x1 + x5)) + 
                        (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                  (-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5)) + 
                           (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                 (-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5)) + 
                           (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                 (-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6))/(-x2 + x6)) + 
                      (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6)) + 
                         (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6)) + 
                            (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/(-x5 + x7))/
                          (-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7) + 
                (x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                           (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                         ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                         (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                            (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                               (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                  (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                      )/(-x1 + x8) + ((x - x8)*
                      (-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                  (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                             )/(-x1 + x8)) + 
                        (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                              ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                              (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                 (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                           )/(-x2 + x9)))/(-x1 + x9))) + 
             (x - x5)*((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                  (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                             (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5))/(-x1 + x5)) + 
                        (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                  (-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5)) + 
                           (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                 (-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5)) + 
                           (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                 (-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6))/(-x2 + x6)) + 
                      (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6)) + 
                         (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6)) + 
                            (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/(-x5 + x7))/
                          (-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7) + 
                (x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                           (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                         ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                         (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                            (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                               (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                  (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                      )/(-x1 + x8) + ((x - x8)*
                      (-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                  (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                             )/(-x1 + x8)) + 
                        (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                              ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                              (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                 (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                           )/(-x2 + x9)))/(-x1 + x9)) + 
                (x - x6)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                           (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                         ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                         (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                            (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                               (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                  (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                      )/(-x1 + x8) + ((x - x7)*
                      (-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                  (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                             )/(-x1 + x8)) + 
                        (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                              ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                              (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                 (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                           )/(-x2 + x9)))/(-x1 + x9) + 
                   ((x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                  (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                             )/(-x1 + x8)) + 
                        (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                              ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                              (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                 (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                           )/(-x2 + x9)))/(-x1 + x9))))) + 
       3*(x - x2)*((2*(-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                    (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/(-x1 + x4)
                  ) + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                  (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/(-x2 + x5)))
            /(-x1 + x5) + 2*(x - x5)*((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                               (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                          (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                        (-x1 + x4)) + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                           (-x2 + x4)) + 
                        (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                      (-x2 + x5))/(-x1 + x5)) + 
                (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                        (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                      (-x2 + x5)) + (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                         (-x3 + x5)) + (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                       (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6) + 
             (x - x6)*((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                  (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                             (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5))/(-x1 + x5)) + 
                        (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                  (-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5)) + 
                           (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                 (-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5)) + 
                           (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                 (-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6))/(-x2 + x6)) + 
                      (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6)) + 
                         (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6)) + 
                            (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/(-x5 + x7))/
                          (-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7) + 
                (x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                           (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                         ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                         (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                            (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                               (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                  (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                      )/(-x1 + x8) + ((x - x8)*
                      (-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                  (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                             )/(-x1 + x8)) + 
                        (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                              ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                              (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                 (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                           )/(-x2 + x9)))/(-x1 + x9)))) + 
          2*(x - x4)*((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                             (-x1 + x3)) + 
                          (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                        (-x1 + x4)) + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                           (-x2 + x4)) + 
                        (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                      (-x2 + x5))/(-x1 + x5)) + 
                (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                        (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                      (-x2 + x5)) + (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                         (-x3 + x5)) + (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                       (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6) + 
             (x - x6)*((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                  (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                             (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5))/(-x1 + x5)) + 
                        (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                  (-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5)) + 
                           (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                 (-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5)) + 
                           (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                 (-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6))/(-x2 + x6)) + 
                      (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6)) + 
                         (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6)) + 
                            (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/(-x5 + x7))/
                          (-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7) + 
                (x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                           (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                         ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                         (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                            (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                               (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                  (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                      )/(-x1 + x8) + ((x - x8)*
                      (-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                  (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                             )/(-x1 + x8)) + 
                        (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                              ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                              (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                 (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                           )/(-x2 + x9)))/(-x1 + x9))) + 
             (x - x5)*((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                  (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                             (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5))/(-x1 + x5)) + 
                        (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                  (-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5)) + 
                           (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                 (-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5)) + 
                           (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                 (-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6))/(-x2 + x6)) + 
                      (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6)) + 
                         (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6)) + 
                            (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/(-x5 + x7))/
                          (-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7) + 
                (x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                           (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                         ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                         (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                            (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                               (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                  (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                      )/(-x1 + x8) + ((x - x8)*
                      (-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                  (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                             )/(-x1 + x8)) + 
                        (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                              ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                              (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                 (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                           )/(-x2 + x9)))/(-x1 + x9)) + 
                (x - x6)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                           (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                         ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                         (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                            (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                               (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                  (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                      )/(-x1 + x8) + ((x - x7)*
                      (-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                  (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                             )/(-x1 + x8)) + 
                        (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                              ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                              (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                 (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                           )/(-x2 + x9)))/(-x1 + x9) + 
                   ((x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                  (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                             )/(-x1 + x8)) + 
                        (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                              ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                              (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                 (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                           )/(-x2 + x9)))/(-x1 + x9)))) + 
          (x - x3)*((2*(-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                               (-x1 + x3)) + 
                            (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                          (-x1 + x4)) + 
                       (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                          (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                        (-x2 + x5))/(-x1 + x5)) + 
                  (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                          (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                        (-x2 + x5)) + (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                           (-x3 + x5)) + 
                        (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                      (-x3 + x6))/(-x2 + x6)))/(-x1 + x6) + 
             2*(x - x6)*((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                  (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                             (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5))/(-x1 + x5)) + 
                        (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                  (-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5)) + 
                           (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                 (-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5)) + 
                           (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                 (-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6))/(-x2 + x6)) + 
                      (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6)) + 
                         (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6)) + 
                            (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/(-x5 + x7))/
                          (-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7) + 
                (x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                           (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                         ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                         (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                            (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                               (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                  (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                      )/(-x1 + x8) + ((x - x8)*
                      (-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                  (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                             )/(-x1 + x8)) + 
                        (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                              ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                              (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                 (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                           )/(-x2 + x9)))/(-x1 + x9))) + 
             2*(x - x5)*((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                  (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                             (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5))/(-x1 + x5)) + 
                        (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                  (-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5)) + 
                           (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                 (-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5)) + 
                           (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                 (-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6))/(-x2 + x6)) + 
                      (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6)) + 
                         (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6)) + 
                            (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/(-x5 + x7))/
                          (-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7) + 
                (x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                           (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                         ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                         (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                            (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                               (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                  (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                      )/(-x1 + x8) + ((x - x8)*
                      (-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                  (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                             )/(-x1 + x8)) + 
                        (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                              ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                              (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                 (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                           )/(-x2 + x9)))/(-x1 + x9)) + 
                (x - x6)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                           (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                         ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                         (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                            (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                               (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                  (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                      )/(-x1 + x8) + ((x - x7)*
                      (-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                  (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                             )/(-x1 + x8)) + 
                        (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                              ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                              (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                 (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                           )/(-x2 + x9)))/(-x1 + x9) + 
                   ((x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                  (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                             )/(-x1 + x8)) + 
                        (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                              ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                              (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                 (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                           )/(-x2 + x9)))/(-x1 + x9))) + 
             (x - x4)*((2*(-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                               (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                  (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                          (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                  (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                             (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6)
                                )/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                     (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                  (-x2 + x4)) + 
                                  (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                             (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6)
                                )/(-x3 + x6))/(-x2 + x6)) + 
                        (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                  (-x3 + x5)) + 
                                (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6)
                                )/(-x3 + x6)) + 
                           (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                 (-x4 + x6)) + 
                              (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/(-x5 + x7))/
                            (-x4 + x7))/(-x3 + x7))/(-x2 + x7)))/(-x1 + x7) + 
                2*(x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                           (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                         ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                         (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                            (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                               (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                  (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                      )/(-x1 + x8) + ((x - x8)*
                      (-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                  (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                             )/(-x1 + x8)) + 
                        (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                              ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                              (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                 (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                           )/(-x2 + x9)))/(-x1 + x9)) + 
                2*(x - x6)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                           (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                         ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                         (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                            (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                               (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                  (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                      )/(-x1 + x8) + ((x - x7)*
                      (-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                  (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                             )/(-x1 + x8)) + 
                        (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                              ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                              (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                 (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                           )/(-x2 + x9)))/(-x1 + x9) + 
                   ((x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                  (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                             )/(-x1 + x8)) + 
                        (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                              ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                              (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                 (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                           )/(-x2 + x9)))/(-x1 + x9)) + 
                (x - x5)*((2*(-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                  (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                             (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                           ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                           (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                              (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                 (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                        ))/(-x1 + x8) + 
                   (2*(x - x6)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                  (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                             )/(-x1 + x8)) + 
                        (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                              ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                              (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                 (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                           )/(-x2 + x9)))/(-x1 + x9) + 
                   (2*(x - x7)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                  (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                             )/(-x1 + x8)) + 
                        (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                              ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                              (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                 (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                           )/(-x2 + x9)))/(-x1 + x9) + 
                   (2*(x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                  (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                             )/(-x1 + x8)) + 
                        (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                              ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                              (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                 (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                           )/(-x2 + x9)))/(-x1 + x9))))) + 
       2*((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
             (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/(-x1 + x4) + 
          (x - x4)*((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                     (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                   (-x1 + x4)) + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                      (-x2 + x4)) + (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                    (-x3 + x5))/(-x2 + x5))/(-x1 + x5) + 
             (x - x5)*((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                (-x1 + x3)) + 
                             (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                           (-x1 + x4)) + 
                        (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                           (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                         (-x2 + x5))/(-x1 + x5)) + 
                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                           (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                         (-x2 + x5)) + (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                            (-x3 + x5)) + 
                         (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                       (-x3 + x6))/(-x2 + x6))/(-x1 + x6) + 
                (x - x6)*((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                           (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                              (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                      (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                              (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                         (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                 (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6))/(-x3 + x6)) + 
                            (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                  (-x4 + x6)) + 
                               (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/(-x5 + x7))
                              /(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7) + 
                   (x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                              (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                            ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                 (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                            (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                               (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                  (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                         )/(-x1 + x8) + 
                      ((x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                   ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                )/(-x1 + x8)) + 
                           (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                   (-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                                 ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                                 (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                   (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                              )/(-x2 + x9)))/(-x1 + x9)))))) + 
       (x - x1)*((2*(-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                    (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/(-x1 + x4)
                  ) + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                  (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/(-x2 + x5)))
            /(-x1 + x5) + 2*(x - x5)*((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                               (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                          (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                        (-x1 + x4)) + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                           (-x2 + x4)) + 
                        (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                      (-x2 + x5))/(-x1 + x5)) + 
                (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                        (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                      (-x2 + x5)) + (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                         (-x3 + x5)) + (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                       (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6) + 
             (x - x6)*((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                  (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                             (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5))/(-x1 + x5)) + 
                        (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                  (-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5)) + 
                           (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                 (-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5)) + 
                           (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                 (-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6))/(-x2 + x6)) + 
                      (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6)) + 
                         (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6)) + 
                            (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/(-x5 + x7))/
                          (-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7) + 
                (x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                           (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                         ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                         (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                            (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                               (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                  (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                      )/(-x1 + x8) + ((x - x8)*
                      (-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                  (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                             )/(-x1 + x8)) + 
                        (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                              ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                              (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                 (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                           )/(-x2 + x9)))/(-x1 + x9)))) + 
          4*(x - x4)*((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                             (-x1 + x3)) + 
                          (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                        (-x1 + x4)) + (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                           (-x2 + x4)) + 
                        (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                      (-x2 + x5))/(-x1 + x5)) + 
                (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                        (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                      (-x2 + x5)) + (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                         (-x3 + x5)) + (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                       (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6) + 
             (x - x6)*((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                  (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                             (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5))/(-x1 + x5)) + 
                        (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                  (-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5)) + 
                           (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                 (-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5)) + 
                           (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                 (-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6))/(-x2 + x6)) + 
                      (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6)) + 
                         (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6)) + 
                            (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/(-x5 + x7))/
                          (-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7) + 
                (x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                           (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                         ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                         (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                            (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                               (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                  (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                      )/(-x1 + x8) + ((x - x8)*
                      (-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                  (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                             )/(-x1 + x8)) + 
                        (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                              ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                              (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                 (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                           )/(-x2 + x9)))/(-x1 + x9))) + 
             (x - x5)*((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                  (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                             (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5))/(-x1 + x5)) + 
                        (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                  (-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5)) + 
                           (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                 (-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5)) + 
                           (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                 (-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6))/(-x2 + x6)) + 
                      (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6)) + 
                         (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6)) + 
                            (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/(-x5 + x7))/
                          (-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7) + 
                (x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                           (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                         ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                         (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                            (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                               (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                  (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                      )/(-x1 + x8) + ((x - x8)*
                      (-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                  (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                             )/(-x1 + x8)) + 
                        (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                              ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                              (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                 (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                           )/(-x2 + x9)))/(-x1 + x9)) + 
                (x - x6)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                           (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                         ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                         (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                            (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                               (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                  (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                      )/(-x1 + x8) + ((x - x7)*
                      (-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                  (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                             )/(-x1 + x8)) + 
                        (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                              ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                              (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                 (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                           )/(-x2 + x9)))/(-x1 + x9) + 
                   ((x - x8)*(-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + 
                                   (-y2 + y3)/(-x2 + x3))/(-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                  (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                                ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                             )/(-x1 + x8)) + 
                        (-((-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                                (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                              ) + (-((-((-((-((-((-y3 + y4)/(-x3 + x4)) + 
                                   (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                   (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                                   (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8)) + 
                              (-((-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                                   (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8)) + 
                                 (-((-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                   (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8)) + 
                                   (-((-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8)) + 
                                   (-((-y7 + y8)/(-x7 + x8)) + (-y8 + y9)/(-x8 + x9))/
                                   (-x7 + x9))/(-x6 + x9))/(-x5 + x9))/(-x4 + x9))/(-x3 + x9)
                           )/(-x2 + x9)))/(-x1 + x9)))) + 
          3*(x - x3)*((2*(-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                               (-x1 + x3)) + 
                            (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4))/
                          (-x1 + x4)) + 
                       (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                          (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                        (-x2 + x5))/(-x1 + x5)) + 
                  (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                          (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5))/
                        (-x2 + x5)) + (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                           (-x3 + x5)) + 
                        (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                      (-x3 + x6))/(-x2 + x6)))/(-x1 + x6) + 
             2*(x - x6)*((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                  (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                             (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5))/(-x1 + x5)) + 
                        (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                  (-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5)) + 
                           (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                 (-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                   (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)
                                )/(-x2 + x5)) + 
                           (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                 (-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6))/(-x2 + x6)) + 
                      (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/(-x3 + x5)) + 
                              (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6))/
                            (-x3 + x6)) + 
                         (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/(-x4 + x6)) + 
                            (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/(-x5 + x7))/
                          (-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7) + 
                (x - x7)*((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                           (-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7))/(-x1 + x7)
                         ) + (-((-((-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                              (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7))/(-x2 + x7)) + 
                         (-((-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                                 (-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7))/(-x3 + x7)) + 
                            (-((-((-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6)) + 
                                   (-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7))/(-x4 + x7)) + 
                               (-((-((-y5 + y6)/(-x5 + x6)) + (-y6 + y7)/(-x6 + x7))/
                                   (-x5 + x7)) + 
                                  (-((-y6 + y7)/(-x6 + x7)) + (-y7 + y8)/(-x7 + x8))/
                                   (-x6 + x8))/(-x5 + x8))/(-x4 + x8))/(-x3 + x8))/(-x2 + x8)
                      )/(-x1 + x8) + ((x - x8)*
                      (-((-((-((-((-((-((-((-y1 + y2)/(-x1 + x2)) + (-y2 + y3)/(-x2 + x3))/
                                   (-x1 + x3)) + 
                                   (-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4))/(-x1 + x4)) + 
                                   (-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5))/(-x1 + x5)) + 
                                   (-((-((-((-y2 + y3)/(-x2 + x3)) + (-y3 + y4)/(-x3 + x4))/
                                   (-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6))/(-x1 + x6)) + 
                                  (-((-((-((-((-y2 + y3)/(-x2 + x3)) + 
                                   (-y3 + y4)/(-x3 + x4))/(-x2 + x4)) + 
                                   (-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5))/(-x2 + x5)) + 
                                   (-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6))/(-x2 + x6)) + 
                                   (-((-((-((-y3 + y4)/(-x3 + x4)) + (-y4 + y5)/(-x4 + x5))/
                                   (-x3 + x5)) + 
                                   (-((-y4 + y5)/(-x4 + x5)) + (-y5 + y6)/(-x5 + x6))/
                                   (-x4 + x6))/(-x3 + x6)) + 
                               