/*-----------------------------------------------------------------------
QMBTagger - Qt Based MusicBrainz MP3/OGG/FLAC Tagger
Copyright (C) 2003,2004 Ewen Cheslack-Postava
 
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-----------------------------------------------------------------------*/
//This is a class to abstract the FLAC file stuff.  It's main function is
//to get the raw pcm stream out of the FLAC file so we can get the trm id.

#ifndef _QMBFLACFILE_H_
#define _QMBFLACFILE_H_

#if HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#if HAVE_LIBMUSICBRAINZ
#if HAVE_FLAC

#include "qmbfile.h"
#include <qstring.h>
#include <FLAC++/decoder.h>

class QMBFLACFile : public QMBFile, public FLAC::Decoder::File {
public:
    QMBFLACFile();
    //  ~QMBFLACFile();

    virtual int Extract(QString filename);


    // from FLAC::Decoder::File
    ::FLAC__StreamDecoderWriteStatus write_callback(const ::FLAC__Frame *frame, const FLAC__int32 * const writebuffer[]);
    void metadata_callback(const ::FLAC__StreamMetadata *metadata);
    void error_callback(::FLAC__StreamDecoderErrorStatus status);

private:
    unsigned int offset;
    bool decode_error;
    unsigned int max_block_size;
};

#endif /* HAVE_FLAC */
#endif /*HAVE_LIBMUSICBRAINZ*/
#endif //define _QMBFLACFILE_H_
