/***************************************************************************
                          lvi_musicbrainzresult.cpp  -  description
                             -------------------
    begin                : 2004-10-21
    copyright            : (C) 2004 by Christian Mller
    email                : cmueller@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "lvi_musicbrainzresult.h"

#include <qpixmap.h>
#include <qpainter.h>
#include <sstream>

#include "tagger.h"

using namespace std;

// ##################################################
// # constructor
// ##################################################
LVI_MusicBrainzResult::LVI_MusicBrainzResult(QListView *_parent, TRACK *_track)
: QListViewItem(_parent), track(_track) {
    QString s;
    setText(LVI_MusicBrainzResult::ArtistColumn, track->artist);
    setText(LVI_MusicBrainzResult::TitleColumn,  track->title);
    setText(LVI_MusicBrainzResult::LengthColumn, s.sprintf("%d:%02d ", track->length/60, track->length%60));

    updateAlbumColumn(track->album, track->tracknumber);

    setDragEnabled(true);
}


void LVI_MusicBrainzResult::updateAlbumColumn(const QString & _album, int _tracknumber) {
    QString s("[%1]");
    if(_tracknumber == 0) {
        setText(LVI_MusicBrainzResult::AlbumColumn, _album);
    } else {
        setText(LVI_MusicBrainzResult::AlbumColumn, _album +  s.arg( _tracknumber, 2 ) );
    }
}


// #################################################
// Non-default sorting for track length
// #################################################
int LVI_MusicBrainzResult::compare(QListViewItem *i, int col, bool ascending) const {
    LVI_MusicBrainzResult *otherItem = dynamic_cast<LVI_MusicBrainzResult *>(i);

    int ret = 0;
    if (col == LVI_MusicBrainzResult::LengthColumn) {
    // compare length in seconds, not the string representation mm:ss
    ret = getLength() - otherItem->getLength();
    } else {
        // use default implementation
        ret = QListViewItem::compare(i, col, ascending);
    }

    return ret;
}


// ##################################################
// # destructor
// ##################################################
LVI_MusicBrainzResult::~LVI_MusicBrainzResult() {
    delete track;
}
