/***************************************************************************
                          lvi_musicbrainzresult.cpp  -  description
                             -------------------
    begin                : 2004-10-21
    copyright            : (C) 2004 by Christian Mller
    email                : cmueller@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LVI_MUSICBRAINZRESULT_H
#define LVI_MUSICBRAINZRESULT_H

#include <qlistview.h>

#include "prokyon.h"

/**
 * This class is used as listview item in the MusicBrainz dialog. It displays 
 * a single result row returned by the MusicBrainz server. 
 * 
 * @author Christian Mueller <cmueller@users.sourceforge.net>
 * @short MusicBrainz result listview item
 */
class LVI_MusicBrainzResult : public QListViewItem  {
 public: 
   /** 
    * @param _parent A pointer to the parent QListView.
    * @param _track This parameter contains all the data to initialize the 
    *               list view item. This class takes responsibility of the 
    *               deletion.
    */
  LVI_MusicBrainzResult(QListView *_parent, TRACK *_track);
  
  ~LVI_MusicBrainzResult();
  
  void setAlbum(QString);
  void setTracknumber(int);

  QString getArtist()  const { return track->artist; };
  QString getTitle()   const { return track->title; }
  QString getAlbum()   const { return track->album; }
  int getTracknumber() const { return track->tracknumber; }
  int getLength()      const { return track->length; }
  
  /**
   * TODO: This method gives out a pointer to the data container this class
   * is resonsible for and may delete at any time. This is a potential problem
   * and should be fixed in all the LVI classes that have such method. 
   */
  TRACK *getOriginalTrack() { return track; }
  
  /** This enum contains the index of each column of the result list. 
   * This way the user does not have to bother with numerical indexes. */
  enum ColumnIndex { ArtistColumn, TitleColumn, LengthColumn, AlbumColumn }; 
  
protected:
  int compare(QListViewItem* i, int col, bool ascending) const;

private:
  TRACK* track;

  void updateAlbumColumn(const QString & _album, int _tracknumber);
};

#endif
