/***************************************************************************
                          lvi_nfsexport.h  -  description
                             -------------------
    begin                : Wed Feb 27 2002
    copyright            : (C) 2002 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LVI_NFSEXPORT_H
#define LVI_NFSEXPORT_H

#include "prokyon.h"

#include <qlistview.h>

class LVI_NFSExport : public QListViewItem  {
 public: 
  LVI_NFSExport(QListView *parent, int _exportID, QString _path, QString _export);
  
  void lock(QString comment);
  void unlock();
  
  void applyMount();
  void applyUnmount();
  
  void applyInfo(int);

  int getExportID() { return exportID; }

  int getMediumID() { return medium; }

  bool getIsLocked() { return isLocked; }
  bool getIsMounted() { return isMounted; }
  bool getIsKnown() { return medium != -1; }

  QString getPath() { return path; }
  QString getDevice() { return device; }
  QString getLabel() { return label; }
  
 private:
  int exportID;

  int medium;

  QString path;
  QString Export;
  QString device;
  QString label;

  bool isLocked;
  bool isMounted;
  bool isKnown;
};

#endif
