/***************************************************************************
                  job_modifyplaylist_tracks.cpp  -  description
                             -------------------
    begin                : Wed May 9 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de

    Contributed by Tim Lee ;-)
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "job_modifyplaylist_tracks.h"

#include "job_disconnectfromdatabase.h"

#include "jobmanager.h"
#include "database.h"
#include "datadispatcher.h"

#include "gui.h"

#include <iostream>

//appending
Job_ModifyPlaylist_Tracks::Job_ModifyPlaylist_Tracks(int _mode, QList<TRACK> *_list, int _playlistID)
  : mode(_mode), list(_list),  pl_track_list(0), playlistID(_playlistID), position(-1)
{}

// moving
Job_ModifyPlaylist_Tracks::Job_ModifyPlaylist_Tracks(int _mode, LVI_PlaylistTrack *_lvi_pl_track, int _position)
  : mode(_mode), position(_position), lvi_pl_track(_lvi_pl_track)
{}

// save track positions
Job_ModifyPlaylist_Tracks::Job_ModifyPlaylist_Tracks(int _mode, int _playlistID, QList<int> *_positionlist)
	: mode(_mode), positionlist(_positionlist), playlistID(_playlistID)
{}

// deleting or appending to currently playing playlist
Job_ModifyPlaylist_Tracks::Job_ModifyPlaylist_Tracks(int _mode, QList<LVI_PlaylistTrack> *_pl_track_list)
  : mode(_mode), pl_track_list(_pl_track_list)
{}

void Job_ModifyPlaylist_Tracks::run()
{
  int error, ID;

  database->lock();
  app->lock();

  if(mode == APPEND_PLAYLIST_TRACK)
    ID = database->appendPlaylistTracks(list, playlistID, &position);
//  else if(mode == UPDATE_PLAYLIST_TRACK) {
//    database->updatePlaylistTrack(lvi_pl_track->getPlaylistID(),
//				  lvi_pl_track->getTrackID(),
//				  position);
//  }
  else if(mode == DELETE_PLAYLIST_TRACK) {
    QList<PLAYLIST_TRACK> temp_pl_track_list;
    for(LVI_PlaylistTrack *iter = pl_track_list->first(); iter != 0; iter = pl_track_list->next())
      temp_pl_track_list.append(iter->getPlaylistTrack());

    database->deletePlaylistTracks(&temp_pl_track_list);
  }
  else if(mode == APPEND_TO_CURRENT) {
	QList<TRACK> *temp_list = new QList<TRACK>;
	for(LVI_PlaylistTrack *iter = pl_track_list->first(); iter != 0; iter = pl_track_list->next()) {
	  TRACK *temptrack = new TRACK();
	  temptrack->id = iter->getTrackID();
	  temp_list->append(temptrack);
	}
	ID = database->appendPlaylistTracks(temp_list,0,0);
	delete temp_list;
  }
  else if(mode == SAVE_POSITIONS) {
  	for(int *trackID = positionlist->first(), pos = 0; trackID != 0; trackID = positionlist->next(), ++pos) {
  		database->updatePlaylistTrack(playlistID, *trackID, pos);
  		}
	delete positionlist;
  }

  error = database->getError();

  if(!error) {
    if(mode == APPEND_PLAYLIST_TRACK) {
      int temppos = position;
      for (TRACK *it = list->first(); it != 0; it = list->next()) {
        PLAYLIST_TRACK *p_track = new PLAYLIST_TRACK();
        p_track->id                   = ++ID;
		p_track->track_id             = it->id;
		p_track->medium_id			  = it->medium;
		p_track->playlist_id          = playlistID;
		p_track->position_in_playlist = temppos++;
		p_track->artist               = it->artist;
		p_track->title                = it->title;
		p_track->path				 = it->path;
		p_track->filename             = it->filename;
        datadispatcher->eventNewPlaylistTrack(p_track, playlistID);
      }
    }
//    else if(mode == UPDATE_PLAYLIST_TRACK) {
//      lvi_pl_track->setPlaylistPosition(position);
//      datadispatcher->eventMovePlaylistTrack();
//    }
    else if(mode == DELETE_PLAYLIST_TRACK) {
      datadispatcher->eventNewPlaylistTracksBasis(database->getPlaylistTracksBasis(0),0);
      int ID = gui->getPlaylisting()->getDisplayedPlaylistID();
      if(ID > 0) datadispatcher->eventNewPlaylistTracksBasis(database->getPlaylistTracksBasis(ID),ID);
    }
	else if(mode == APPEND_TO_CURRENT) {
	  datadispatcher->eventNewPlaylistTracksBasis(database->getPlaylistTracksBasis(0),0);
	}
  }

  app->unlock();
  database->unlock();
  
  jobman->lock();
  jobman->jobDone(this);
  jobman->unlock();
  exit();
}

Job_ModifyPlaylist_Tracks::~Job_ModifyPlaylist_Tracks() {}
