/***************************************************************************
                          configuration.h  -  description
                             -------------------
    begin                : Wed May 9 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONFIGURATION_H
#define CONFIGURATION_H

#include "prokyon.h"

#include <qthread.h>
#include <qptrlist.h>
#include <qstringlist.h>
#include <qsettings.h>
#include <qvaluelist.h>

class Configuration {
  friend class Configuration_Dialog;
  friend class Database_Create_Dialog;
 public: 
  Configuration();

  void lock() { mutex.lock(); }
  void unlock() { mutex.unlock(); }
	
  void showConfigurationDialog();

  QString getHOST() { return db_host; }
  QString getDATABASE() { return db_database; }
  QString getUSER() { return db_user; }
  QString getPASS() { return db_pass; }

  QStringList getUserDirectories() { return mp3dirs; }
	
  int getStartupTip() { return startuptip; }
  int getAutoConnect() { return autoconn; }
  int getAutoHide() { return autohide; }

  QString getPlayCmd() { return playcmd; }
  QString getEnqueueCmd() { return enqueuecmd; }
  QString getBurnCDCmd() { return burnCDcmd; }
	
  int getAvoidHDD() { return avoidhdd; }
  int getAvoidSMB() { return avoidsmb; }
  int getAvoidNFS() { return avoidnfs; }

  int getAllowGuiRestore() { return allowguirestore; }

  int getposx() { return posx; }
  int getposy() { return posy; }
  int getwidth() { return width; }
  int getheight() { return height; }

  void setposx( int _posx ) { posx = _posx; }
  void setposy( int _posy ) { posy = _posy; }
  void setwidth( int _width ) { width = _width; }
  void setheight( int _height ) { height = _height; }

  int gettoggleleft() { return toggleleft; }
  int gettoggleright() { return toggleright; }
  int gettogglebottom() { return togglebottom; }

  void settoggleleft( int _toggleleft ) { toggleleft = _toggleleft; }
  void settoggleright( int _toggleright ) { toggleright = _toggleright; }
  void settogglebottom( int _togglebottom ) { togglebottom = _togglebottom; }

  int getShowToolTip() { return showtooltip; }
  void setShowToolTip( int );

  bool readID3v2() { return readid3v2==1; }
  bool writeID3v2() { return writeid3v2==1; }

  bool readInfo_Length() { return info_Length==1; } 
  bool readInfo_Media() { return info_Media==1; } 
  bool readInfo_Bitrate() { return info_Bitrate==1; } 
  bool readInfo_Album() { return info_Album==1; } 
  bool readInfo_Comment() { return info_Comment==1; } 
  bool readInfo_Year() { return info_Year==1; } 
  bool readInfo_Genre() { return info_Genre==1; } 
  bool readInfo_Path() { return info_Path==1; } 
  bool readInfo_Filename() { return info_Filename==1; } 

  int readinfo_radiostate() { return info_radiostate; } 

  QStringList& getinfo_columnwidth() { return info_columnwidth; }
  QStringList& getinfo_columnmap() { return info_columnmap; }
  
  QValueList<int> getinfo_guisize(); 
  QValueList<int> getinfo_guisizer(); 
  QValueList<int> getinfo_guisizel(); 
  QValueList<int> getinfo_guisizem(); 

  void  setinfo_guisize( QValueList<int> _info_guisize);
  void  setinfo_guisizer( QValueList<int> _info_guisizer);
  void  setinfo_guisizel( QValueList<int> _info_guisizel);
  void  setinfo_guisizem( QValueList<int> _info_guisizem);

  int getMaxWidthMode() { return maxwidthmode; }
  void setMaxWidthMode( int _maxwidthmode) { maxwidthmode = _maxwidthmode; }

  ~Configuration();

 private:
  QValueList<int> Configuration::listString2Int( QStringList qs);
  QStringList Configuration::listInt2String( QValueList<int> qi);
  int startuptip, readid3v2, writeid3v2, autoconn, autohide, avoidhdd, avoidsmb, avoidnfs;
  int allowguirestore, showtooltip;
  QMutex mutex;

  QSettings *settings;
  QString db_host, db_database, db_user, db_pass, playcmd, enqueuecmd, burnCDcmd;
  QStringList mp3dirs;

  int posx, posy, width, height;

  int info_Length, info_Media, info_Bitrate, info_Album, info_Comment, info_Year, info_Genre, info_Path, info_Filename;
  int info_radiostate; 

  QStringList info_columnwidth;
  QStringList info_columnmap;
  QStringList info_guisize,info_guisizer,info_guisizel,info_guisizem;
  int maxwidthmode;

  bool toggleleft, toggleright, togglebottom;

};

#endif








