#!/usr/bin/perl -w	

##############################################################################
#
# Print billing management system - web tools, version 4.1.1
#
# Copyright (C) 2000, 2001, 2002 Daniel Franklin
#
# This program is distributed under the terms of the GNU General Public
# License Version 2.
#
# This CGI script allows users to check their quota via the web.
#
##############################################################################

use POSIX;
use Printbill::printbill_pcfg;
use strict;

my $query = $ENV{'QUERY_STRING'};
my $request_method = $ENV{'REQUEST_METHOD'};
my (%queries, $config, %params, $quota, %formdata);
&parse_query_data (\%queries, $query);

$config = "/etc/printbill/printbillrc";
%params = pcfg ($config);

print "Content-type: text/html\n\n";

print `/bin/cat $params{'web_header'}`;

if ($? != 0) {
	&return_error (500, "CGI Error",
		"$0: cannot read web header file $params{'web_header'}\n");
}

if ($request_method eq "POST") {
	&parse_form_data (\%formdata);
	&setup_user_page ($formdata{'username'});
} else {
	&setup_user_check ();
}

print `/bin/cat $params{'web_footer'}`;

if ($? != 0) {
	&return_error (500, "CGI Error",
		"$0: cannot read web footer file $params{'web_footer'}\n");
}

exit (0);

sub parse_query_data
{
	my ($query_data, $command) = @_;
	my (@key_value_pairs, $key_value, $key, $value);

	@key_value_pairs = split (/&/, $command);
	
	foreach $key_value (@key_value_pairs) {
		($key, $value) = split (/=/, $key_value);
		$value =~ tr/+/ /;
		$value =~ s/%([\dA-Fa-f][\dA-Fa-f])/pack ("C", hex ($1))/eg;
		
		$$query_data{$key} = $value;
	}
}

sub parse_form_data
{
	my ($form_data) = @_;
	my ($post_info, @key_value_pairs, $key_value, $key, $value);
	
	read (STDIN, $post_info, $ENV{'CONTENT_LENGTH'});

	@key_value_pairs = split (/&/, $post_info);
	
	foreach $key_value (@key_value_pairs) {
		($key, $value) = split (/=/, $key_value);
		$value =~ tr/+/ /;
		$value =~ s/%([\dA-Fa-f][\dA-Fa-f])/pack ("C", hex ($1))/eg;
		$value =~ s/;//g;

		$$form_data{$key} = $value;
	}
}

sub return_error
{
	my ($status, $keyword, $message) = @_;

	print "<title>CGI Program - Unexpected Error</title>";
	print "<h1>$keyword</h1><hr>$message<hr>";
	print "Status: $status $keyword\n\n";
	print "</body></html>";

	exit 1;
}

sub setup_user_check
{
	# setup header information
	print `/bin/cat $params{'web_message_text'}` ||
		&return_error (500, "CGI Error",
		"$0: cannot read web message text file $params{'web_message_text'}: $!");
	
	print "<center><h2>Print Quota System</h2></center>\n";

	print "<hr>\n";
	print "<form action=\"$params{'check_cgi'}\" method=\"POST\">\n";
	print "Please enter your username:<br><br>\n";
	print "<center><table border=0>\n";
	print "<tr><td width=100 align=left>Username:</td><td width=100 align=right><input type=\"text\" name=\"username\" SIZE=\"10\"></td></tr>\n";
	print "<tr><td align=left><input type=\"submit\" value=\"Submit\"></td>\n";
	print "<td align=right><input type=\"reset\" value=\"Reset\">\n";
	print "<input type=\"hidden\" name=\"ftype\" value=\"usercheck\"></td></tr>\n";
	print "</table></center>\n";
	print "<hr></form>\n";
}

sub setup_user_page
{
	my ($user) = @_;
	my ($pages, $spent, $quota, $answer);

	print `/bin/cat $params{'web_message_text'}` ||
		&return_error (500, "CGI Error",
		"$0: cannot read web message text file $params{'web_message_text'}: $!");
	
	print "<center><h2>Print Quota User Page</h2></center>\n";
	print "<hr>\n";

	print "<p><center><table cellpadding=2 cellspacing=2 border=1>\n";

	print "<thead><td><b>Username</b></td>\n";
	print "<td><b>Quota Remaining</b></td>\n";
	print "<td><b>Total spent</b></td>\n";
	print "<td><b>Pages Printed</b></td>\n";
	print "</thead>\n";
	
	print "<tbody>";
	
	$user =~ s/\'/\\\'/g;

	$answer = `$params{'admin_prog_path'}/pqm --display \'$user\' --web 2>&1`;

	if ($? != 0) {
		&return_error (500, "CGI Error",
			"$0: cannot execute $params{'admin_prog_path'}/pqm --display \'$user\' --web: $answer");
	} else {
		$quota = $answer;
	}

	$answer = `$params{'admin_prog_path'}/pqm --pages \'$user\' --web 2>&1`;

	if ($? != 0) {
		&return_error (500, "CGI Error",
			"$0: cannot execute $params{'admin_prog_path'}/pqm --pages \'$user\' --web: $answer");
	} else {
		$pages = $answer;
	}

	$answer = `$params{'admin_prog_path'}/pqm --spent \'$user\' --web 2>&1`;

	if ($? != 0) {
		&return_error (500, "CGI Error",
			"$0: cannot execute $params{'admin_prog_path'}/pqm --spent \'$user\' --web: $answer");
	} else {
		$spent = $answer;
	}

# Attempt to make the resulting HTML a bit more readable...
		
	chop $quota;
	chop $pages;
	chop $spent;
		
	print "<tr><td>$user</td>\n<td>$quota</td>\n";
	print "<td>$spent</td>\n<td>$pages</td>\n</tr>";
	print "</tbody></table></center>\n";

	print "<center>\n";
	print "<form action=\"$params{'check_cgi'}\" method=\"POST\">\n";
	print "<input type=\"submit\" value=\"Reload\">\n";
	print "<input type=\"hidden\" name=\"ftype\" value=\"usercheck\">\n";
	print "<input type=\"hidden\" name=\"username\" value=\"$user\">\n";
	print "</form></center>\n";

	print `/bin/cat $params{'extra_quota_message'}`;
	
	if ($? != 0) {
		&return_error (500, "CGI Error",
			"$0: cannot read extra quota message file $params{'extra_quote_message'}: $!");
	}
}
