//
//  PRBriCon.m
//  PRICE
//
//  Created by Riccardo Mottola on Thu Mar 3 2005.
//  Copyright (c) 2005 Carduus. All rights reserved.
//
// This application is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

#include <math.h>
#import <AppKit/AppKit.h>

#include <limits.h>
#define HALF_CHAR (UCHAR_MAX >> 1)

#import "PRBriCon.h"


@implementation PRBriCon

- (PRImage *)adjustImage :(PRImage *)srcImage :(int)bri :(float)con
{
    NSBitmapImageRep *srcImageRep;
    PRImage *destImage;
    NSBitmapImageRep *destImageRep;
    int w, h;
    int x, y;
    unsigned char *srcData;
    unsigned char *destData;
    int bytesPerPixel;
    int pixNum;
    BOOL isColor;
    int tempValue;

    /* get source image representation and associated information */
    srcImageRep = [srcImage tiffRep];
    
    w = [srcImageRep pixelsWide];
    h = [srcImageRep pixelsHigh];
    pixNum = h * w;
    printf("pixels: %d\n", pixNum);
    bytesPerPixel = [srcImageRep bitsPerPixel] /8;
    
    /* check bith depth and color/greyscale image */
    if ([srcImageRep hasAlpha])
    {
        if ([srcImageRep samplesPerPixel] == 2)
        {
            printf("Grayscale image\n");
            isColor = NO;
        }
        else
        {
            printf("Color image\n");
            isColor = YES;
        }
    }
    else
    {
        if ([srcImageRep samplesPerPixel] == 1)
        {
            printf("Grayscale image\n");
            isColor = NO;
        }
        else
        {
            printf("Color image\n");
            isColor = YES;
        }
    }
    
    /* allocate destination image and its representation */
    destImage = [[PRImage alloc] initWithSize:NSMakeSize(w, h)];
    if (isColor)
    {
        destImageRep = [[NSBitmapImageRep alloc]
                    initWithBitmapDataPlanes:NULL
                    pixelsWide:w
                    pixelsHigh:h
                    bitsPerSample:8
                    samplesPerPixel:3
                    hasAlpha:NO
                    isPlanar:NO
                    colorSpaceName:NSCalibratedRGBColorSpace
                    bytesPerRow:0
                    bitsPerPixel:0];
    } else
    {
        destImageRep = [[NSBitmapImageRep alloc]
                    initWithBitmapDataPlanes:NULL
                    pixelsWide:w
                    pixelsHigh:h
                    bitsPerSample:8
                    samplesPerPixel:1
                    hasAlpha:NO
                    isPlanar:NO
                    colorSpaceName:NSCalibratedWhiteColorSpace
                    bytesPerRow:0
                    bitsPerPixel:0];
    }
    srcData = [srcImageRep bitmapData];
    destData = [destImageRep bitmapData];
    
    if (isColor)
    {
        for (y = 0; y < h; y++)
            for (x = 0; x < w; x++)
            {
                tempValue = rint((float)(srcData[bytesPerPixel*(y*w + x)] - HALF_CHAR + bri) * con + HALF_CHAR);
                if (tempValue > UCHAR_MAX)
                    tempValue = UCHAR_MAX;
                else if (tempValue < 0)
                    tempValue = 0;
                destData[bytesPerPixel*(y*w + x)] = tempValue;

                tempValue = rint((float)(srcData[bytesPerPixel*(y*w + x) + 1] - HALF_CHAR + bri) * con + HALF_CHAR);
                if (tempValue > UCHAR_MAX)
                    tempValue = UCHAR_MAX;
                else if (tempValue < 0)
                    tempValue = 0;
                destData[bytesPerPixel*(y*w + x) + 1] = tempValue;

                tempValue = rint((float)(srcData[bytesPerPixel*(y*w + x) + 2] - HALF_CHAR + bri) * con + HALF_CHAR);
                if (tempValue > UCHAR_MAX)
                    tempValue = UCHAR_MAX;
                else if (tempValue < 0)
                    tempValue = 0;
                destData[bytesPerPixel*(y*w + x) + 2] = tempValue;
            }
    } else
    {
        for (y = 0; y < h; y++)
            for (x = 0; x < w; x++)
            {
                tempValue = rint((float)(srcData[y*w + x] - HALF_CHAR + bri) * con + HALF_CHAR);
                if (tempValue > UCHAR_MAX)
                    tempValue = UCHAR_MAX;
                else if (tempValue < 0)
                    tempValue = 0;
                destData[y*w + x] = tempValue;
            }
    }
    
    [destImage addRepresentation:destImageRep];
    [destImageRep release];
    [destImage autorelease];
    return destImage;
}

@end
