//
//  PRCConvolve55.m
//  PRICE
//  Convolve 5x5 Controller
//
//  Created by Riccardo Mottola on Tue Jan 21 2003.
//  Copyright (c) 2003-2004 Carduus. All rights reserved.
//
// This program is free software; you can redistribute it and/or modify it under the terms of the version 2 of the GNU General Public License as published by the Free Software Foundation.
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

#import "PRCConvolve55.h"
#import "MyDocument.h"

@implementation PRCConvolve55

- (IBAction)showConvolve55:(id)sender
{
    if (!filterWindow)
        [NSBundle loadNibNamed:@"Convolve55" owner:self];
    [filterWindow makeKeyAndOrderFront:nil];
    convMatrix[0][0] = [matField11 intValue];
    convMatrix[0][1] = [matField12 intValue];
    convMatrix[0][2] = [matField13 intValue];
    convMatrix[0][3] = [matField14 intValue];
    convMatrix[0][4] = [matField15 intValue];
    convMatrix[1][0] = [matField21 intValue];
    convMatrix[1][1] = [matField22 intValue];
    convMatrix[1][2] = [matField23 intValue];
    convMatrix[1][3] = [matField24 intValue];
    convMatrix[1][4] = [matField25 intValue];
    convMatrix[2][0] = [matField31 intValue];
    convMatrix[2][1] = [matField32 intValue];
    convMatrix[2][2] = [matField33 intValue];
    convMatrix[2][3] = [matField34 intValue];
    convMatrix[2][4] = [matField35 intValue];
    convMatrix[3][0] = [matField41 intValue];
    convMatrix[3][1] = [matField42 intValue];
    convMatrix[3][2] = [matField43 intValue];
    convMatrix[3][3] = [matField44 intValue];
    convMatrix[3][4] = [matField45 intValue];
    convMatrix[4][0] = [matField51 intValue];
    convMatrix[4][1] = [matField52 intValue];
    convMatrix[4][2] = [matField53 intValue];
    convMatrix[4][3] = [matField54 intValue];
    convMatrix[4][4] = [matField55 intValue];
    if ([autoScaleCheck state] == NSOnState)
    {
        [scaleField setEnabled:NO];
        [offsetField setEnabled:NO];
        autoScale = YES;
    } else
    {
        [scaleField setEnabled:YES];
        [offsetField setEnabled:YES];
        autoScale = NO;
    }
    offset = [offsetField intValue];
    scale = [scaleField floatValue];
}

- (IBAction)convMatrix11:(id)sender
{
    convMatrix[0][0] = [sender intValue];
}
- (IBAction)convMatrix12:(id)sender
{
    convMatrix[0][1] = [sender intValue];
}
- (IBAction)convMatrix13:(id)sender
{
    convMatrix[0][2] = [sender intValue];
}
- (IBAction)convMatrix14:(id)sender
{
    convMatrix[0][3] = [sender intValue];
}
- (IBAction)convMatrix15:(id)sender
{
    convMatrix[0][4] = [sender intValue];
}
- (IBAction)convMatrix21:(id)sender
{
    convMatrix[1][0] = [sender intValue];
}
- (IBAction)convMatrix22:(id)sender
{
    convMatrix[1][1] = [sender intValue];
}
- (IBAction)convMatrix23:(id)sender
{
    convMatrix[1][2] = [sender intValue];
}
- (IBAction)convMatrix24:(id)sender
{
    convMatrix[1][3] = [sender intValue];
}
- (IBAction)convMatrix25:(id)sender
{
    convMatrix[1][4] = [sender intValue];
}
- (IBAction)convMatrix31:(id)sender
{
    convMatrix[2][0] = [sender intValue];
}
- (IBAction)convMatrix32:(id)sender
{
    convMatrix[2][1] = [sender intValue];
}
- (IBAction)convMatrix33:(id)sender
{
    convMatrix[2][2] = [sender intValue];
}
- (IBAction)convMatrix34:(id)sender
{
    convMatrix[2][3] = [sender intValue];
}
- (IBAction)convMatrix35:(id)sender
{
    convMatrix[2][4] = [sender intValue];
}
- (IBAction)convMatrix41:(id)sender
{
    convMatrix[3][0] = [sender intValue];
}
- (IBAction)convMatrix42:(id)sender
{
    convMatrix[3][1] = [sender intValue];
}
- (IBAction)convMatrix43:(id)sender
{
    convMatrix[3][2] = [sender intValue];
}
- (IBAction)convMatrix44:(id)sender
{
    convMatrix[3][3] = [sender intValue];
}
- (IBAction)convMatrix45:(id)sender
{
    convMatrix[3][4] = [sender intValue];
}
- (IBAction)convMatrix51:(id)sender
{
    convMatrix[4][0] = [sender intValue];
}
- (IBAction)convMatrix52:(id)sender
{
    convMatrix[4][1] = [sender intValue];
}
- (IBAction)convMatrix53:(id)sender
{
    convMatrix[4][2] = [sender intValue];
}
- (IBAction)convMatrix54:(id)sender
{
    convMatrix[4][3] = [sender intValue];
}
- (IBAction)convMatrix55:(id)sender
{
    convMatrix[4][4] = [sender intValue];
}

- (IBAction)autoRange:(id)sender
{
    autoScale = !autoScale;
    if (autoScale)
    {
        [scaleField setEnabled:NO];
        [offsetField setEnabled:NO];
    } else
    {
        [scaleField setEnabled:YES];
        [offsetField setEnabled:YES];
    }
}

- (IBAction)scaleFactor:(id)sender
{
    scale = [sender floatValue];
}

- (IBAction)offsetFactor:(id)sender
{
    offset = [sender intValue];
}

- (IBAction)conv55Cancel:(id)sender
{
    [filterWindow performClose:nil];
}

- (IBAction)conv55OK:(id)sender
{
    PRCProgress *convProgr;
    
    convProgr = [[PRCProgress alloc] init];
    [convProgr showProgress:self];
    [convProgr setTitle: @"Convolve 5x5"];
    
    [[[NSDocumentController sharedDocumentController] currentDocument] makeConvolve55:convMatrix :offset :scale :autoScale :convProgr];
    
    [convProgr release];
    if ([[NSApp delegate] prefClosePanels])
        [filterWindow performClose:nil];
}

@end
