//
//  MyDocument.h
//  PRICE
//
//  Created by Riccardo Mottola on Thu Dec 12 2002.
//  Copyright (c) 2003 Carduus. All rights reserved.
//
// This program is free software; you can redistribute it and/or modify it under the terms of the version 2 of the GNU General Public License as published by the Free Software Foundation.
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

#import <AppKit/AppKit.h>
#import "PRWindowController.h"
#import "PRCProgress.h"
#import "AppController.h" /* so all other controllers have this included */
#import "PRImage.h"


@interface MyDocument : NSDocument
{
    PRWindowController *windowController;
    @private PRImage   *activeImage;
    @private PRImage   *oldImage;
}

- (NSWindow *)window;
- (NSView *)view;
- (PRImage *)activeImage;
- (void)setActiveImage: (PRImage *)theImage;
- (void)makeGrayscale :(id)sender;
- (void)makeDFT :(id)sender;
- (void)makeDFTLowPass :(BOOL)autoRange :(float) bandPassFreq :(float) bandStopFreq :(PRCProgress *)prPan;
- (void)makeDFTHighPass :(BOOL)autoRange :(float) bandPassFreq :(float) bandStopFreq :(PRCProgress *)prPan;
- (void)makeConvolve55 :(int[5][5])mat :(int)offset :(float)scale :(BOOL)autoScale :(PRCProgress *)prPan;
- (void)makeTransposed :(id)sender;
- (void)makeRotated90 :(id)sender;
- (void)makeRotated180 :(id)sender;
- (void)makeRotated270 :(id)sender;
- (void)makeFlippedVert :(id)sender;
- (void)makeFlippedHoriz :(id)sender;
- (void)makeEqualization :(id)sender;
- (void)makeBriCon :(int)bri :(float)con;
- (void)makeTraceEdges :(int)filterType :(BOOL)useTh :(float)thLev :(BOOL)doZeroC;
- (void)makeCustTraceEdges :(int)filterType :(float)thLev :(BOOL)doZeroC :(BOOL)do1 :(enum medianForms)form1 :(int)size1 :(BOOL)sep1 :(BOOL)do2 :(enum medianForms)form2 :(int)size2 :(BOOL)sep2 :(BOOL)do3 :(enum medianForms)form3 :(int)size3 :(BOOL)sep3 :(PRCProgress *)prPan;
- (void)makeMedian :(enum medianForms)form :(int)size :(BOOL)sep :(PRCProgress *)prPan;
- (void)makeScale :(int)sizeX :(int)sizeY :(int)method :(PRCProgress *)prPan;
- (void)makeCrop :(int)sizeTop :(int)sizeBottom :(int)sizeLeft :(int)sizeRight;
- (void)restoreLastImage;
- (void)saveCurrentImage;
@end
