/* Copyright (C) 1999-2000 Bernhard Trummer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: textnode.cc,v $
 * Revision 1.2  2001/04/27 20:02:50  slash
 * Make use of xmlChildrenNode and xmlRootNode.
 *
 * Revision 1.1.1.1  2001/01/30 18:36:24  slash
 * Initial release.
 *
 */

#include "main.h"
#include "parameters.h"
#include "contentnode.h"
#include "boldnode.h"
#include "emphnode.h"
#include "ttnode.h"
#include "brnode.h"
#include "urlnode.h"  // obsolete
#include "anode.h"
#include "textnode.h"


//---------------------------------------------------------------------------
TextNode::TextNode(xmlNodePtr node,
                   int with_margin) : EnvironmentNode()
{
    with_margin_ = with_margin;

    for (node = node->xmlChildrenNode; node; node = node->next) {
        if (node->type == XML_TEXT_NODE) {
            child_nodes_.push_back(new ContentNode(node));
        } else if (!strcmp((char*)node->name,"bold")) {
            child_nodes_.push_back(new BoldNode(node));
        } else if (!strcmp((char*)node->name,"emph")) {
            child_nodes_.push_back(new EmphNode(node));
        } else if (!strcmp((char*)node->name,"tt")) {
            child_nodes_.push_back(new TTNode(node));
        } else if (!strcmp((char*)node->name,"br")) {
            child_nodes_.push_back(new BRNode(node));
        } else if (!strcmp((char*)node->name,"url")) {  // obsolete
            child_nodes_.push_back(new URLNode(node));
        } else if (!strcmp((char*)node->name,"a")) {
            child_nodes_.push_back(new ANode(node));
        } else {
            Number_Of_Errors_++;
        }
    }
}

//---------------------------------------------------------------------------
TextNode::~TextNode()
{
}


//---------------------------------------------------------------------------
void TextNode::writeHTML(int parameter) const
{
    if (with_margin_ == 1) {
        Output_ << "<DIV class=\"text\">" << endl;
    }

    Output_ << "<P class=\"text\">";
    for (unsigned int i=0; i<child_nodes_.size(); i++) {
        child_nodes_[i]->writeHTML();
    }
    Output_ << "</P>" << endl;

    if (with_margin_ == 1) {
        Output_ << "</DIV>" << endl;
    }
}

//---------------------------------------------------------------------------
void TextNode::writeLaTeX() const
{
    for (unsigned int i=0; i<child_nodes_.size(); i++) {
//         if (!Parameters_.isOutlineEnabled()) {
//             Output_ << "\\noindent" << endl;
//         }
        child_nodes_[i]->writeLaTeX();
    }
}

//---------------------------------------------------------------------------
void TextNode::writeXML() const
{
    Output_ << "<text>";
    for (unsigned int i=0; i<child_nodes_.size(); i++) {
        child_nodes_[i]->writeXML();
    }
    Output_ << "</text>" << endl;
}


//---------------------------------------------------------------------------
int TextNode::isHTMLStepped() const
{
    return 0;
}

//---------------------------------------------------------------------------
unsigned int TextNode::getNumberOfHTMLSteps() const
{
    return 0;
}
