/* Copyright (C) 1999-2000 Bernhard Trummer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: outputfilter.h,v $
 * Revision 1.2  2001/04/20 15:40:36  slash
 * Make use of the function xmlGetProp().
 *
 * Revision 1.1.1.1  2001/01/30 18:36:39  slash
 * Initial release.
 *
 */

#ifndef OUTPUTFILTER_H
#define OUTPUTFILTER_H

//---------------------------------------------------------------------------
/**
 * This class just contains some static methods to provide an
 * output-interface for HTML and LaTeX.
 * These methods will also take care of necessary character-encodings.
 */
class OutputFilter 
{
  public:
    //-----------------------------------------------------------------------
    /**
     * This method writes the given text
     * to the global output filestream Output_.
     * The format of the output is HTML.
     *
     * @param text The text, which should be written.
     * @param skip_first_newlines Indicates, if the first newlines in the text
     *                            should be skipped.
     */
    static void writeHTML(const char *text,
                          int skip_first_newlines);

    //-----------------------------------------------------------------------
    /**
     * This method writes the given text
     * to the global output filestream Output_.
     * The format of the output is LaTeX.
     *
     * @param text The text, which should be written.
     * @param latex_encode Indicates, if special characters should be encoded.
     */
    static void writeLaTeX(const char *text,
                           int latex_encode);

    //-----------------------------------------------------------------------
    /**
     * This method writes the given text
     * to the global output filestream Output_.
     * The format of the output is XML.
     *
     * @param text The text, which should be written.
     */
    static void writeXML(const char *text);
};

#endif //OUTPUTFILTER_H
