/* Copyright (C) 1999-2000 Bernhard Trummer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: environmentnode.h,v $
 * Revision 1.1.1.1  2001/01/30 18:36:45  slash
 * Initial release.
 *
 */

#ifndef ENVIRONMENTNODE_H
#define ENVIRONMENTNODE_H

#include "node.h"

//---------------------------------------------------------------------------
/**
 * This base-class provides additional interface-methods for all environments.
 */
class EnvironmentNode : public Node { 
  public:
    //-----------------------------------------------------------------------
    /**
     * The constructor initializes the environment-node.
     */
    EnvironmentNode();

    //-----------------------------------------------------------------------
    /**
     * Destructor.
     */
    virtual ~EnvironmentNode();


    //-----------------------------------------------------------------------
    /**
     * This method signals, if the HTML-output of the environment should be
     * stepped. It must be overloaded by all derivated classes.
     *
     * @return 1, if the HTML-output should be stepped, else 0.
     *
     * @see getNumberOfHTMLSteps
     */
    virtual int isHTMLStepped() const = 0;

    //-----------------------------------------------------------------------
    /**
     * This method returns the number of steps of the HTML-output.
     *
     * @return The number of steps.
     */
    virtual unsigned int getNumberOfHTMLSteps() const = 0;


  protected:

    //-----------------------------------------------------------------------
    /**
     * The number of steps for the HTML-output.
     */
    unsigned int number_of_html_steps_;
};

#endif //ENVIRONMENTNODE_H
