/* Copyright (C) 1999-2000 Bernhard Trummer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: datenode.cc,v $
 * Revision 1.2  2001/04/27 20:02:50  slash
 * Make use of xmlChildrenNode and xmlRootNode.
 *
 * Revision 1.1.1.1  2001/01/30 18:36:22  slash
 * Initial release.
 *
 */

#include "main.h"
#include "parameters.h"
#include "contentnode.h"
#include "datenode.h"


//---------------------------------------------------------------------------
DateNode::DateNode(xmlNodePtr node) : Node()
{
    for (node = node->xmlChildrenNode; node; node = node->next) {
        if (node->type == XML_TEXT_NODE) {
            child_nodes_.push_back(new ContentNode(node));
        } else {
            Number_Of_Errors_++;
        }
    }
}

//---------------------------------------------------------------------------
DateNode::~DateNode()
{
}


//---------------------------------------------------------------------------
void DateNode::writeHTML(int parameter) const
{
    Output_ << "<P class=\"date\">";
    for (unsigned int i=0; i<child_nodes_.size(); i++) {
        child_nodes_[i]->writeLaTeX();
    }
    Output_ << "</P>" << endl;
}

//---------------------------------------------------------------------------
void DateNode::writeLaTeX() const
{
    if (!Parameters_.isOutlineEnabled()) {
        Output_ << "\\noindent" << endl;
    }
    for (unsigned int i=0; i<child_nodes_.size(); i++) {
        child_nodes_[i]->writeLaTeX();
    }
}

//---------------------------------------------------------------------------
void DateNode::writeXML() const
{
    Output_ << "<date>";
    for (unsigned int i=0; i<child_nodes_.size(); i++) {
        child_nodes_[i]->writeXML();
    }
    Output_ << "</date>" << endl;
}
