/* Copyright (C) 1999-2000 Bernhard Trummer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: anode.h,v $
 * Revision 1.2  2001/04/20 15:40:36  slash
 * Make use of the function xmlGetProp().
 *
 * Revision 1.1.1.1  2001/01/30 18:36:43  slash
 * Initial release.
 *
 */

#ifndef ANODE_H
#define ANODE_H

#include <string>

#include "inlinenode.h"

//---------------------------------------------------------------------------
/**
 * This class represents an A-node.
 * Note, that this class is to be considered as replacement for the URL-node.
 */
class ANode : public InlineNode { 
  public:
    //-----------------------------------------------------------------------
    /**
     * The constructor initializes the A-node.
     *
     * @param node The XML-node, which represents the A-node.
     */
    ANode(xmlNodePtr node);

    //-----------------------------------------------------------------------
    /**
     * Destructor.
     */
    ~ANode();


  private:

    //-----------------------------------------------------------------------
    /**
     * This member-variable contains the target-URL given in the href-property.
     */
    char *href_;
};

#endif //ANODE_H
