/* Copyright (C) 1999-2000 Bernhard Trummer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: presentation.h,v $
 * Revision 1.1.1.1  2001/01/30 18:36:51  slash
 * Initial release.
 *
 */

#ifndef PRESENTATION_H
#define PRESENTATION_H

#include "node.h"
#include "tocinterface.h"
#include "slidenode.h"

//---------------------------------------------------------------------------
/**
 * This class represents the presentation.
 */
class Presentation : public Node {
  public:
    //-----------------------------------------------------------------------
    /**
     * The constructor.
     */
    Presentation();

    //-----------------------------------------------------------------------
    /**
     * Destructor.
     */
    ~Presentation();


    //-----------------------------------------------------------------------
    /**
     * This method starts the parsing of the XML-file, which name is stored
     * in Parameters_.xml_file_.
     *
     * @return 0, if everything is OK, else -1.
     */
    int parseXMLFile();
    

    //-----------------------------------------------------------------------
    /**
     * This method creates HTML-files for the whole presentation to the
     * target directory given by Parameters_->target_directory_.
     * The theme-files and the HTML-files for each slide will be copied
     * into this target directory.
     *
     * @param parameter A dummy-parameter.
     */
    void writeHTML(int parameter = 0) const;

    //-----------------------------------------------------------------------
    /**
     * This method creates a LaTeX-file for the whole presentation to the
     * target directory given by Parameters_->target_directory_.
     */
    void writeLaTeX() const;

    //-----------------------------------------------------------------------
    /**
     * This method
     */
    void writeXML() const;


  private:

    //-----------------------------------------------------------------------
    /**
     * This helper-method copies all needed theme-files to the
     * target-directory given by Parameters_->target_directory_.
     */
    void copyThemeFiles() const;

    //-----------------------------------------------------------------------
    /**
     * This helper-method creates the table of contents of the presentation.
     */
    void writeTOC() const;


  private:

    //-----------------------------------------------------------------------
    /**
     * A pointer to the root of the generated XML-tree of the inputfile.
     */
    xmlDocPtr xml_tree_;

    //-----------------------------------------------------------------------
    /**
     * This vector holds pointers to all slides and sections in the
     * presentation.
     * This vector will be used to create the table of contents.
     */
    vector<TOCInterface*> toc_nodes_;
};

#endif //PRESENTATION_H
